/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.AbstractNumberParser;
import com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;
import com.fasterxml.jackson.core.io.doubleparser.FastIntegerMath;
import com.fasterxml.jackson.core.io.doubleparser.FftMultiplier;
import com.fasterxml.jackson.core.io.doubleparser.ParseDigitsTaskCharArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NavigableMap;

final class JavaBigDecimalFromCharArray
extends AbstractNumberParser {
    public static final int MAX_INPUT_LENGTH = 1292782635;
    private static final int MANY_DIGITS_THRESHOLD = 32;
    private static final int MAX_DIGIT_COUNT = 1292782621;
    private static final long MAX_EXPONENT_NUMBER = Integer.MAX_VALUE;

    public BigDecimal parseBigDecimalString(char[] str2, int offset, int length) {
        try {
            int exponentIndicatorIndex;
            long exponent;
            int digitCount;
            boolean isNegative;
            int index2;
            if (length >= 32) {
                return this.parseBigDecimalStringWithManyDigits(str2, offset, length);
            }
            long significand = 0L;
            int decimalPointIndex = -1;
            int endIndex = offset + length;
            char ch = JavaBigDecimalFromCharArray.charAt(str2, index2, endIndex);
            boolean illegal = false;
            boolean bl = isNegative = ch == '-';
            if ((isNegative || ch == '+') && (ch = JavaBigDecimalFromCharArray.charAt(str2, ++index2, endIndex)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            int integerPartIndex = index2;
            for (index2 = offset; index2 < endIndex; ++index2) {
                int digits;
                ch = str2[index2];
                if (FastDoubleSwar.isDigit(ch)) {
                    significand = 10L * significand + (long)ch - 48L;
                    continue;
                }
                if (ch != '.') break;
                illegal |= decimalPointIndex >= 0;
                decimalPointIndex = index2;
                while (index2 < endIndex - 4 && (digits = FastDoubleSwar.tryToParseFourDigits(str2, index2 + 1)) >= 0) {
                    significand = 10000L * significand + (long)digits;
                    index2 += 4;
                }
            }
            int significandEndIndex = index2;
            if (decimalPointIndex < 0) {
                digitCount = significandEndIndex - integerPartIndex;
                decimalPointIndex = significandEndIndex;
                exponent = 0L;
            } else {
                digitCount = significandEndIndex - integerPartIndex - 1;
                exponent = decimalPointIndex - significandEndIndex + 1;
            }
            long expNumber = 0L;
            if ((ch | 0x20) == 101) {
                boolean isExponentNegative;
                exponentIndicatorIndex = index2++;
                ch = JavaBigDecimalFromCharArray.charAt(str2, index2, endIndex);
                boolean bl2 = isExponentNegative = ch == '-';
                if (isExponentNegative || ch == '+') {
                    ch = JavaBigDecimalFromCharArray.charAt(str2, ++index2, endIndex);
                }
                illegal |= !FastDoubleSwar.isDigit(ch);
                do {
                    if (expNumber >= Integer.MAX_VALUE) continue;
                    expNumber = 10L * expNumber + (long)ch - 48L;
                } while (FastDoubleSwar.isDigit(ch = JavaBigDecimalFromCharArray.charAt(str2, ++index2, endIndex)));
                if (isExponentNegative) {
                    expNumber = -expNumber;
                }
                exponent += expNumber;
            } else {
                exponentIndicatorIndex = endIndex;
            }
            if (illegal || index2 < endIndex || digitCount == 0 || digitCount > 1292782621) {
                throw new NumberFormatException("illegal syntax");
            }
            if (exponent <= Integer.MIN_VALUE || exponent > Integer.MAX_VALUE) {
                throw new NumberFormatException("value exceeds limits");
            }
            if (digitCount <= 18) {
                return new BigDecimal(isNegative ? -significand : significand).scaleByPowerOfTen((int)exponent);
            }
            return this.valueOfBigDecimalString(str2, integerPartIndex, decimalPointIndex, decimalPointIndex + 1, exponentIndicatorIndex, isNegative, (int)exponent);
        }
        catch (ArithmeticException e2) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e2);
            throw nfe;
        }
    }

    BigDecimal parseBigDecimalStringWithManyDigits(char[] str2, int offset, int length) {
        int exponentIndicatorIndex;
        long exponent;
        int digitCount;
        boolean isNegative;
        int index2;
        if (length > 1292782635) {
            throw new NumberFormatException("illegal syntax");
        }
        int nonZeroFractionalPartIndex = -1;
        int decimalPointIndex = -1;
        int endIndex = offset + length;
        char ch = JavaBigDecimalFromCharArray.charAt(str2, index2, endIndex);
        boolean illegal = false;
        boolean bl = isNegative = ch == '-';
        if ((isNegative || ch == '+') && (ch = JavaBigDecimalFromCharArray.charAt(str2, ++index2, endIndex)) == '\u0000') {
            throw new NumberFormatException("illegal syntax");
        }
        int integerPartIndex = index2;
        int swarLimit = Math.min(endIndex - 8, 0x40000000);
        for (index2 = offset; index2 < swarLimit && FastDoubleSwar.isEightZeroes(str2, index2); index2 += 8) {
        }
        while (index2 < endIndex && str2[index2] == '0') {
            ++index2;
        }
        int nonZeroIntegerPartIndex = index2;
        while (index2 < swarLimit && FastDoubleSwar.isEightDigits(str2, index2)) {
            index2 += 8;
        }
        while (index2 < endIndex && FastDoubleSwar.isDigit(ch = str2[index2])) {
            ++index2;
        }
        if (ch == '.') {
            decimalPointIndex = index2++;
            while (index2 < swarLimit && FastDoubleSwar.isEightZeroes(str2, index2)) {
                index2 += 8;
            }
            while (index2 < endIndex && str2[index2] == '0') {
                ++index2;
            }
            nonZeroFractionalPartIndex = index2;
            while (index2 < swarLimit && FastDoubleSwar.isEightDigits(str2, index2)) {
                index2 += 8;
            }
            while (index2 < endIndex && FastDoubleSwar.isDigit(ch = str2[index2])) {
                ++index2;
            }
        }
        int significandEndIndex = index2;
        if (decimalPointIndex < 0) {
            digitCount = significandEndIndex - nonZeroIntegerPartIndex;
            decimalPointIndex = significandEndIndex;
            nonZeroFractionalPartIndex = significandEndIndex;
            exponent = 0L;
        } else {
            digitCount = nonZeroIntegerPartIndex == decimalPointIndex ? significandEndIndex - nonZeroFractionalPartIndex : significandEndIndex - nonZeroIntegerPartIndex - 1;
            exponent = decimalPointIndex - significandEndIndex + 1;
        }
        long expNumber = 0L;
        if ((ch | 0x20) == 101) {
            boolean isExponentNegative;
            exponentIndicatorIndex = index2++;
            ch = JavaBigDecimalFromCharArray.charAt(str2, index2, endIndex);
            boolean bl2 = isExponentNegative = ch == '-';
            if (isExponentNegative || ch == '+') {
                ch = JavaBigDecimalFromCharArray.charAt(str2, ++index2, endIndex);
            }
            boolean bl3 = illegal = !FastDoubleSwar.isDigit(ch);
            do {
                if (expNumber >= Integer.MAX_VALUE) continue;
                expNumber = 10L * expNumber + (long)ch - 48L;
            } while (FastDoubleSwar.isDigit(ch = JavaBigDecimalFromCharArray.charAt(str2, ++index2, endIndex)));
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        } else {
            exponentIndicatorIndex = endIndex;
        }
        if (illegal || index2 < endIndex) {
            throw new NumberFormatException("illegal syntax");
        }
        if (exponentIndicatorIndex - integerPartIndex == 0) {
            throw new NumberFormatException("illegal syntax");
        }
        if (exponent < Integer.MIN_VALUE || exponent > Integer.MAX_VALUE || digitCount > 1292782621) {
            throw new NumberFormatException("value exceeds limits");
        }
        return this.valueOfBigDecimalString(str2, nonZeroIntegerPartIndex, decimalPointIndex, nonZeroFractionalPartIndex, exponentIndicatorIndex, isNegative, (int)exponent);
    }

    private BigDecimal valueOfBigDecimalString(char[] str2, int integerPartIndex, int decimalPointIndex, int nonZeroFractionalPartIndex, int exponentIndicatorIndex, boolean isNegative, int exponent) {
        BigInteger significand;
        BigInteger integerPart;
        int integerExponent = exponentIndicatorIndex - decimalPointIndex - 1;
        int fractionDigitsCount = exponentIndicatorIndex - nonZeroFractionalPartIndex;
        int integerDigitsCount = decimalPointIndex - integerPartIndex;
        NavigableMap<Integer, BigInteger> powersOfTen = null;
        if (integerDigitsCount > 0) {
            if (integerDigitsCount > 400) {
                powersOfTen = FastIntegerMath.createPowersOfTenFloor16Map();
                FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, integerPartIndex, decimalPointIndex);
                integerPart = ParseDigitsTaskCharArray.parseDigitsRecursive(str2, integerPartIndex, decimalPointIndex, powersOfTen);
            } else {
                integerPart = ParseDigitsTaskCharArray.parseDigitsRecursive(str2, integerPartIndex, decimalPointIndex, null);
            }
        } else {
            integerPart = BigInteger.ZERO;
        }
        if (fractionDigitsCount > 0) {
            BigInteger fractionalPart;
            if (fractionDigitsCount > 400) {
                if (powersOfTen == null) {
                    powersOfTen = FastIntegerMath.createPowersOfTenFloor16Map();
                }
                FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, decimalPointIndex + 1, exponentIndicatorIndex);
                fractionalPart = ParseDigitsTaskCharArray.parseDigitsRecursive(str2, decimalPointIndex + 1, exponentIndicatorIndex, powersOfTen);
            } else {
                fractionalPart = ParseDigitsTaskCharArray.parseDigitsRecursive(str2, decimalPointIndex + 1, exponentIndicatorIndex, null);
            }
            if (integerPart.signum() == 0) {
                significand = fractionalPart;
            } else {
                BigInteger integerFactor = FastIntegerMath.computePowerOfTen(powersOfTen, integerExponent);
                significand = FftMultiplier.multiply(integerPart, integerFactor).add(fractionalPart);
            }
        } else {
            significand = integerPart;
        }
        return new BigDecimal(isNegative ? significand.negate() : significand, -exponent);
    }
}

