/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.AbstractFloatValueParser;
import com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;

abstract class AbstractJavaFloatingPointBitsFromCharArray
extends AbstractFloatValueParser {
    private static final boolean CONDITIONAL_COMPILATION_PARSE_EIGHT_HEX_DIGITS = true;

    AbstractJavaFloatingPointBitsFromCharArray() {
    }

    private static int skipWhitespace(char[] str2, int index2, int endIndex) {
        while (index2 < endIndex && str2[index2] <= ' ') {
            ++index2;
        }
        return index2;
    }

    abstract long nan();

    abstract long negativeInfinity();

    private long parseDecFloatLiteral(char[] str2, int index2, int startIndex, int endIndex, boolean isNegative, boolean hasLeadingZero) {
        int exponentOfTruncatedSignificand;
        boolean isSignificandTruncated;
        int exponent;
        int digitCount;
        long significand = 0L;
        int significandStartIndex = index2;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        char ch = '\u0000';
        int swarLimit = Math.min(endIndex - 4, 0x40000000);
        while (index2 < endIndex) {
            ch = str2[index2];
            if (FastDoubleSwar.isDigit(ch)) {
                significand = 10L * significand + (long)ch - 48L;
            } else {
                int digits;
                if (ch != '.') break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index2;
                while (index2 < swarLimit && (digits = FastDoubleSwar.tryToParseFourDigits(str2, index2 + 1)) >= 0) {
                    significand = 10000L * significand + (long)digits;
                    index2 += 4;
                }
            }
            ++index2;
        }
        int significandEndIndex = index2;
        if (virtualIndexOfPoint < 0) {
            digitCount = significandEndIndex - significandStartIndex;
            virtualIndexOfPoint = significandEndIndex;
            exponent = 0;
        } else {
            digitCount = significandEndIndex - significandStartIndex - 1;
            exponent = virtualIndexOfPoint - significandEndIndex + 1;
        }
        int expNumber = 0;
        if ((ch | 0x20) == 101) {
            boolean isExponentNegative;
            boolean bl = isExponentNegative = (ch = AbstractJavaFloatingPointBitsFromCharArray.charAt(str2, ++index2, endIndex)) == '-';
            if (isExponentNegative || ch == '+') {
                ch = AbstractJavaFloatingPointBitsFromCharArray.charAt(str2, ++index2, endIndex);
            }
            illegal |= !FastDoubleSwar.isDigit(ch);
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + ch - 48;
            } while (FastDoubleSwar.isDigit(ch = AbstractJavaFloatingPointBitsFromCharArray.charAt(str2, ++index2, endIndex)));
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (ch == 'd' | ch == 'D' | ch == 'f' | ch == 'F') {
            ++index2;
        }
        index2 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(str2, index2, endIndex);
        if (illegal || index2 < endIndex || !hasLeadingZero && digitCount == 0) {
            throw new NumberFormatException("illegal syntax");
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 19) {
            significand = 0L;
            for (index2 = significandStartIndex; index2 < significandEndIndex; ++index2) {
                ch = str2[index2];
                if (ch == '.') {
                    ++skipCountInTruncatedDigits;
                    continue;
                }
                if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                significand = 10L * significand + (long)ch - 48L;
            }
            isSignificandTruncated = index2 < significandEndIndex;
            exponentOfTruncatedSignificand = virtualIndexOfPoint - index2 + skipCountInTruncatedDigits + expNumber;
        } else {
            isSignificandTruncated = false;
            exponentOfTruncatedSignificand = 0;
        }
        return this.valueOfFloatLiteral(str2, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
    }

    public long parseFloatingPointLiteral(char[] str2, int offset, int length) {
        boolean hasLeadingZero;
        boolean isNegative;
        int endIndex = offset + length;
        if (offset < 0 || endIndex < offset || endIndex > str2.length || length > 0x7FFFFFFB) {
            throw new IllegalArgumentException("offset < 0 or length > str.length");
        }
        int index2 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(str2, offset, endIndex);
        if (index2 == endIndex) {
            throw new NumberFormatException("illegal syntax");
        }
        char ch = str2[index2];
        boolean bl = isNegative = ch == '-';
        if ((isNegative || ch == '+') && (ch = AbstractJavaFloatingPointBitsFromCharArray.charAt(str2, ++index2, endIndex)) == '\u0000') {
            throw new NumberFormatException("illegal syntax");
        }
        if (ch >= 'I') {
            return this.parseNaNOrInfinity(str2, index2, endIndex, isNegative);
        }
        boolean bl2 = hasLeadingZero = ch == '0';
        if (hasLeadingZero && ((ch = AbstractJavaFloatingPointBitsFromCharArray.charAt(str2, ++index2, endIndex)) == 'x' || ch == 'X')) {
            return this.parseHexFloatLiteral(str2, index2 + 1, offset, endIndex, isNegative);
        }
        return this.parseDecFloatLiteral(str2, index2, offset, endIndex, isNegative, hasLeadingZero);
    }

    private long parseHexFloatLiteral(char[] str2, int index2, int startIndex, int endIndex, boolean isNegative) {
        boolean isSignificandTruncated;
        boolean hasExponent;
        int digitCount;
        long significand = 0L;
        int exponent = 0;
        int significandStartIndex = index2;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        char ch = '\u0000';
        while (index2 < endIndex) {
            ch = str2[index2];
            int hexValue = AbstractJavaFloatingPointBitsFromCharArray.lookupHex(ch);
            if (hexValue >= 0) {
                significand = significand << 4 | (long)hexValue;
            } else {
                long parsed;
                if (hexValue != -4) break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index2;
                while (index2 < endIndex - 8 && (parsed = this.tryToParseEightHexDigits(str2, index2 + 1)) >= 0L) {
                    significand = (significand << 32) + parsed;
                    index2 += 8;
                }
            }
            ++index2;
        }
        int significandEndIndex = index2;
        if (virtualIndexOfPoint < 0) {
            digitCount = significandEndIndex - significandStartIndex;
            virtualIndexOfPoint = significandEndIndex;
        } else {
            digitCount = significandEndIndex - significandStartIndex - 1;
            exponent = Math.min(virtualIndexOfPoint - index2 + 1, 1024) * 4;
        }
        int expNumber = 0;
        boolean bl = hasExponent = (ch | 0x20) == 112;
        if (hasExponent) {
            boolean isExponentNegative;
            boolean bl2 = isExponentNegative = (ch = AbstractJavaFloatingPointBitsFromCharArray.charAt(str2, ++index2, endIndex)) == '-';
            if (isExponentNegative || ch == '+') {
                ch = AbstractJavaFloatingPointBitsFromCharArray.charAt(str2, ++index2, endIndex);
            }
            illegal |= !FastDoubleSwar.isDigit(ch);
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + ch - 48;
            } while (FastDoubleSwar.isDigit(ch = AbstractJavaFloatingPointBitsFromCharArray.charAt(str2, ++index2, endIndex)));
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (ch == 'd' | ch == 'D' | ch == 'f' | ch == 'F') {
            ++index2;
        }
        index2 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(str2, index2, endIndex);
        if (illegal || index2 < endIndex || digitCount == 0 || !hasExponent) {
            throw new NumberFormatException("illegal syntax");
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 16) {
            significand = 0L;
            for (index2 = significandStartIndex; index2 < significandEndIndex; ++index2) {
                ch = str2[index2];
                int hexValue = AbstractJavaFloatingPointBitsFromCharArray.lookupHex(ch);
                if (hexValue >= 0) {
                    if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                    significand = significand << 4 | (long)hexValue;
                    continue;
                }
                ++skipCountInTruncatedDigits;
            }
            isSignificandTruncated = index2 < significandEndIndex;
        } else {
            isSignificandTruncated = false;
        }
        return this.valueOfHexLiteral(str2, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, (virtualIndexOfPoint - index2 + skipCountInTruncatedDigits) * 4 + expNumber);
    }

    private long parseNaNOrInfinity(char[] str2, int index2, int endIndex, boolean isNegative) {
        if (str2[index2] == 'N') {
            if (index2 + 2 < endIndex && str2[index2 + 1] == 'a' && str2[index2 + 2] == 'N' && (index2 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(str2, index2 + 3, endIndex)) == endIndex) {
                return this.nan();
            }
        } else if (index2 + 7 < endIndex && str2[index2] == 'I' && str2[index2 + 1] == 'n' && str2[index2 + 2] == 'f' && str2[index2 + 3] == 'i' && str2[index2 + 4] == 'n' && str2[index2 + 5] == 'i' && str2[index2 + 6] == 't' && str2[index2 + 7] == 'y' && (index2 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(str2, index2 + 8, endIndex)) == endIndex) {
            return isNegative ? this.negativeInfinity() : this.positiveInfinity();
        }
        throw new NumberFormatException("illegal syntax");
    }

    abstract long positiveInfinity();

    private long tryToParseEightHexDigits(char[] str2, int offset) {
        return FastDoubleSwar.tryToParseEightHexDigits(str2, offset);
    }

    abstract long valueOfFloatLiteral(char[] var1, int var2, int var3, boolean var4, long var5, int var7, boolean var8, int var9);

    abstract long valueOfHexLiteral(char[] var1, int var2, int var3, boolean var4, long var5, int var7, boolean var8, int var9);
}

