/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IHashEq;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.Murmur3;
import clojure.lang.Named;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class Symbol
extends AFn
implements IObj,
Comparable,
Named,
Serializable,
IHashEq {
    final String ns;
    final String name;
    private int _hasheq;
    final IPersistentMap _meta;
    transient String _str;

    public String toString() {
        if (this._str == null) {
            this._str = this.ns != null ? this.ns + "/" + this.name : this.name;
        }
        return this._str;
    }

    @Override
    public String getNamespace() {
        return this.ns;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static Symbol create(String ns2, String name2) {
        return Symbol.intern(ns2, name2);
    }

    public static Symbol create(String nsname) {
        return Symbol.intern(nsname);
    }

    public static Symbol intern(String ns2, String name2) {
        return new Symbol(ns2, name2);
    }

    public static Symbol intern(String nsname) {
        int i = nsname.indexOf(47);
        if (i == -1 || nsname.equals("/")) {
            return new Symbol(null, nsname);
        }
        return new Symbol(nsname.substring(0, i), nsname.substring(i + 1));
    }

    private Symbol(String ns_interned, String name_interned) {
        this.name = name_interned;
        this.ns = ns_interned;
        this._meta = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol symbol2 = (Symbol)o;
        return Util.equals(this.ns, symbol2.ns) && this.name.equals(symbol2.name);
    }

    public int hashCode() {
        return Util.hashCombine(this.name.hashCode(), Util.hash(this.ns));
    }

    @Override
    public int hasheq() {
        if (this._hasheq == 0) {
            this._hasheq = Util.hashCombine(Murmur3.hashUnencodedChars(this.name), Util.hash(this.ns));
        }
        return this._hasheq;
    }

    @Override
    public IObj withMeta(IPersistentMap meta) {
        return new Symbol(meta, this.ns, this.name);
    }

    private Symbol(IPersistentMap meta, String ns2, String name2) {
        this.name = name2;
        this.ns = ns2;
        this._meta = meta;
    }

    public int compareTo(Object o) {
        Symbol s2 = (Symbol)o;
        if (this.equals(o)) {
            return 0;
        }
        if (this.ns == null && s2.ns != null) {
            return -1;
        }
        if (this.ns != null) {
            if (s2.ns == null) {
                return 1;
            }
            int nsc = this.ns.compareTo(s2.ns);
            if (nsc != 0) {
                return nsc;
            }
        }
        return this.name.compareTo(s2.name);
    }

    private Object readResolve() throws ObjectStreamException {
        return Symbol.intern(this.ns, this.name);
    }

    @Override
    public Object invoke(Object obj2) {
        return RT.get(obj2, this);
    }

    @Override
    public Object invoke(Object obj2, Object notFound) {
        return RT.get(obj2, this, notFound);
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }
}

