/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IMapEntry;
import clojure.lang.IMapIterable;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.MapEntry;
import clojure.lang.MapEquivalence;
import clojure.lang.Murmur3;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class APersistentMap
extends AFn
implements IPersistentMap,
Map,
Iterable,
Serializable,
MapEquivalence,
IHashEq {
    int _hash = -1;
    int _hasheq = -1;
    static final IFn MAKE_ENTRY = new AFn(){

        @Override
        public Object invoke(Object key2, Object val2) {
            return MapEntry.create(key2, val2);
        }
    };
    static final IFn MAKE_KEY = new AFn(){

        @Override
        public Object invoke(Object key2, Object val2) {
            return key2;
        }
    };
    static final IFn MAKE_VAL = new AFn(){

        @Override
        public Object invoke(Object key2, Object val2) {
            return val2;
        }
    };

    public String toString() {
        return RT.printString(this);
    }

    @Override
    public IPersistentCollection cons(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e2 = (Map.Entry)o;
            return this.assoc(e2.getKey(), e2.getValue());
        }
        if (o instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)o;
            if (v.count() != 2) {
                throw new IllegalArgumentException("Vector arg to map conj must be a pair");
            }
            return this.assoc(v.nth(0), v.nth(1));
        }
        IPersistentMap ret = this;
        for (ISeq es = RT.seq(o); es != null; es = es.next()) {
            Map.Entry e3 = (Map.Entry)es.first();
            ret = ret.assoc(e3.getKey(), e3.getValue());
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj2) {
        return APersistentMap.mapEquals(this, obj2);
    }

    public static boolean mapEquals(IPersistentMap m1, Object obj2) {
        if (m1 == obj2) {
            return true;
        }
        if (!(obj2 instanceof Map)) {
            return false;
        }
        Map m4 = (Map)obj2;
        if (m4.size() != m1.count()) {
            return false;
        }
        for (ISeq s2 = m1.seq(); s2 != null; s2 = s2.next()) {
            Map.Entry e2 = (Map.Entry)s2.first();
            boolean found = m4.containsKey(e2.getKey());
            if (found && Util.equals(e2.getValue(), m4.get(e2.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equiv(Object obj2) {
        if (!(obj2 instanceof Map)) {
            return false;
        }
        if (obj2 instanceof IPersistentMap && !(obj2 instanceof MapEquivalence)) {
            return false;
        }
        Map m4 = (Map)obj2;
        if (m4.size() != this.size()) {
            return false;
        }
        for (ISeq s2 = this.seq(); s2 != null; s2 = s2.next()) {
            Map.Entry e2 = (Map.Entry)s2.first();
            boolean found = m4.containsKey(e2.getKey());
            if (found && Util.equiv(e2.getValue(), m4.get(e2.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            this._hash = APersistentMap.mapHash(this);
        }
        return this._hash;
    }

    public static int mapHash(IPersistentMap m4) {
        int hash2 = 0;
        for (ISeq s2 = m4.seq(); s2 != null; s2 = s2.next()) {
            Map.Entry e2 = (Map.Entry)s2.first();
            hash2 += (e2.getKey() == null ? 0 : e2.getKey().hashCode()) ^ (e2.getValue() == null ? 0 : e2.getValue().hashCode());
        }
        return hash2;
    }

    @Override
    public int hasheq() {
        if (this._hasheq == -1) {
            this._hasheq = Murmur3.hashUnordered(this);
        }
        return this._hasheq;
    }

    public static int mapHasheq(IPersistentMap m4) {
        return Murmur3.hashUnordered(m4);
    }

    @Override
    public Object invoke(Object arg1) {
        return this.valAt(arg1);
    }

    @Override
    public Object invoke(Object arg1, Object notFound) {
        return this.valAt(arg1, notFound);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return APersistentMap.this.iterator();
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }

            @Override
            public int hashCode() {
                return APersistentMap.this.hashCode();
            }

            @Override
            public boolean contains(Object o) {
                Map.Entry e2;
                IMapEntry found;
                return o instanceof Map.Entry && (found = APersistentMap.this.entryAt((e2 = (Map.Entry)o).getKey())) != null && Util.equals(found.getValue(), e2.getValue());
            }
        };
    }

    public Object get(Object key2) {
        return this.valAt(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e2 = (Map.Entry)mi.next();
                        return e2.getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }

            @Override
            public boolean contains(Object o) {
                return APersistentMap.this.containsKey(o);
            }
        };
    }

    public Object put(Object key2, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t3) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count();
    }

    public Collection values() {
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e2 = (Map.Entry)mi.next();
                        return e2.getValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }
        };
    }

    public static class ValSeq
    extends ASeq {
        final ISeq seq;
        final Iterable iterable;

        public static ValSeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new ValSeq(seq, null);
        }

        public static ValSeq createFromMap(IPersistentMap map2) {
            if (map2 == null) {
                return null;
            }
            ISeq seq = map2.seq();
            if (seq == null) {
                return null;
            }
            return new ValSeq(seq, map2);
        }

        private ValSeq(ISeq seq, Iterable iterable) {
            this.seq = seq;
            this.iterable = iterable;
        }

        private ValSeq(IPersistentMap meta, ISeq seq, Iterable iterable) {
            super(meta);
            this.seq = seq;
            this.iterable = iterable;
        }

        @Override
        public Object first() {
            return ((Map.Entry)this.seq.first()).getValue();
        }

        @Override
        public ISeq next() {
            return ValSeq.create(this.seq.next());
        }

        @Override
        public ValSeq withMeta(IPersistentMap meta) {
            return new ValSeq(meta, this.seq, this.iterable);
        }

        @Override
        public Iterator iterator() {
            if (this.iterable == null) {
                return super.iterator();
            }
            if (this.iterable instanceof IMapIterable) {
                return ((IMapIterable)((Object)this.iterable)).valIterator();
            }
            final Iterator mapIter = this.iterable.iterator();
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return mapIter.hasNext();
                }

                public Object next() {
                    return ((Map.Entry)mapIter.next()).getValue();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class KeySeq
    extends ASeq {
        final ISeq seq;
        final Iterable iterable;

        public static KeySeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new KeySeq(seq, null);
        }

        public static KeySeq createFromMap(IPersistentMap map2) {
            if (map2 == null) {
                return null;
            }
            ISeq seq = map2.seq();
            if (seq == null) {
                return null;
            }
            return new KeySeq(seq, map2);
        }

        private KeySeq(ISeq seq, Iterable iterable) {
            this.seq = seq;
            this.iterable = iterable;
        }

        private KeySeq(IPersistentMap meta, ISeq seq, Iterable iterable) {
            super(meta);
            this.seq = seq;
            this.iterable = iterable;
        }

        @Override
        public Object first() {
            return ((Map.Entry)this.seq.first()).getKey();
        }

        @Override
        public ISeq next() {
            return KeySeq.create(this.seq.next());
        }

        @Override
        public KeySeq withMeta(IPersistentMap meta) {
            return new KeySeq(meta, this.seq, this.iterable);
        }

        @Override
        public Iterator iterator() {
            if (this.iterable == null) {
                return super.iterator();
            }
            if (this.iterable instanceof IMapIterable) {
                return ((IMapIterable)((Object)this.iterable)).keyIterator();
            }
            final Iterator mapIter = this.iterable.iterator();
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return mapIter.hasNext();
                }

                public Object next() {
                    return ((Map.Entry)mapIter.next()).getKey();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

