/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Token;
import java.util.List;

public class Parser {
    public static final String EXPECTING_DATA_AFTER_LEFT_ACCOLADE = "Expecting at least a literal between left accolade and ':-'";
    final List<Token> tokenList;
    int pointer = 0;

    public Parser(List<Token> tokenList) {
        this.tokenList = tokenList;
    }

    public Node parse() throws ScanException {
        if (this.tokenList == null || this.tokenList.isEmpty()) {
            return null;
        }
        return this.E();
    }

    private Node E() throws ScanException {
        Node t3 = this.T();
        if (t3 == null) {
            return null;
        }
        Node eOpt = this.Eopt();
        if (eOpt != null) {
            t3.append(eOpt);
        }
        return t3;
    }

    private Node Eopt() throws ScanException {
        Token next2 = this.peekAtCurentToken();
        if (next2 == null) {
            return null;
        }
        return this.E();
    }

    private Node T() throws ScanException {
        Token t3 = this.peekAtCurentToken();
        if (t3 == null) {
            return null;
        }
        switch (t3.type) {
            case LITERAL: {
                this.advanceTokenPointer();
                return this.makeNewLiteralNode(t3.payload);
            }
            case CURLY_LEFT: {
                this.advanceTokenPointer();
                Node innerNode = this.C();
                Token right2 = this.peekAtCurentToken();
                this.expectCurlyRight(right2);
                this.advanceTokenPointer();
                Node curlyLeft = this.makeNewLiteralNode(CoreConstants.LEFT_ACCOLADE);
                curlyLeft.append(innerNode);
                curlyLeft.append(this.makeNewLiteralNode(CoreConstants.RIGHT_ACCOLADE));
                return curlyLeft;
            }
            case START: {
                this.advanceTokenPointer();
                Node v = this.V();
                Token w = this.peekAtCurentToken();
                this.expectCurlyRight(w);
                this.advanceTokenPointer();
                return v;
            }
        }
        return null;
    }

    private Node makeNewLiteralNode(String s2) {
        return new Node(Node.Type.LITERAL, s2);
    }

    private Node V() throws ScanException {
        Node e2 = this.E();
        Node variable = new Node(Node.Type.VARIABLE, e2);
        Token t3 = this.peekAtCurentToken();
        if (this.isDefaultToken(t3)) {
            this.advanceTokenPointer();
            Node def2 = this.Eopt();
            variable.defaultPart = def2 != null ? def2 : this.makeNewLiteralNode("");
        }
        return variable;
    }

    private Node C() throws ScanException {
        Node e0 = this.E();
        Token t3 = this.peekAtCurentToken();
        if (this.isDefaultToken(t3)) {
            this.advanceTokenPointer();
            Node literal = this.makeNewLiteralNode(":-");
            if (e0 == null) {
                throw new ScanException(EXPECTING_DATA_AFTER_LEFT_ACCOLADE);
            }
            e0.append(literal);
            Node e1 = this.E();
            e0.append(e1);
        }
        return e0;
    }

    private boolean isDefaultToken(Token t3) {
        return t3 != null && t3.type == Token.Type.DEFAULT;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token t3, String expected) {
        if (t3 == null) {
            throw new IllegalArgumentException("All tokens consumed but was expecting \"" + expected + "\"");
        }
    }

    void expectCurlyRight(Token t3) throws ScanException {
        this.expectNotNull(t3, "}");
        if (t3.type != Token.Type.CURLY_RIGHT) {
            throw new ScanException("Expecting }");
        }
    }

    Token peekAtCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }
}

