/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.spi.ContextAware;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class StringToObjectConverter {
    private static final Class<?>[] STRING_CLASS_PARAMETER = new Class[]{String.class};

    public static boolean canBeBuiltFromSimpleString(Class<?> parameterClass) {
        Package p = parameterClass.getPackage();
        if (parameterClass.isPrimitive()) {
            return true;
        }
        if (p != null && "java.lang".equals(p.getName())) {
            return true;
        }
        if (StringToObjectConverter.followsTheValueOfConvention(parameterClass)) {
            return true;
        }
        if (parameterClass.isEnum()) {
            return true;
        }
        return StringToObjectConverter.isOfTypeCharset(parameterClass);
    }

    public static Object convertArg(ContextAware ca, String val2, Class<?> type2) {
        if (val2 == null) {
            return null;
        }
        String v = val2.trim();
        if (String.class.isAssignableFrom(type2)) {
            return v;
        }
        if (Integer.TYPE.isAssignableFrom(type2)) {
            return Integer.valueOf(v);
        }
        if (Long.TYPE.isAssignableFrom(type2)) {
            return Long.valueOf(v);
        }
        if (Float.TYPE.isAssignableFrom(type2)) {
            return Float.valueOf(v);
        }
        if (Double.TYPE.isAssignableFrom(type2)) {
            return Double.valueOf(v);
        }
        if (Boolean.TYPE.isAssignableFrom(type2)) {
            if ("true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
        } else {
            if (type2.isEnum()) {
                return StringToObjectConverter.convertToEnum(ca, v, type2);
            }
            if (StringToObjectConverter.followsTheValueOfConvention(type2)) {
                return StringToObjectConverter.convertByValueOfMethod(ca, type2, v);
            }
            if (StringToObjectConverter.isOfTypeCharset(type2)) {
                return StringToObjectConverter.convertToCharset(ca, val2);
            }
        }
        return null;
    }

    private static boolean isOfTypeCharset(Class<?> type2) {
        return Charset.class.isAssignableFrom(type2);
    }

    private static Charset convertToCharset(ContextAware ca, String val2) {
        try {
            return Charset.forName(val2);
        }
        catch (UnsupportedCharsetException e2) {
            ca.addError("Failed to get charset [" + val2 + "]", e2);
            return null;
        }
    }

    public static Method getValueOfMethod(Class<?> type2) {
        try {
            return type2.getMethod("valueOf", STRING_CLASS_PARAMETER);
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
        catch (SecurityException e3) {
            return null;
        }
    }

    private static boolean followsTheValueOfConvention(Class<?> parameterClass) {
        Method valueOfMethod = StringToObjectConverter.getValueOfMethod(parameterClass);
        if (valueOfMethod == null) {
            return false;
        }
        int mod2 = valueOfMethod.getModifiers();
        return Modifier.isStatic(mod2);
    }

    private static Object convertByValueOfMethod(ContextAware ca, Class<?> type2, String val2) {
        try {
            Method valueOfMethod = type2.getMethod("valueOf", STRING_CLASS_PARAMETER);
            return valueOfMethod.invoke(null, val2);
        }
        catch (Exception e2) {
            ca.addError("Failed to invoke valueOf{} method in class [" + type2.getName() + "] with value [" + val2 + "]");
            return null;
        }
    }

    private static Object convertToEnum(ContextAware ca, String val2, Class<? extends Enum> enumType) {
        return Enum.valueOf(enumType, val2);
    }

    boolean isBuildableFromSimpleString() {
        return false;
    }
}

