/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.LinkedList;
import java.util.List;

public class ThrowableToStringArray {
    public static String[] convert(Throwable t3) {
        LinkedList<String> strList = new LinkedList<String>();
        ThrowableToStringArray.extract(strList, t3, null);
        return strList.toArray(new String[0]);
    }

    private static void extract(List<String> strList, Throwable t3, StackTraceElement[] parentSTE) {
        Throwable cause;
        StackTraceElement[] ste = t3.getStackTrace();
        int numberOfcommonFrames = ThrowableToStringArray.findNumberOfCommonFrames(ste, parentSTE);
        strList.add(ThrowableToStringArray.formatFirstLine(t3, parentSTE));
        for (int i = 0; i < ste.length - numberOfcommonFrames; ++i) {
            strList.add("\tat " + ste[i].toString());
        }
        if (numberOfcommonFrames != 0) {
            strList.add("\t... " + numberOfcommonFrames + " common frames omitted");
        }
        if ((cause = t3.getCause()) != null) {
            ThrowableToStringArray.extract(strList, cause, ste);
        }
    }

    private static String formatFirstLine(Throwable t3, StackTraceElement[] parentSTE) {
        String prefix = "";
        if (parentSTE != null) {
            prefix = "Caused by: ";
        }
        String result2 = prefix + t3.getClass().getName();
        if (t3.getMessage() != null) {
            result2 = result2 + ": " + t3.getMessage();
        }
        return result2;
    }

    private static int findNumberOfCommonFrames(StackTraceElement[] ste, StackTraceElement[] parentSTE) {
        if (parentSTE == null) {
            return 0;
        }
        int steIndex = ste.length - 1;
        int count2 = 0;
        for (int parentIndex = parentSTE.length - 1; steIndex >= 0 && parentIndex >= 0 && ste[steIndex].equals(parentSTE[parentIndex]); --steIndex, --parentIndex) {
            ++count2;
        }
        return count2;
    }
}

