/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security.auth;

import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.security.auth.RetrofitGithubClient;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/tock/shared/security/auth/RetrofitGithubClient;", "", "()V", "api", "Lai/tock/shared/security/auth/RetrofitGithubClient$GithubApi;", "logger", "Lmu/KLogger;", "login", "", "token", "GithubApi", "GithubUser", "tock-shared"})
@SourceDebugExtension(value={"SMAP\nRetrofitGithubClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrofitGithubClient.kt\nai/tock/shared/security/auth/RetrofitGithubClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,60:1\n71#2:61\n*S KotlinDebug\n*F\n+ 1 RetrofitGithubClient.kt\nai/tock/shared/security/auth/RetrofitGithubClient\n*L\n53#1:61\n*E\n"})
public final class RetrofitGithubClient {
    @NotNull
    public static final RetrofitGithubClient INSTANCE = new RetrofitGithubClient();
    @NotNull
    private static final GithubApi api;
    @NotNull
    private static final KLogger logger;

    private RetrofitGithubClient() {
    }

    @NotNull
    public final String login(@NotNull String token2) {
        Intrinsics.checkNotNullParameter(token2, "token");
        Object object = (GithubUser)api.user("token " + token2).execute().body();
        if (object == null || (object = ((GithubUser)object).getLogin()) == null) {
            throw new IllegalStateException(("no login found for " + token2).toString());
        }
        return object;
    }

    static {
        logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default(PropertiesKt.longProperty("tock_github_api_request_timeout_ms", 5000L), logger, null, null, false, false, null, 124, null).baseUrl("https://api.github.com");
        Intrinsics.checkNotNullExpressionValue(builder, "retrofitBuilderWithTimeo\u2026\"https://api.github.com\")");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default(builder, null, 1, null).build();
        Intrinsics.checkNotNullExpressionValue(retrofit, "retrofitBuilderWithTimeo\u2026er()\n            .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(GithubApi.class);
        Intrinsics.checkNotNullExpressionValue(object, "create(T::class.java)");
        api = (GithubApi)object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u0007"}, d2={"Lai/tock/shared/security/auth/RetrofitGithubClient$GithubApi;", "", "user", "Lretrofit2/Call;", "Lai/tock/shared/security/auth/RetrofitGithubClient$GithubUser;", "authorization", "", "tock-shared"})
    private static interface GithubApi {
        @GET(value="/user")
        @NotNull
        public Call<GithubUser> user(@Header(value="Authorization") @NotNull String var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lai/tock/shared/security/auth/RetrofitGithubClient$GithubUser;", "", "login", "", "(Ljava/lang/String;)V", "getLogin", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-shared"})
    public static final class GithubUser {
        @NotNull
        private final String login;

        public GithubUser(@NotNull String login) {
            Intrinsics.checkNotNullParameter(login, "login");
            this.login = login;
        }

        @NotNull
        public final String getLogin() {
            return this.login;
        }

        @NotNull
        public final String component1() {
            return this.login;
        }

        @NotNull
        public final GithubUser copy(@NotNull String login) {
            Intrinsics.checkNotNullParameter(login, "login");
            return new GithubUser(login);
        }

        public static /* synthetic */ GithubUser copy$default(GithubUser githubUser, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = githubUser.login;
            }
            return githubUser.copy(string2);
        }

        @NotNull
        public String toString() {
            return "GithubUser(login=" + this.login + ")";
        }

        public int hashCode() {
            return this.login.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GithubUser)) {
                return false;
            }
            GithubUser githubUser = (GithubUser)other;
            return Intrinsics.areEqual(this.login, githubUser.login);
        }
    }
}

