/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.cache;

import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.cache.CachesKt;
import ai.tock.shared.cache.TockCache;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a&\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\f\u0012\u0004\u0012\u00020\u00010\u000b\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a-\u0010\u0010\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012\u001a=\u0010\u0013\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0015\u00a2\u0006\u0002\u0010\u0016\u001a(\u0010\u0017\u001a\u00020\u0001\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a3\u0010\u0018\u001a\u00020\u0019\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u001b\u001a&\u0010\u001c\u001a\u00020\u0019\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001b\u0010\u001d\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r*\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"NOT_PRESENT", "", "cache", "Lai/tock/shared/cache/TockCache;", "getCache", "()Lai/tock/shared/cache/TockCache;", "inMemoryCache", "Lcom/google/common/cache/Cache;", "logger", "Lmu/KLogger;", "getCachedValuesForType", "", "Lorg/litote/kmongo/Id;", "T", "type", "", "getFromCache", "id", "(Lorg/litote/kmongo/Id;Ljava/lang/String;)Ljava/lang/Object;", "getOrCache", "valueProvider", "Lkotlin/Function0;", "(Lorg/litote/kmongo/Id;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "inMemoryKey", "putInCache", "", "value", "(Lorg/litote/kmongo/Id;Ljava/lang/String;Ljava/lang/Object;)V", "removeFromCache", "replaceNotPresent", "(Ljava/lang/Object;)Ljava/lang/Object;", "tock-shared"})
@SourceDebugExtension(value={"SMAP\nCaches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Caches.kt\nai/tock/shared/cache/CachesKt\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,117:1\n53#2,2:118\n51#3:120\n277#4:121\n*S KotlinDebug\n*F\n+ 1 Caches.kt\nai/tock/shared/cache/CachesKt\n*L\n43#1:118,2\n43#1:120\n43#1:121\n*E\n"})
public final class CachesKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private static final Cache<Object, Object> inMemoryCache;
    @NotNull
    private static final Object NOT_PRESENT;

    private static final TockCache getCache() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = $this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (TockCache)kodeinInjector.Provider((TypeToken)new TypeReference<TockCache>(){}, tag$iv).getValue().invoke();
    }

    private static final <T> T replaceNotPresent(Object $this$replaceNotPresent) {
        return (T)(Intrinsics.areEqual($this$replaceNotPresent, NOT_PRESENT) ? null : $this$replaceNotPresent);
    }

    private static final <T> Object inMemoryKey(Id<T> id, String type2) {
        return TuplesKt.to(id, type2);
    }

    @Nullable
    public static final <T> T getOrCache(@NotNull Id<T> id, @NotNull String type2, @NotNull Function0<? extends T> valueProvider) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(valueProvider, "valueProvider");
        return CachesKt.replaceNotPresent(inMemoryCache.get(CachesKt.inMemoryKey(id, type2), () -> CachesKt.getOrCache$lambda$1(id, type2, valueProvider)));
    }

    @Nullable
    public static final <T> T getFromCache(@NotNull Id<T> id, @NotNull String type2) {
        T t3;
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(type2, "type");
        try {
            t3 = CachesKt.replaceNotPresent(inMemoryCache.get(CachesKt.inMemoryKey(id, type2), () -> CachesKt.getFromCache$lambda$2(id, type2)));
        }
        catch (Exception e2) {
            LoggersKt.error(logger, e2);
            t3 = null;
        }
        return t3;
    }

    public static final <T> void putInCache(@NotNull Id<T> id, @NotNull String type2, @NotNull T value) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(value, "value");
        try {
            if (!(value instanceof byte[])) {
                inMemoryCache.put(CachesKt.inMemoryKey(id, type2), value);
            }
            CachesKt.getCache().put(id, type2, value);
        }
        catch (Exception e2) {
            LoggersKt.error(logger, e2);
        }
    }

    public static final <T> void removeFromCache(@NotNull Id<T> id, @NotNull String type2) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(type2, "type");
        inMemoryCache.invalidate(CachesKt.inMemoryKey(id, type2));
        CachesKt.getCache().remove(id, type2);
    }

    @NotNull
    public static final <T> Map<Id<T>, Object> getCachedValuesForType(@NotNull String type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return CachesKt.getCache().getAll(type2);
    }

    private static final Object getOrCache$lambda$1(Id $id, String $type, Function0 $valueProvider) {
        Intrinsics.checkNotNullParameter($id, "$id");
        Intrinsics.checkNotNullParameter($type, "$type");
        Intrinsics.checkNotNullParameter($valueProvider, "$valueProvider");
        Object object = CachesKt.getCache().get($id, $type);
        if (object == null) {
            Object var3_7;
            try {
                Object v2;
                Object r = $valueProvider.invoke();
                if (r != null) {
                    Object r2;
                    Object $this$getOrCache_u24lambda_u241_u24lambda_u240 = r2 = r;
                    boolean bl = false;
                    CachesKt.putInCache($id, $type, $this$getOrCache_u24lambda_u241_u24lambda_u240);
                    v2 = r2;
                } else {
                    v2 = null;
                }
                var3_7 = v2;
            }
            catch (Exception e2) {
                LoggersKt.error(logger, e2);
                var3_7 = null;
            }
            if ((object = var3_7) == null) {
                object = NOT_PRESENT;
            }
        }
        return object;
    }

    private static final Object getFromCache$lambda$2(Id $id, String $type) {
        Intrinsics.checkNotNullParameter($id, "$id");
        Intrinsics.checkNotNullParameter($type, "$type");
        Object object = CachesKt.getCache().get($id, $type);
        if (object == null) {
            object = NOT_PRESENT;
        }
        return object;
    }

    static {
        Cache cache2 = CacheBuilder.newBuilder().maximumSize(PropertiesKt.longProperty("tock_cache_in_memory_maximum_size", 10000L)).expireAfterAccess(PropertiesKt.longProperty("tock_cache_in_memory_expiration_in_ms", 3600000L), TimeUnit.MILLISECONDS).build();
        Intrinsics.checkNotNullExpressionValue(cache2, "newBuilder()\n        .ma\u2026       )\n        .build()");
        inMemoryCache = cache2;
        NOT_PRESENT = new Object();
    }
}

