/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared;

import ai.tock.shared.Loader;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"resource", "Ljava/net/URL;", "path", "", "resourceAsStream", "Ljava/io/InputStream;", "resourceAsString", "tock-shared"})
public final class IOsKt {
    @NotNull
    public static final URL resource(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        URL uRL = Loader.class.getResource(path2);
        if (uRL == null) {
            throw new IllegalStateException(("resource " + path2 + " not found").toString());
        }
        return uRL;
    }

    @NotNull
    public static final InputStream resourceAsStream(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        InputStream inputStream = Loader.class.getResourceAsStream(path2);
        if (inputStream == null) {
            throw new IllegalStateException(("path not found: " + path2).toString());
        }
        return inputStream;
    }

    @NotNull
    public static final String resourceAsString(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        String string2 = Resources.toString(IOsKt.resource(path2), StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(string2, "toString(resource(path), StandardCharsets.UTF_8)");
        return string2;
    }
}

