/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NullnessUtil {
    private NullnessUtil() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref2) {
        assert (ref2 != null) : "Misuse of castNonNull: called with a null argument";
        return ref2;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref2, String message) {
        assert (ref2 != null) : "Misuse of castNonNull: called with a null argument: " + message;
        return ref2;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] arr) {
        return NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] arr, String message) {
        return NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] arr) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] arr, String message) {
        return (Object[][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] arr, String message) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr, String message) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr, message);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, null);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr, String message) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr, message);
    }

    private static <T> @NonNull T @NonNull [] castNonNullArray(T @Nullable [] arr, @Nullable String message) {
        assert (arr != null) : "Misuse of castNonNullArray: called with a null array argument" + (message == null ? "" : ": " + message);
        for (int i = 0; i < arr.length; ++i) {
            assert (arr[i] != null) : "Misuse of castNonNull: called with a null array element" + (message == null ? "" : ": " + message);
            NullnessUtil.checkIfArray(arr[i], message);
        }
        return arr;
    }

    private static void checkIfArray(@NonNull Object ref2, @Nullable String message) {
        assert (ref2 != null) : "Misuse of checkIfArray: called with a null argument" + (message == null ? "" : ": " + message);
        Class<?> comp2 = ref2.getClass().getComponentType();
        if (comp2 != null && !comp2.isPrimitive()) {
            NullnessUtil.castNonNullArray((Object[])ref2, message);
        }
    }
}

