/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.SinceKotlin;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnitKt;
import kotlin.time.ExperimentalTime;
import kotlin.time.FormatToDecimalsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b4\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0087@\u0018\u0000 \u00a5\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u00a5\u0001B\u0014\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u0003H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bN\u0010OJ\u001b\u0010P\u001a\u00020\t2\u0006\u0010Q\u001a\u00020\u0000H\u0096\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bR\u0010SJ\u001e\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u000fH\u0086\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bV\u0010WJ\u001e\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\tH\u0086\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bV\u0010XJ\u001b\u0010T\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bY\u0010ZJ\u001a\u0010[\u001a\u00020\\2\b\u0010Q\u001a\u0004\u0018\u00010]H\u00d6\u0003\u00a2\u0006\u0004\b^\u0010_J\u0010\u0010`\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\ba\u0010\rJ\r\u0010b\u001a\u00020\\\u00a2\u0006\u0004\bc\u0010dJ\u000f\u0010e\u001a\u00020\\H\u0002\u00a2\u0006\u0004\bf\u0010dJ\u000f\u0010g\u001a\u00020\\H\u0002\u00a2\u0006\u0004\bh\u0010dJ\r\u0010i\u001a\u00020\\\u00a2\u0006\u0004\bj\u0010dJ\r\u0010k\u001a\u00020\\\u00a2\u0006\u0004\bl\u0010dJ\r\u0010m\u001a\u00020\\\u00a2\u0006\u0004\bn\u0010dJ\u001b\u0010o\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bp\u0010qJ\u001b\u0010r\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bs\u0010qJ\u0017\u0010t\u001a\u00020\t2\u0006\u0010I\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\bu\u0010vJ\u001e\u0010w\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u000fH\u0086\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bx\u0010WJ\u001e\u0010w\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\tH\u0086\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bx\u0010XJ\u00a3\u0001\u0010y\u001a\u0002Hz\"\u0004\b\u0000\u0010z2y\u0010{\u001au\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b}\u0012\b\b~\u0012\u0004\b\b(\u007f\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0080\u0001\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0081\u0001\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0082\u0001\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0083\u0001\u0012\u0004\u0012\u0002Hz0|H\u0086\b\u00f8\u0001\u0002\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0006\b\u0084\u0001\u0010\u0085\u0001J\u008f\u0001\u0010y\u001a\u0002Hz\"\u0004\b\u0000\u0010z2e\u0010{\u001aa\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0080\u0001\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0081\u0001\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0082\u0001\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0083\u0001\u0012\u0004\u0012\u0002Hz0\u0086\u0001H\u0086\b\u00f8\u0001\u0002\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0006\b\u0084\u0001\u0010\u0087\u0001Jy\u0010y\u001a\u0002Hz\"\u0004\b\u0000\u0010z2O\u0010{\u001aK\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0081\u0001\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0082\u0001\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0083\u0001\u0012\u0004\u0012\u0002Hz0\u0088\u0001H\u0086\b\u00f8\u0001\u0002\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0006\b\u0084\u0001\u0010\u0089\u0001Jc\u0010y\u001a\u0002Hz\"\u0004\b\u0000\u0010z29\u0010{\u001a5\u0012\u0014\u0012\u00120\u0003\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0082\u0001\u0012\u0014\u0012\u00120\t\u00a2\u0006\r\b}\u0012\t\b~\u0012\u0005\b\b(\u0083\u0001\u0012\u0004\u0012\u0002Hz0\u008a\u0001H\u0086\b\u00f8\u0001\u0002\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0006\b\u0084\u0001\u0010\u008b\u0001J\u001e\u0010\u008c\u0001\u001a\u00020\u000f2\f\u0010\u008d\u0001\u001a\u00070Dj\u0003`\u008e\u0001\u00a2\u0006\u0006\b\u008f\u0001\u0010\u0090\u0001J\u001e\u0010\u0091\u0001\u001a\u00020\t2\f\u0010\u008d\u0001\u001a\u00070Dj\u0003`\u008e\u0001\u00a2\u0006\u0006\b\u0092\u0001\u0010\u0093\u0001J\u0011\u0010\u0094\u0001\u001a\u00030\u0095\u0001\u00a2\u0006\u0006\b\u0096\u0001\u0010\u0097\u0001J\u001e\u0010\u0098\u0001\u001a\u00020\u00032\f\u0010\u008d\u0001\u001a\u00070Dj\u0003`\u008e\u0001\u00a2\u0006\u0006\b\u0099\u0001\u0010\u009a\u0001J\u0011\u0010\u009b\u0001\u001a\u00020\u0003H\u0007\u00a2\u0006\u0005\b\u009c\u0001\u0010\u0005J\u0011\u0010\u009d\u0001\u001a\u00020\u0003H\u0007\u00a2\u0006\u0005\b\u009e\u0001\u0010\u0005J\u0013\u0010\u009f\u0001\u001a\u00030\u0095\u0001H\u0016\u00a2\u0006\u0006\b\u00a0\u0001\u0010\u0097\u0001J*\u0010\u009f\u0001\u001a\u00030\u0095\u00012\f\u0010\u008d\u0001\u001a\u00070Dj\u0003`\u008e\u00012\t\b\u0002\u0010\u00a1\u0001\u001a\u00020\t\u00a2\u0006\u0006\b\u00a0\u0001\u0010\u00a2\u0001J\u0018\u0010\u00a3\u0001\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0005\b\u00a4\u0001\u0010\u0005R\u0017\u0010\u0006\u001a\u00020\u00008F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u001a\u0010\b\u001a\u00020\t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u000b\u001a\u0004\b\u0018\u0010\u0012R\u001a\u0010\u0019\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u000b\u001a\u0004\b\u001b\u0010\u0012R\u001a\u0010\u001c\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u000b\u001a\u0004\b\u001e\u0010\u0012R\u001a\u0010\u001f\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b \u0010\u000b\u001a\u0004\b!\u0010\u0012R\u001a\u0010\"\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010\u000b\u001a\u0004\b$\u0010\u0012R\u001a\u0010%\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b&\u0010\u000b\u001a\u0004\b'\u0010\u0005R\u001a\u0010(\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b)\u0010\u000b\u001a\u0004\b*\u0010\u0005R\u001a\u0010+\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b,\u0010\u000b\u001a\u0004\b-\u0010\u0005R\u001a\u0010.\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b/\u0010\u000b\u001a\u0004\b0\u0010\u0005R\u001a\u00101\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b2\u0010\u000b\u001a\u0004\b3\u0010\u0005R\u001a\u00104\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b5\u0010\u000b\u001a\u0004\b6\u0010\u0005R\u001a\u00107\u001a\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b8\u0010\u000b\u001a\u0004\b9\u0010\u0005R\u001a\u0010:\u001a\u00020\t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b;\u0010\u000b\u001a\u0004\b<\u0010\rR\u001a\u0010=\u001a\u00020\t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b>\u0010\u000b\u001a\u0004\b?\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u00020\t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bA\u0010\u000b\u001a\u0004\bB\u0010\rR\u0014\u0010C\u001a\u00020D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0015\u0010G\u001a\u00020\t8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\rR\u0014\u0010I\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u0005\u0088\u0001\u0002\u0092\u0001\u00020\u0003\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u009920\u0001\u00a8\u0006\u00a6\u0001"}, d2={"Lkotlin/time/Duration;", "", "rawValue", "", "constructor-impl", "(J)J", "absoluteValue", "getAbsoluteValue-UwyO8pc", "hoursComponent", "", "getHoursComponent$annotations", "()V", "getHoursComponent-impl", "(J)I", "inDays", "", "getInDays$annotations", "getInDays-impl", "(J)D", "inHours", "getInHours$annotations", "getInHours-impl", "inMicroseconds", "getInMicroseconds$annotations", "getInMicroseconds-impl", "inMilliseconds", "getInMilliseconds$annotations", "getInMilliseconds-impl", "inMinutes", "getInMinutes$annotations", "getInMinutes-impl", "inNanoseconds", "getInNanoseconds$annotations", "getInNanoseconds-impl", "inSeconds", "getInSeconds$annotations", "getInSeconds-impl", "inWholeDays", "getInWholeDays$annotations", "getInWholeDays-impl", "inWholeHours", "getInWholeHours$annotations", "getInWholeHours-impl", "inWholeMicroseconds", "getInWholeMicroseconds$annotations", "getInWholeMicroseconds-impl", "inWholeMilliseconds", "getInWholeMilliseconds$annotations", "getInWholeMilliseconds-impl", "inWholeMinutes", "getInWholeMinutes$annotations", "getInWholeMinutes-impl", "inWholeNanoseconds", "getInWholeNanoseconds$annotations", "getInWholeNanoseconds-impl", "inWholeSeconds", "getInWholeSeconds$annotations", "getInWholeSeconds-impl", "minutesComponent", "getMinutesComponent$annotations", "getMinutesComponent-impl", "nanosecondsComponent", "getNanosecondsComponent$annotations", "getNanosecondsComponent-impl", "secondsComponent", "getSecondsComponent$annotations", "getSecondsComponent-impl", "storageUnit", "Ljava/util/concurrent/TimeUnit;", "getStorageUnit-impl", "(J)Ljava/util/concurrent/TimeUnit;", "unitDiscriminator", "getUnitDiscriminator-impl", "value", "getValue-impl", "addValuesMixedRanges", "thisMillis", "otherNanos", "addValuesMixedRanges-UwyO8pc", "(JJJ)J", "compareTo", "other", "compareTo-LRDsOJo", "(JJ)I", "div", "scale", "div-UwyO8pc", "(JD)J", "(JI)J", "div-LRDsOJo", "(JJ)D", "equals", "", "", "equals-impl", "(JLjava/lang/Object;)Z", "hashCode", "hashCode-impl", "isFinite", "isFinite-impl", "(J)Z", "isInMillis", "isInMillis-impl", "isInNanos", "isInNanos-impl", "isInfinite", "isInfinite-impl", "isNegative", "isNegative-impl", "isPositive", "isPositive-impl", "minus", "minus-LRDsOJo", "(JJ)J", "plus", "plus-LRDsOJo", "precision", "precision-impl", "(JD)I", "times", "times-UwyO8pc", "toComponents", "T", "action", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "days", "hours", "minutes", "seconds", "nanoseconds", "toComponents-impl", "(JLkotlin/jvm/functions/Function5;)Ljava/lang/Object;", "Lkotlin/Function4;", "(JLkotlin/jvm/functions/Function4;)Ljava/lang/Object;", "Lkotlin/Function3;", "(JLkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "Lkotlin/Function2;", "(JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "toDouble", "unit", "Lkotlin/time/DurationUnit;", "toDouble-impl", "(JLjava/util/concurrent/TimeUnit;)D", "toInt", "toInt-impl", "(JLjava/util/concurrent/TimeUnit;)I", "toIsoString", "", "toIsoString-impl", "(J)Ljava/lang/String;", "toLong", "toLong-impl", "(JLjava/util/concurrent/TimeUnit;)J", "toLongMilliseconds", "toLongMilliseconds-impl", "toLongNanoseconds", "toLongNanoseconds-impl", "toString", "toString-impl", "decimals", "(JLjava/util/concurrent/TimeUnit;I)Ljava/lang/String;", "unaryMinus", "unaryMinus-UwyO8pc", "Companion", "kotlin-stdlib"})
@SinceKotlin(version="1.3")
@ExperimentalTime
public final class Duration
implements Comparable<Duration> {
    private final long rawValue;
    private static final long ZERO;
    private static final long INFINITE;
    private static final long NEG_INFINITE;
    @NotNull
    public static final Companion Companion;

    public int compareTo-LRDsOJo(long l) {
        return Duration.compareTo-LRDsOJo(this.rawValue, l);
    }

    @PublishedApi
    public static /* synthetic */ void getHoursComponent$annotations() {
    }

    @PublishedApi
    public static /* synthetic */ void getMinutesComponent$annotations() {
    }

    @PublishedApi
    public static /* synthetic */ void getSecondsComponent$annotations() {
    }

    @PublishedApi
    public static /* synthetic */ void getNanosecondsComponent$annotations() {
    }

    @Deprecated(message="Use inWholeDays property instead or convert toDouble(DAYS) if a double value is required.", replaceWith=@ReplaceWith(imports={}, expression="toDouble(DurationUnit.DAYS)"))
    public static /* synthetic */ void getInDays$annotations() {
    }

    @Deprecated(message="Use inWholeHours property instead or convert toDouble(HOURS) if a double value is required.", replaceWith=@ReplaceWith(imports={}, expression="toDouble(DurationUnit.HOURS)"))
    public static /* synthetic */ void getInHours$annotations() {
    }

    @Deprecated(message="Use inWholeMinutes property instead or convert toDouble(MINUTES) if a double value is required.", replaceWith=@ReplaceWith(imports={}, expression="toDouble(DurationUnit.MINUTES)"))
    public static /* synthetic */ void getInMinutes$annotations() {
    }

    @Deprecated(message="Use inWholeSeconds property instead or convert toDouble(SECONDS) if a double value is required.", replaceWith=@ReplaceWith(imports={}, expression="toDouble(DurationUnit.SECONDS)"))
    public static /* synthetic */ void getInSeconds$annotations() {
    }

    @Deprecated(message="Use inWholeMilliseconds property instead or convert toDouble(MILLISECONDS) if a double value is required.", replaceWith=@ReplaceWith(imports={}, expression="toDouble(DurationUnit.MILLISECONDS)"))
    public static /* synthetic */ void getInMilliseconds$annotations() {
    }

    @Deprecated(message="Use inWholeMicroseconds property instead or convert toDouble(MICROSECONDS) if a double value is required.", replaceWith=@ReplaceWith(imports={}, expression="toDouble(DurationUnit.MICROSECONDS)"))
    public static /* synthetic */ void getInMicroseconds$annotations() {
    }

    @Deprecated(message="Use inWholeNanoseconds property instead or convert toDouble(NANOSECONDS) if a double value is required.", replaceWith=@ReplaceWith(imports={}, expression="toDouble(DurationUnit.NANOSECONDS)"))
    public static /* synthetic */ void getInNanoseconds$annotations() {
    }

    @SinceKotlin(version="1.5")
    public static /* synthetic */ void getInWholeDays$annotations() {
    }

    @SinceKotlin(version="1.5")
    public static /* synthetic */ void getInWholeHours$annotations() {
    }

    @SinceKotlin(version="1.5")
    public static /* synthetic */ void getInWholeMinutes$annotations() {
    }

    @SinceKotlin(version="1.5")
    public static /* synthetic */ void getInWholeSeconds$annotations() {
    }

    @SinceKotlin(version="1.5")
    public static /* synthetic */ void getInWholeMilliseconds$annotations() {
    }

    @SinceKotlin(version="1.5")
    public static /* synthetic */ void getInWholeMicroseconds$annotations() {
    }

    @SinceKotlin(version="1.5")
    public static /* synthetic */ void getInWholeNanoseconds$annotations() {
    }

    @NotNull
    public String toString() {
        return Duration.toString-impl(this.rawValue);
    }

    private /* synthetic */ Duration(long rawValue) {
        this.rawValue = rawValue;
    }

    private static final long getValue-impl(long $this) {
        return $this >> 1;
    }

    private static final int getUnitDiscriminator-impl(long $this) {
        int $i$f$getUnitDiscriminator = 0;
        return (int)$this & 1;
    }

    private static final boolean isInNanos-impl(long $this) {
        long $this$iv = $this;
        boolean $i$f$getUnitDiscriminator = false;
        return ((int)$this$iv & 1) == 0;
    }

    private static final boolean isInMillis-impl(long $this) {
        long $this$iv = $this;
        boolean $i$f$getUnitDiscriminator = false;
        return ((int)$this$iv & 1) == 1;
    }

    private static final TimeUnit getStorageUnit-impl(long $this) {
        return Duration.isInNanos-impl($this) ? TimeUnit.NANOSECONDS : TimeUnit.MILLISECONDS;
    }

    public static final long unaryMinus-UwyO8pc(long $this) {
        long $this$iv = $this;
        boolean $i$f$getUnitDiscriminator = false;
        return DurationKt.access$durationOf(-Duration.getValue-impl($this), (int)$this$iv & 1);
    }

    public static final long plus-LRDsOJo(long $this, long other) {
        long l;
        if (Duration.isInfinite-impl($this)) {
            if (Duration.isFinite-impl(other) || ($this ^ other) >= 0L) {
                return $this;
            }
            throw (Throwable)new IllegalArgumentException("Summing infinite durations of different signs yields an undefined result.");
        }
        if (Duration.isInfinite-impl(other)) {
            return other;
        }
        long $this$iv = $this;
        boolean $i$f$getUnitDiscriminator = false;
        int n = (int)$this$iv & 1;
        $this$iv = other;
        $i$f$getUnitDiscriminator = false;
        if (n == ((int)$this$iv & 1)) {
            long result2 = Duration.getValue-impl($this) + Duration.getValue-impl(other);
            l = Duration.isInNanos-impl($this) ? DurationKt.access$durationOfNanosNormalized(result2) : DurationKt.access$durationOfMillisNormalized(result2);
        } else {
            l = Duration.isInMillis-impl($this) ? Duration.addValuesMixedRanges-UwyO8pc($this, Duration.getValue-impl($this), Duration.getValue-impl(other)) : Duration.addValuesMixedRanges-UwyO8pc($this, Duration.getValue-impl(other), Duration.getValue-impl($this));
        }
        return l;
    }

    private static final long addValuesMixedRanges-UwyO8pc(long $this, long thisMillis, long otherNanos) {
        long l;
        long otherMillis = DurationKt.access$nanosToMillis(otherNanos);
        long resultMillis = thisMillis + otherMillis;
        long l2 = resultMillis;
        if (-4611686018426L <= l2 && 4611686018426L >= l2) {
            long otherNanoRemainder = otherNanos - DurationKt.access$millisToNanos(otherMillis);
            l = DurationKt.access$durationOfNanos(DurationKt.access$millisToNanos(resultMillis) + otherNanoRemainder);
        } else {
            l = DurationKt.access$durationOfMillis(RangesKt.coerceIn(resultMillis, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
        }
        return l;
    }

    public static final long minus-LRDsOJo(long $this, long other) {
        return Duration.plus-LRDsOJo($this, Duration.unaryMinus-UwyO8pc(other));
    }

    public static final long times-UwyO8pc(long $this, int scale) {
        long l;
        if (Duration.isInfinite-impl($this)) {
            if (scale == 0) {
                throw (Throwable)new IllegalArgumentException("Multiplying infinite duration by zero yields an undefined result.");
            }
            return scale > 0 ? $this : Duration.unaryMinus-UwyO8pc($this);
        }
        if (scale == 0) {
            return ZERO;
        }
        long value = Duration.getValue-impl($this);
        long result2 = value * (long)scale;
        if (Duration.isInNanos-impl($this)) {
            long l2 = value;
            if (-2147483647L <= l2 && Integer.MAX_VALUE >= l2) {
                l = DurationKt.access$durationOfNanos(result2);
            } else if (result2 / (long)scale == value) {
                l = DurationKt.access$durationOfNanosNormalized(result2);
            } else {
                long millis2 = DurationKt.access$nanosToMillis(value);
                long remNanos = value - DurationKt.access$millisToNanos(millis2);
                long resultMillis = millis2 * (long)scale;
                long totalMillis = resultMillis + DurationKt.access$nanosToMillis(remNanos * (long)scale);
                if (resultMillis / (long)scale == millis2 && (totalMillis ^ resultMillis) >= 0L) {
                    long l3 = -4611686018427387903L;
                    l = DurationKt.access$durationOfMillis(RangesKt.coerceIn(totalMillis, new LongRange(l3, 0x3FFFFFFFFFFFFFFFL)));
                } else {
                    l = MathKt.getSign(value) * MathKt.getSign(scale) > 0 ? INFINITE : NEG_INFINITE;
                }
            }
        } else if (result2 / (long)scale == value) {
            long l4 = -4611686018427387903L;
            l = DurationKt.access$durationOfMillis(RangesKt.coerceIn(result2, new LongRange(l4, 0x3FFFFFFFFFFFFFFFL)));
        } else {
            l = MathKt.getSign(value) * MathKt.getSign(scale) > 0 ? INFINITE : NEG_INFINITE;
        }
        return l;
    }

    public static final long times-UwyO8pc(long $this, double scale) {
        int intScale = MathKt.roundToInt(scale);
        if ((double)intScale == scale) {
            return Duration.times-UwyO8pc($this, intScale);
        }
        TimeUnit unit = Duration.getStorageUnit-impl($this);
        double result2 = Duration.toDouble-impl($this, unit) * scale;
        return DurationKt.toDuration(result2, unit);
    }

    public static final long div-UwyO8pc(long $this, int scale) {
        if (scale == 0) {
            long l;
            if (Duration.isPositive-impl($this)) {
                l = INFINITE;
            } else if (Duration.isNegative-impl($this)) {
                l = NEG_INFINITE;
            } else {
                throw (Throwable)new IllegalArgumentException("Dividing zero duration by zero yields an undefined result.");
            }
            return l;
        }
        if (Duration.isInNanos-impl($this)) {
            return DurationKt.access$durationOfNanos(Duration.getValue-impl($this) / (long)scale);
        }
        if (Duration.isInfinite-impl($this)) {
            return Duration.times-UwyO8pc($this, MathKt.getSign(scale));
        }
        long result2 = Duration.getValue-impl($this) / (long)scale;
        long l = result2;
        if (-4611686018426L <= l && 4611686018426L >= l) {
            long rem2 = DurationKt.access$millisToNanos(Duration.getValue-impl($this) - result2 * (long)scale) / (long)scale;
            return DurationKt.access$durationOfNanos(DurationKt.access$millisToNanos(result2) + rem2);
        }
        return DurationKt.access$durationOfMillis(result2);
    }

    public static final long div-UwyO8pc(long $this, double scale) {
        int intScale = MathKt.roundToInt(scale);
        if ((double)intScale == scale && intScale != 0) {
            return Duration.div-UwyO8pc($this, intScale);
        }
        TimeUnit unit = Duration.getStorageUnit-impl($this);
        double result2 = Duration.toDouble-impl($this, unit) / scale;
        return DurationKt.toDuration(result2, unit);
    }

    public static final double div-LRDsOJo(long $this, long other) {
        TimeUnit coarserUnit = (TimeUnit)((Object)ComparisonsKt.maxOf((Comparable)((Object)Duration.getStorageUnit-impl($this)), (Comparable)((Object)Duration.getStorageUnit-impl(other))));
        return Duration.toDouble-impl($this, coarserUnit) / Duration.toDouble-impl(other, coarserUnit);
    }

    public static final boolean isNegative-impl(long $this) {
        return $this < 0L;
    }

    public static final boolean isPositive-impl(long $this) {
        return $this > 0L;
    }

    public static final boolean isInfinite-impl(long $this) {
        return $this == INFINITE || $this == NEG_INFINITE;
    }

    public static final boolean isFinite-impl(long $this) {
        return !Duration.isInfinite-impl($this);
    }

    public static final long getAbsoluteValue-UwyO8pc(long $this) {
        return Duration.isNegative-impl($this) ? Duration.unaryMinus-UwyO8pc($this) : $this;
    }

    public static int compareTo-LRDsOJo(long $this, long other) {
        long compareBits = $this ^ other;
        if (compareBits < 0L || ((int)compareBits & 1) == 0) {
            return $this == other ? 0 : ($this < other ? -1 : 1);
        }
        long $this$iv = $this;
        boolean $i$f$getUnitDiscriminator = false;
        int n = (int)$this$iv & 1;
        $this$iv = other;
        $i$f$getUnitDiscriminator = false;
        int r = n - ((int)$this$iv & 1);
        return Duration.isNegative-impl($this) ? -r : r;
    }

    public static final <T> T toComponents-impl(long $this, @NotNull Function5<? super Integer, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? extends T> action) {
        int $i$f$toComponents = 0;
        Intrinsics.checkNotNullParameter(action, "action");
        boolean bl = false;
        return action.invoke(Duration.toInt-impl($this, TimeUnit.DAYS), Duration.getHoursComponent-impl($this), Duration.getMinutesComponent-impl($this), Duration.getSecondsComponent-impl($this), Duration.getNanosecondsComponent-impl($this));
    }

    public static final <T> T toComponents-impl(long $this, @NotNull Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, ? extends T> action) {
        int $i$f$toComponents = 0;
        Intrinsics.checkNotNullParameter(action, "action");
        boolean bl = false;
        return action.invoke(Duration.toInt-impl($this, TimeUnit.HOURS), Duration.getMinutesComponent-impl($this), Duration.getSecondsComponent-impl($this), Duration.getNanosecondsComponent-impl($this));
    }

    public static final <T> T toComponents-impl(long $this, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, ? extends T> action) {
        int $i$f$toComponents = 0;
        Intrinsics.checkNotNullParameter(action, "action");
        boolean bl = false;
        return action.invoke(Duration.toInt-impl($this, TimeUnit.MINUTES), Duration.getSecondsComponent-impl($this), Duration.getNanosecondsComponent-impl($this));
    }

    public static final <T> T toComponents-impl(long $this, @NotNull Function2<? super Long, ? super Integer, ? extends T> action) {
        int $i$f$toComponents = 0;
        Intrinsics.checkNotNullParameter(action, "action");
        boolean bl = false;
        return action.invoke(Duration.getInWholeSeconds-impl($this), Duration.getNanosecondsComponent-impl($this));
    }

    public static final int getHoursComponent-impl(long $this) {
        return Duration.isInfinite-impl($this) ? 0 : (int)(Duration.getInWholeHours-impl($this) % (long)24);
    }

    public static final int getMinutesComponent-impl(long $this) {
        return Duration.isInfinite-impl($this) ? 0 : (int)(Duration.getInWholeMinutes-impl($this) % (long)60);
    }

    public static final int getSecondsComponent-impl(long $this) {
        return Duration.isInfinite-impl($this) ? 0 : (int)(Duration.getInWholeSeconds-impl($this) % (long)60);
    }

    public static final int getNanosecondsComponent-impl(long $this) {
        return Duration.isInfinite-impl($this) ? 0 : (Duration.isInMillis-impl($this) ? (int)DurationKt.access$millisToNanos(Duration.getValue-impl($this) % (long)1000) : (int)(Duration.getValue-impl($this) % (long)1000000000));
    }

    public static final double toDouble-impl(long $this, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        long l = $this;
        return l == INFINITE ? Double.POSITIVE_INFINITY : (l == NEG_INFINITE ? Double.NEGATIVE_INFINITY : DurationUnitKt.convertDurationUnit((double)Duration.getValue-impl($this), Duration.getStorageUnit-impl($this), unit));
    }

    public static final long toLong-impl(long $this, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        long l = $this;
        return l == INFINITE ? Long.MAX_VALUE : (l == NEG_INFINITE ? Long.MIN_VALUE : DurationUnitKt.convertDurationUnit(Duration.getValue-impl($this), Duration.getStorageUnit-impl($this), unit));
    }

    public static final int toInt-impl(long $this, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        return (int)RangesKt.coerceIn(Duration.toLong-impl($this, unit), (long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE);
    }

    public static final double getInDays-impl(long $this) {
        return Duration.toDouble-impl($this, TimeUnit.DAYS);
    }

    public static final double getInHours-impl(long $this) {
        return Duration.toDouble-impl($this, TimeUnit.HOURS);
    }

    public static final double getInMinutes-impl(long $this) {
        return Duration.toDouble-impl($this, TimeUnit.MINUTES);
    }

    public static final double getInSeconds-impl(long $this) {
        return Duration.toDouble-impl($this, TimeUnit.SECONDS);
    }

    public static final double getInMilliseconds-impl(long $this) {
        return Duration.toDouble-impl($this, TimeUnit.MILLISECONDS);
    }

    public static final double getInMicroseconds-impl(long $this) {
        return Duration.toDouble-impl($this, TimeUnit.MICROSECONDS);
    }

    public static final double getInNanoseconds-impl(long $this) {
        return Duration.toDouble-impl($this, TimeUnit.NANOSECONDS);
    }

    public static final long getInWholeDays-impl(long $this) {
        return Duration.toLong-impl($this, TimeUnit.DAYS);
    }

    public static final long getInWholeHours-impl(long $this) {
        return Duration.toLong-impl($this, TimeUnit.HOURS);
    }

    public static final long getInWholeMinutes-impl(long $this) {
        return Duration.toLong-impl($this, TimeUnit.MINUTES);
    }

    public static final long getInWholeSeconds-impl(long $this) {
        return Duration.toLong-impl($this, TimeUnit.SECONDS);
    }

    public static final long getInWholeMilliseconds-impl(long $this) {
        return Duration.isInMillis-impl($this) && Duration.isFinite-impl($this) ? Duration.getValue-impl($this) : Duration.toLong-impl($this, TimeUnit.MILLISECONDS);
    }

    public static final long getInWholeMicroseconds-impl(long $this) {
        return Duration.toLong-impl($this, TimeUnit.MICROSECONDS);
    }

    public static final long getInWholeNanoseconds-impl(long $this) {
        long value = Duration.getValue-impl($this);
        return Duration.isInNanos-impl($this) ? value : (value > 9223372036854L ? Long.MAX_VALUE : (value < -9223372036854L ? Long.MIN_VALUE : DurationKt.access$millisToNanos(value)));
    }

    @Deprecated(message="Use inWholeNanoseconds property instead.", replaceWith=@ReplaceWith(imports={}, expression="this.inWholeNanoseconds"))
    public static final long toLongNanoseconds-impl(long $this) {
        return Duration.getInWholeNanoseconds-impl($this);
    }

    @Deprecated(message="Use inWholeMilliseconds property instead.", replaceWith=@ReplaceWith(imports={}, expression="this.inWholeMilliseconds"))
    public static final long toLongMilliseconds-impl(long $this) {
        return Duration.getInWholeMilliseconds-impl($this);
    }

    @NotNull
    public static String toString-impl(long $this) {
        String string2;
        long l = $this;
        if (l == 0L) {
            string2 = "0s";
        } else if (l == INFINITE) {
            string2 = "Infinity";
        } else if (l == NEG_INFINITE) {
            string2 = "-Infinity";
        } else {
            String string3;
            TimeUnit timeUnit;
            TimeUnit it;
            boolean bl;
            boolean bl2;
            TimeUnit timeUnit2;
            double absNs = Duration.toDouble-impl(Duration.getAbsoluteValue-UwyO8pc($this), TimeUnit.NANOSECONDS);
            boolean scientific = false;
            int maxDecimals = 0;
            if (absNs < 1.0E-6) {
                timeUnit2 = TimeUnit.SECONDS;
                bl2 = false;
                bl = false;
                it = timeUnit2;
                boolean bl3 = false;
                scientific = true;
                timeUnit = timeUnit2;
            } else if (absNs < 1.0) {
                timeUnit2 = TimeUnit.NANOSECONDS;
                bl2 = false;
                bl = false;
                it = timeUnit2;
                boolean bl4 = false;
                maxDecimals = 7;
                timeUnit = timeUnit2;
            } else if (absNs < 1000.0) {
                timeUnit = TimeUnit.NANOSECONDS;
            } else if (absNs < 1000000.0) {
                timeUnit = TimeUnit.MICROSECONDS;
            } else if (absNs < 1.0E9) {
                timeUnit = TimeUnit.MILLISECONDS;
            } else if (absNs < 1.0E12) {
                timeUnit = TimeUnit.SECONDS;
            } else if (absNs < 6.0E13) {
                timeUnit = TimeUnit.MINUTES;
            } else if (absNs < 3.6E15) {
                timeUnit = TimeUnit.HOURS;
            } else if (absNs < 8.64E20) {
                timeUnit = TimeUnit.DAYS;
            } else {
                timeUnit2 = TimeUnit.DAYS;
                bl2 = false;
                bl = false;
                it = timeUnit2;
                boolean bl5 = false;
                scientific = true;
                timeUnit = timeUnit2;
            }
            TimeUnit unit = timeUnit;
            double value = Duration.toDouble-impl($this, unit);
            StringBuilder stringBuilder = new StringBuilder();
            if (scientific) {
                string3 = FormatToDecimalsKt.formatScientific(value);
            } else if (maxDecimals > 0) {
                string3 = FormatToDecimalsKt.formatUpToDecimals(value, maxDecimals);
            } else {
                bl = false;
                string3 = FormatToDecimalsKt.formatToExactDecimals(value, Duration.precision-impl($this, Math.abs(value)));
            }
            string2 = stringBuilder.append(string3).append(DurationUnitKt.shortName(unit)).toString();
        }
        return string2;
    }

    private static final int precision-impl(long $this, double value) {
        return value < 1.0 ? 3 : (value < (double)10 ? 2 : (value < (double)100 ? 1 : 0));
    }

    @NotNull
    public static final String toString-impl(long $this, @NotNull TimeUnit unit, int decimals) {
        double number2;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        boolean bl = decimals >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "decimals must be not negative, but was " + decimals;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        double d = number2 = Duration.toDouble-impl($this, unit);
        boolean bl5 = false;
        if (Double.isInfinite(d)) {
            return String.valueOf(number2);
        }
        boolean bl6 = false;
        return (Math.abs(number2) < 1.0E14 ? FormatToDecimalsKt.formatToExactDecimals(number2, RangesKt.coerceAtMost(decimals, 12)) : FormatToDecimalsKt.formatScientific(number2)) + DurationUnitKt.shortName(unit);
    }

    public static /* synthetic */ String toString-impl$default(long l, TimeUnit timeUnit, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return Duration.toString-impl(l, timeUnit, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toIsoString-impl(long $this) {
        void minutes2;
        boolean hasMinutes;
        void nanoseconds;
        void seconds2;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        if (Duration.isNegative-impl($this)) {
            $this$buildString.append('-');
        }
        $this$buildString.append("PT");
        long $this$iv = Duration.getAbsoluteValue-UwyO8pc($this);
        boolean $i$f$toComponents = false;
        boolean bl6 = false;
        int n = Duration.getNanosecondsComponent-impl($this$iv);
        int n2 = Duration.getSecondsComponent-impl($this$iv);
        int n3 = Duration.getMinutesComponent-impl($this$iv);
        int hours2 = Duration.toInt-impl($this$iv, TimeUnit.HOURS);
        boolean bl7 = false;
        boolean hasHours = hours2 != 0;
        boolean hasSeconds = seconds2 != false || nanoseconds != false;
        boolean bl8 = hasMinutes = minutes2 != false || hasSeconds && hasHours;
        if (hasHours) {
            $this$buildString.append(hours2).append('H');
        }
        if (hasMinutes) {
            $this$buildString.append((int)minutes2).append('M');
        }
        if (hasSeconds || !hasHours && !hasMinutes) {
            $this$buildString.append((int)seconds2);
            if (nanoseconds != false) {
                $this$buildString.append('.');
                String nss = StringsKt.padStart(String.valueOf((int)nanoseconds), 9, '0');
                if (nanoseconds % 1000000 == false) {
                    StringBuilder stringBuilder2 = $this$buildString;
                    int n4 = 0;
                    int n5 = 3;
                    boolean bl9 = false;
                    Intrinsics.checkNotNullExpressionValue(stringBuilder2.append(nss, n4, n5), "this.append(value, startIndex, endIndex)");
                } else if (nanoseconds % 1000 == false) {
                    StringBuilder stringBuilder3 = $this$buildString;
                    int n6 = 0;
                    int n7 = 6;
                    boolean bl10 = false;
                    Intrinsics.checkNotNullExpressionValue(stringBuilder3.append(nss, n6, n7), "this.append(value, startIndex, endIndex)");
                } else {
                    $this$buildString.append(nss);
                }
            }
            $this$buildString.append('S');
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static long constructor-impl(long rawValue) {
        if (Duration.isInNanos-impl(rawValue)) {
            long l = Duration.getValue-impl(rawValue);
            if (-4611686018426999999L > l || 4611686018426999999L < l) {
                throw (Throwable)((Object)new AssertionError((Object)(Duration.getValue-impl(rawValue) + " ns is out of nanoseconds range")));
            }
        } else {
            long l = Duration.getValue-impl(rawValue);
            if (-4611686018427387903L > l || 0x3FFFFFFFFFFFFFFFL < l) {
                throw (Throwable)((Object)new AssertionError((Object)(Duration.getValue-impl(rawValue) + " ms is out of milliseconds range")));
            }
            l = Duration.getValue-impl(rawValue);
            if (-4611686018426L <= l && 4611686018426L >= l) {
                throw (Throwable)((Object)new AssertionError((Object)(Duration.getValue-impl(rawValue) + " ms is denormalized")));
            }
        }
        return rawValue;
    }

    public static final /* synthetic */ Duration box-impl(long v) {
        return new Duration(v);
    }

    public static int hashCode-impl(long l) {
        long l2 = l;
        return (int)(l2 ^ l2 >>> 32);
    }

    public static boolean equals-impl(long l, Object object) {
        long l2;
        return object instanceof Duration && l == (l2 = ((Duration)object).unbox-impl());
    }

    public static final boolean equals-impl0(long p1, long p2) {
        return p1 == p2;
    }

    public final /* synthetic */ long unbox-impl() {
        return this.rawValue;
    }

    static {
        Companion = new Companion(null);
        ZERO = Duration.constructor-impl(0L);
        INFINITE = DurationKt.access$durationOfMillis(0x3FFFFFFFFFFFFFFFL);
        NEG_INFINITE = DurationKt.access$durationOfMillis(-4611686018427387903L);
    }

    public int hashCode() {
        return Duration.hashCode-impl(this.rawValue);
    }

    public boolean equals(Object object) {
        return Duration.equals-impl(this.rawValue, object);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011J\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0016H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0017J\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0018H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0015J\u001d\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0016H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0017J\u001d\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0018H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u001d\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0015J\u001d\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0016H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0017J\u001d\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0018H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0019J\u001d\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010\u0015J\u001d\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0016H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010\u0017J\u001d\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0018H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010\u0019J\u001d\u0010 \u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\u0015J\u001d\u0010 \u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0016H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\u0017J\u001d\u0010 \u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0018H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\u0019J\u001d\u0010\"\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b#\u0010\u0015J\u001d\u0010\"\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0016H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b#\u0010\u0017J\u001d\u0010\"\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0018H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b#\u0010\u0019J\u001d\u0010$\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b%\u0010\u0015J\u001d\u0010$\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0016H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b%\u0010\u0017J\u001d\u0010$\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0018H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b%\u0010\u0019R\u0019\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\b\u001a\u00020\u0004X\u0080\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\t\u0010\u0006R\u0019\u0010\n\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000b\u0010\u0006\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006&"}, d2={"Lkotlin/time/Duration$Companion;", "", "()V", "INFINITE", "Lkotlin/time/Duration;", "getINFINITE-UwyO8pc", "()J", "J", "NEG_INFINITE", "getNEG_INFINITE-UwyO8pc$kotlin_stdlib", "ZERO", "getZERO-UwyO8pc", "convert", "", "value", "sourceUnit", "Ljava/util/concurrent/TimeUnit;", "Lkotlin/time/DurationUnit;", "targetUnit", "days", "days-UwyO8pc", "(D)J", "", "(I)J", "", "(J)J", "hours", "hours-UwyO8pc", "microseconds", "microseconds-UwyO8pc", "milliseconds", "milliseconds-UwyO8pc", "minutes", "minutes-UwyO8pc", "nanoseconds", "nanoseconds-UwyO8pc", "seconds", "seconds-UwyO8pc", "kotlin-stdlib"})
    public static final class Companion {
        public final long getZERO-UwyO8pc() {
            return ZERO;
        }

        public final long getINFINITE-UwyO8pc() {
            return INFINITE;
        }

        public final long getNEG_INFINITE-UwyO8pc$kotlin_stdlib() {
            return NEG_INFINITE;
        }

        public final double convert(double value, @NotNull TimeUnit sourceUnit, @NotNull TimeUnit targetUnit) {
            Intrinsics.checkNotNullParameter((Object)sourceUnit, "sourceUnit");
            Intrinsics.checkNotNullParameter((Object)targetUnit, "targetUnit");
            return DurationUnitKt.convertDurationUnit(value, sourceUnit, targetUnit);
        }

        @SinceKotlin(version="1.5")
        public final long nanoseconds-UwyO8pc(int value) {
            return DurationKt.toDuration(value, TimeUnit.NANOSECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long nanoseconds-UwyO8pc(long value) {
            return DurationKt.toDuration(value, TimeUnit.NANOSECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long nanoseconds-UwyO8pc(double value) {
            return DurationKt.toDuration(value, TimeUnit.NANOSECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long microseconds-UwyO8pc(int value) {
            return DurationKt.toDuration(value, TimeUnit.MICROSECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long microseconds-UwyO8pc(long value) {
            return DurationKt.toDuration(value, TimeUnit.MICROSECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long microseconds-UwyO8pc(double value) {
            return DurationKt.toDuration(value, TimeUnit.MICROSECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long milliseconds-UwyO8pc(int value) {
            return DurationKt.toDuration(value, TimeUnit.MILLISECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long milliseconds-UwyO8pc(long value) {
            return DurationKt.toDuration(value, TimeUnit.MILLISECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long milliseconds-UwyO8pc(double value) {
            return DurationKt.toDuration(value, TimeUnit.MILLISECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long seconds-UwyO8pc(int value) {
            return DurationKt.toDuration(value, TimeUnit.SECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long seconds-UwyO8pc(long value) {
            return DurationKt.toDuration(value, TimeUnit.SECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long seconds-UwyO8pc(double value) {
            return DurationKt.toDuration(value, TimeUnit.SECONDS);
        }

        @SinceKotlin(version="1.5")
        public final long minutes-UwyO8pc(int value) {
            return DurationKt.toDuration(value, TimeUnit.MINUTES);
        }

        @SinceKotlin(version="1.5")
        public final long minutes-UwyO8pc(long value) {
            return DurationKt.toDuration(value, TimeUnit.MINUTES);
        }

        @SinceKotlin(version="1.5")
        public final long minutes-UwyO8pc(double value) {
            return DurationKt.toDuration(value, TimeUnit.MINUTES);
        }

        @SinceKotlin(version="1.5")
        public final long hours-UwyO8pc(int value) {
            return DurationKt.toDuration(value, TimeUnit.HOURS);
        }

        @SinceKotlin(version="1.5")
        public final long hours-UwyO8pc(long value) {
            return DurationKt.toDuration(value, TimeUnit.HOURS);
        }

        @SinceKotlin(version="1.5")
        public final long hours-UwyO8pc(double value) {
            return DurationKt.toDuration(value, TimeUnit.HOURS);
        }

        @SinceKotlin(version="1.5")
        public final long days-UwyO8pc(int value) {
            return DurationKt.toDuration(value, TimeUnit.DAYS);
        }

        @SinceKotlin(version="1.5")
        public final long days-UwyO8pc(long value) {
            return DurationKt.toDuration(value, TimeUnit.DAYS);
        }

        @SinceKotlin(version="1.5")
        public final long days-UwyO8pc(double value) {
            return DurationKt.toDuration(value, TimeUnit.DAYS);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

