/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderKt;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassDeserializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeserializationComponents components;
    @NotNull
    private final Function1<ClassKey, ClassDescriptor> classes;
    @NotNull
    private static final Set<ClassId> BLACK_LIST = SetsKt.setOf(ClassId.topLevel(StandardNames.FqNames.cloneable.toSafe()));

    public ClassDeserializer(@NotNull DeserializationComponents components) {
        Intrinsics.checkNotNullParameter(components, "components");
        this.components = components;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassKey, ClassDescriptor>(this){
            final /* synthetic */ ClassDeserializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ClassDescriptor invoke(@NotNull ClassKey key2) {
                Intrinsics.checkNotNullParameter(key2, "key");
                return ClassDeserializer.access$createClass(this.this$0, key2);
            }
        });
    }

    @Nullable
    public final ClassDescriptor deserializeClass(@NotNull ClassId classId, @Nullable ClassData classData) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.classes.invoke(new ClassKey(classId, classData));
    }

    public static /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassData classData, int n, Object object) {
        if ((n & 2) != 0) {
            classData = null;
        }
        return classDeserializer.deserializeClass(classId, classData);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final ClassDescriptor createClass(ClassKey key) {
        block13: {
            block11: {
                block12: {
                    classId = key.getClassId();
                    for (Object factory : this.components.getFictitiousClassDescriptorFactories()) {
                        var5_5 = factory.createClass(classId);
                        if (var5_5 == null) continue;
                        var6_6 = var5_5;
                        var7_8 = false;
                        var8_10 = false;
                        it = var6_6;
                        $i$a$-let-ClassDeserializer$createClass$1 = false;
                        return it;
                    }
                    if (ClassDeserializer.BLACK_LIST.contains(classId)) {
                        return null;
                    }
                    factory = key.getClassData();
                    if (factory == null) {
                        var5_5 = this.components.getClassDataFinder().findClassData(classId);
                        if (var5_5 == null) {
                            return null;
                        }
                        v0 = var5_5;
                    } else {
                        v0 = factory;
                    }
                    var3_3 = v0;
                    nameResolver = var3_3.component1();
                    classProto = var3_3.component2();
                    metadataVersion = var3_3.component3();
                    sourceElement = var3_3.component4();
                    outerClassId = classId.getOuterClassId();
                    if (outerClassId == null) break block12;
                    var12_16 = ClassDeserializer.deserializeClass$default(this, outerClassId, null, 2, null);
                    v1 = var11_17 = var12_16 instanceof DeserializedClassDescriptor != false ? (DeserializedClassDescriptor)var12_16 : null;
                    if (var11_17 == null) {
                        return null;
                    }
                    outerClass = var11_17;
                    var11_17 = classId.getShortClassName();
                    Intrinsics.checkNotNullExpressionValue(var11_17, "classId.shortClassName");
                    if (!outerClass.hasNestedClass$deserialization((Name)var11_17)) {
                        return null;
                    }
                    v2 = outerClass.getC();
                    break block13;
                }
                v3 = this.components.getPackageFragmentProvider();
                var11_17 = classId.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue(var11_17, "classId.packageFqName");
                fragments = PackageFragmentProviderKt.packageFragments(v3, (FqName)var11_17);
                $this$firstOrNull$iv = fragments;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (PackageFragmentDescriptor)element$iv;
                    $i$a$-firstOrNull-ClassDeserializer$createClass$outerContext$fragment$1 = false;
                    if (!(it instanceof DeserializedPackageFragment)) ** GOTO lbl-1000
                    v4 = (DeserializedPackageFragment)it;
                    var19_24 = classId.getShortClassName();
                    Intrinsics.checkNotNullExpressionValue(var19_24, "classId.shortClassName");
                    if (v4.hasTopLevelClass(var19_24)) lbl-1000:
                    // 2 sources

                    {
                        v5 = true;
                    } else {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v6 = element$iv;
                    break block11;
                }
                v6 = null;
            }
            var12_16 = v6;
            if (var12_16 == null) {
                return null;
            }
            fragment /* !! */  = var12_16;
            var12_16 = classProto.getTypeTable();
            Intrinsics.checkNotNullExpressionValue(var12_16, "classProto.typeTable");
            v7 = new TypeTable((ProtoBuf.TypeTable)var12_16);
            var12_16 = classProto.getVersionRequirementTable();
            Intrinsics.checkNotNullExpressionValue(var12_16, "classProto.versionRequirementTable");
            v2 = this.components.createContext((PackageFragmentDescriptor)fragment /* !! */ , nameResolver, v7, VersionRequirementTable.Companion.create((ProtoBuf.VersionRequirementTable)var12_16), metadataVersion, null);
        }
        outerContext = v2;
        return new DeserializedClassDescriptor(outerContext, classProto, nameResolver, metadataVersion, sourceElement);
    }

    public static final /* synthetic */ ClassDescriptor access$createClass(ClassDeserializer $this, ClassKey key2) {
        return $this.createClass(key2);
    }

    private static final class ClassKey {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final ClassData classData;

        public ClassKey(@NotNull ClassId classId, @Nullable ClassData classData) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            this.classId = classId;
            this.classData = classData;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final ClassData getClassData() {
            return this.classData;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ClassKey && Intrinsics.areEqual(this.classId, ((ClassKey)other).classId);
        }

        public int hashCode() {
            return this.classId.hashCode();
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ClassId> getBLACK_LIST() {
            return BLACK_LIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

