/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.DeprecationLevel;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VersionRequirement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Version version;
    @NotNull
    private final ProtoBuf.VersionRequirement.VersionKind kind;
    @NotNull
    private final DeprecationLevel level;
    @Nullable
    private final Integer errorCode;
    @Nullable
    private final String message;

    public VersionRequirement(@NotNull Version version, @NotNull ProtoBuf.VersionRequirement.VersionKind kind, @NotNull DeprecationLevel level, @Nullable Integer errorCode, @Nullable String message) {
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter(kind, "kind");
        Intrinsics.checkNotNullParameter((Object)level, "level");
        this.version = version;
        this.kind = kind;
        this.level = level;
        this.errorCode = errorCode;
        this.message = message;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    @NotNull
    public final ProtoBuf.VersionRequirement.VersionKind getKind() {
        return this.kind;
    }

    @NotNull
    public String toString() {
        return "since " + this.version + ' ' + (Object)((Object)this.level) + (this.errorCode != null ? Intrinsics.stringPlus(" error ", this.errorCode) : "") + (this.message != null ? Intrinsics.stringPlus(": ", this.message) : "");
    }

    public static final class Version {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int major;
        private final int minor;
        private final int patch;
        @JvmField
        @NotNull
        public static final Version INFINITY = new Version(256, 256, 256);

        public Version(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public /* synthetic */ Version(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            this(n, n2, n3);
        }

        @NotNull
        public final String asString() {
            return this.patch == 0 ? "" + this.major + '.' + this.minor : "" + this.major + '.' + this.minor + '.' + this.patch;
        }

        @NotNull
        public String toString() {
            return this.asString();
        }

        public int hashCode() {
            int result2 = this.major;
            result2 = result2 * 31 + this.minor;
            result2 = result2 * 31 + this.patch;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Version)) {
                return false;
            }
            Version version = (Version)other;
            if (this.major != version.major) {
                return false;
            }
            if (this.minor != version.minor) {
                return false;
            }
            return this.patch == version.patch;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Version decode(@Nullable Integer version, @Nullable Integer versionFull) {
                return versionFull != null ? new Version((int)(versionFull & 0xFF), versionFull >> 8 & 0xFF, versionFull >> 16 & 0xFF) : (version != null ? new Version(version & 7, version >> 3 & 0xF, version >> 7 & 0x7F) : INFINITY);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VersionRequirement> create(@NotNull MessageLite proto, @NotNull NameResolver nameResolver, @NotNull VersionRequirementTable table) {
            void $this$mapNotNullTo$iv$iv;
            List<Integer> list;
            Intrinsics.checkNotNullParameter(proto, "proto");
            Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
            Intrinsics.checkNotNullParameter(table, "table");
            MessageLite messageLite = proto;
            if (messageLite instanceof ProtoBuf.Class) {
                list = ((ProtoBuf.Class)proto).getVersionRequirementList();
            } else if (messageLite instanceof ProtoBuf.Constructor) {
                list = ((ProtoBuf.Constructor)proto).getVersionRequirementList();
            } else if (messageLite instanceof ProtoBuf.Function) {
                list = ((ProtoBuf.Function)proto).getVersionRequirementList();
            } else if (messageLite instanceof ProtoBuf.Property) {
                list = ((ProtoBuf.Property)proto).getVersionRequirementList();
            } else if (messageLite instanceof ProtoBuf.TypeAlias) {
                list = ((ProtoBuf.TypeAlias)proto).getVersionRequirementList();
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus("Unexpected declaration: ", proto.getClass()));
            }
            List<Integer> ids = list;
            Intrinsics.checkNotNullExpressionValue(ids, "ids");
            Iterable $this$mapNotNull$iv = ids;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VersionRequirement versionRequirement;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Integer id = (Integer)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(id, "id");
                if (Companion.create(id, nameResolver, table) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                VersionRequirement it$iv$iv = versionRequirement;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final VersionRequirement create(int id, @NotNull NameResolver nameResolver, @NotNull VersionRequirementTable table) {
            DeprecationLevel deprecationLevel;
            Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
            Intrinsics.checkNotNullParameter(table, "table");
            ProtoBuf.VersionRequirement versionRequirement = table.get(id);
            if (versionRequirement == null) {
                return null;
            }
            ProtoBuf.VersionRequirement info2 = versionRequirement;
            Version version = Version.Companion.decode(info2.hasVersion() ? Integer.valueOf(info2.getVersion()) : null, info2.hasVersionFull() ? Integer.valueOf(info2.getVersionFull()) : null);
            ProtoBuf.VersionRequirement.Level level = info2.getLevel();
            Intrinsics.checkNotNull(level);
            ProtoBuf.VersionRequirement.Level level2 = level;
            int n = WhenMappings.$EnumSwitchMapping$0[level2.ordinal()];
            switch (n) {
                case 1: {
                    deprecationLevel = DeprecationLevel.WARNING;
                    break;
                }
                case 2: {
                    deprecationLevel = DeprecationLevel.ERROR;
                    break;
                }
                case 3: {
                    deprecationLevel = DeprecationLevel.HIDDEN;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DeprecationLevel level3 = deprecationLevel;
            Integer errorCode = info2.hasErrorCode() ? Integer.valueOf(info2.getErrorCode()) : null;
            String message = info2.hasMessage() ? nameResolver.getString(info2.getMessage()) : null;
            ProtoBuf.VersionRequirement.VersionKind versionKind = info2.getVersionKind();
            Intrinsics.checkNotNullExpressionValue(versionKind, "info.versionKind");
            return new VersionRequirement(version, versionKind, level3, errorCode, message);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProtoBuf.VersionRequirement.Level.values().length];
                nArray[ProtoBuf.VersionRequirement.Level.WARNING.ordinal()] = 1;
                nArray[ProtoBuf.VersionRequirement.Level.ERROR.ordinal()] = 2;
                nArray[ProtoBuf.VersionRequirement.Level.HIDDEN.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

