/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.EmptyPackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.MutableClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuspendFunctionTypesKt {
    @NotNull
    private static final MutableClassDescriptor FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL;
    @NotNull
    private static final MutableClassDescriptor FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SimpleType transformSuspendFunctionToRuntimeFunctionType(@NotNull KotlinType suspendFunType, boolean isReleaseCoroutines) {
        Collection<KotlinType> collection2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(suspendFunType, "suspendFunType");
        boolean bl = FunctionTypesKt.isSuspendFunctionType(suspendFunType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SuspendFunctionTypesKt$transformSuspendFunctionToRuntimeFunctionType$22 = false;
            String $i$a$-assert-SuspendFunctionTypesKt$transformSuspendFunctionToRuntimeFunctionType$22 = Intrinsics.stringPlus("This type should be suspend function type: ", suspendFunType);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-SuspendFunctionTypesKt$transformSuspendFunctionToRuntimeFunctionType$22));
        }
        Object object = FunctionTypesKt.getValueParameterTypesFromFunctionType(suspendFunType);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(suspendFunType);
        Annotations annotations2 = suspendFunType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(suspendFunType);
        boolean $i$f$map = false;
        void $i$a$-assert-SuspendFunctionTypesKt$transformSuspendFunctionToRuntimeFunctionType$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl3 = false;
            KotlinType kotlinType2 = p0.getType();
            collection2.add(kotlinType2);
        }
        collection2 = (List)destination$iv$iv;
        Collection collection3 = collection2;
        Annotations annotations3 = Annotations.Companion.getEMPTY();
        object = isReleaseCoroutines ? FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE.getTypeConstructor() : FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(object, "if (isReleaseCoroutines) FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE.typeConstructor\n                    else FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL.typeConstructor");
        List<SimpleType> list = CollectionsKt.plus(collection3, KotlinTypeFactory.simpleType$default(annotations3, (TypeConstructor)object, CollectionsKt.listOf(TypeUtilsKt.asTypeProjection(FunctionTypesKt.getReturnTypeFromFunctionType(suspendFunType))), false, null, 16, null));
        object = TypeUtilsKt.getBuiltIns(suspendFunType).getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue(object, "suspendFunType.builtIns.nullableAnyType");
        return FunctionTypesKt.createFunctionType$default(kotlinBuiltIns, annotations2, kotlinType, list, null, (KotlinType)object, false, 64, null).makeNullableAsSpecified(suspendFunType.isMarkedNullable());
    }

    public static final boolean isContinuation(@Nullable FqName name2, boolean isReleaseCoroutines) {
        return isReleaseCoroutines ? Intrinsics.areEqual(name2, StandardNames.CONTINUATION_INTERFACE_FQ_NAME_RELEASE) : Intrinsics.areEqual(name2, StandardNames.CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL);
    }

    static {
        TypeParameterDescriptor p0;
        DeclarationDescriptor declarationDescriptor = ErrorUtils.getErrorModule();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getErrorModule()");
        declarationDescriptor = new MutableClassDescriptor(new EmptyPackageFragmentDescriptor((ModuleDescriptor)declarationDescriptor, StandardNames.COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL), ClassKind.INTERFACE, false, false, StandardNames.CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL.shortName(), SourceElement.NO_SOURCE, LockBasedStorageManager.NO_LOCKS);
        boolean bl = false;
        boolean bl2 = false;
        DeclarationDescriptor $this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL_u24lambda_u2d0 = declarationDescriptor;
        boolean bl3 = false;
        ((MutableClassDescriptor)$this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL_u24lambda_u2d0).setModality(Modality.ABSTRACT);
        ((MutableClassDescriptor)$this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL_u24lambda_u2d0).setVisibility(DescriptorVisibilities.PUBLIC);
        TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptorImpl.createWithDefaultBound($this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL_u24lambda_u2d0, Annotations.Companion.getEMPTY(), false, Variance.IN_VARIANCE, Name.identifier("T"), 0, LockBasedStorageManager.NO_LOCKS);
        boolean bl4 = false;
        boolean bl5 = false;
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        DeclarationDescriptor declarationDescriptor2 = $this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL_u24lambda_u2d0;
        boolean bl6 = false;
        List<Object> list = CollectionsKt.listOf(p0);
        ((MutableClassDescriptor)declarationDescriptor2).setTypeParameterDescriptors(list);
        ((MutableClassDescriptor)$this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL_u24lambda_u2d0).createTypeConstructor();
        FAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL = declarationDescriptor;
        declarationDescriptor = ErrorUtils.getErrorModule();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getErrorModule()");
        declarationDescriptor = new MutableClassDescriptor(new EmptyPackageFragmentDescriptor((ModuleDescriptor)declarationDescriptor, StandardNames.COROUTINES_PACKAGE_FQ_NAME_RELEASE), ClassKind.INTERFACE, false, false, StandardNames.CONTINUATION_INTERFACE_FQ_NAME_RELEASE.shortName(), SourceElement.NO_SOURCE, LockBasedStorageManager.NO_LOCKS);
        bl = false;
        bl2 = false;
        DeclarationDescriptor $this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE_u24lambda_u2d2 = declarationDescriptor;
        boolean bl7 = false;
        ((MutableClassDescriptor)$this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE_u24lambda_u2d2).setModality(Modality.ABSTRACT);
        ((MutableClassDescriptor)$this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE_u24lambda_u2d2).setVisibility(DescriptorVisibilities.PUBLIC);
        typeParameterDescriptor = TypeParameterDescriptorImpl.createWithDefaultBound($this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE_u24lambda_u2d2, Annotations.Companion.getEMPTY(), false, Variance.IN_VARIANCE, Name.identifier("T"), 0, LockBasedStorageManager.NO_LOCKS);
        bl4 = false;
        bl5 = false;
        p0 = typeParameterDescriptor;
        declarationDescriptor2 = $this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE_u24lambda_u2d2;
        boolean bl8 = false;
        list = CollectionsKt.listOf(p0);
        ((MutableClassDescriptor)declarationDescriptor2).setTypeParameterDescriptors(list);
        ((MutableClassDescriptor)$this$FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE_u24lambda_u2d2).createTypeConstructor();
        FAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE = declarationDescriptor;
    }
}

