/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class SpreadBuilder {
    private final ArrayList<Object> list;

    public SpreadBuilder(int size) {
        this.list = new ArrayList(size);
    }

    public void addSpread(Object container2) {
        if (container2 == null) {
            return;
        }
        if (container2 instanceof Object[]) {
            Object[] array2 = (Object[])container2;
            if (array2.length > 0) {
                this.list.ensureCapacity(this.list.size() + array2.length);
                Collections.addAll(this.list, array2);
            }
        } else if (container2 instanceof Collection) {
            this.list.addAll((Collection)container2);
        } else if (container2 instanceof Iterable) {
            for (Object element : (Iterable)container2) {
                this.list.add(element);
            }
        } else if (container2 instanceof Iterator) {
            Iterator iterator2 = (Iterator)container2;
            while (iterator2.hasNext()) {
                this.list.add(iterator2.next());
            }
        } else {
            throw new UnsupportedOperationException("Don't know how to spread " + container2.getClass());
        }
    }

    public int size() {
        return this.list.size();
    }

    public void add(Object element) {
        this.list.add(element);
    }

    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }
}

