/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.impl;

import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.ext.auth.PRNG;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.sstore.AbstractSession;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SharedDataSessionImpl
extends AbstractSession
implements ClusterSerializable,
Shareable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte TYPE_LONG = 1;
    private static final byte TYPE_INT = 2;
    private static final byte TYPE_SHORT = 3;
    private static final byte TYPE_BYTE = 4;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_FLOAT = 6;
    private static final byte TYPE_CHAR = 7;
    private static final byte TYPE_BOOLEAN = 8;
    private static final byte TYPE_STRING = 9;
    private static final byte TYPE_BUFFER = 10;
    private static final byte TYPE_BYTES = 11;
    private static final byte TYPE_CLUSTER_SERIALIZABLE = 13;

    public SharedDataSessionImpl() {
    }

    public SharedDataSessionImpl(PRNG random) {
        super(random);
    }

    public SharedDataSessionImpl(PRNG random, long timeout, int length) {
        super(random, timeout, length);
    }

    @Override
    public void writeToBuffer(Buffer buff) {
        byte[] bytes2 = this.id().getBytes(UTF8);
        buff.appendInt(bytes2.length).appendBytes(bytes2);
        buff.appendLong(this.timeout());
        buff.appendLong(this.lastAccessed());
        buff.appendInt(this.version());
        Buffer dataBuf = this.writeDataToBuffer();
        buff.appendBuffer(dataBuf);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int len = buffer.getInt(pos);
        byte[] bytes2 = buffer.getBytes(pos += 4, pos + len);
        this.setId(new String(bytes2, UTF8));
        this.setTimeout(buffer.getLong(pos += len));
        this.setLastAccessed(buffer.getLong(pos += 8));
        this.setVersion(buffer.getInt(pos += 8));
        int start2 = pos += 4;
        int end2 = pos = this.readDataFromBuffer(pos, buffer);
        return pos;
    }

    private Buffer writeDataToBuffer() {
        Buffer buffer = Buffer.buffer();
        if (this.isEmpty()) {
            buffer.appendInt(0);
        } else {
            Map<String, Object> data2 = this.data();
            buffer.appendInt(data2.size());
            for (Map.Entry<String, Object> entry : data2.entrySet()) {
                byte[] bytes2;
                String key2 = entry.getKey();
                byte[] keyBytes = key2.getBytes(UTF8);
                buffer.appendInt(keyBytes.length).appendBytes(keyBytes);
                Object val2 = entry.getValue();
                if (val2 instanceof Long) {
                    buffer.appendByte((byte)1).appendLong((Long)val2);
                    continue;
                }
                if (val2 instanceof Integer) {
                    buffer.appendByte((byte)2).appendInt((Integer)val2);
                    continue;
                }
                if (val2 instanceof Short) {
                    buffer.appendByte((byte)3).appendShort((Short)val2);
                    continue;
                }
                if (val2 instanceof Byte) {
                    buffer.appendByte((byte)4).appendByte((Byte)val2);
                    continue;
                }
                if (val2 instanceof Double) {
                    buffer.appendByte((byte)5).appendDouble((Double)val2);
                    continue;
                }
                if (val2 instanceof Float) {
                    buffer.appendByte((byte)6).appendFloat(((Float)val2).floatValue());
                    continue;
                }
                if (val2 instanceof Character) {
                    buffer.appendByte((byte)7).appendShort((short)((Character)val2).charValue());
                    continue;
                }
                if (val2 instanceof Boolean) {
                    buffer.appendByte((byte)8).appendByte((byte)((Boolean)val2 != false ? 1 : 0));
                    continue;
                }
                if (val2 instanceof String) {
                    bytes2 = ((String)val2).getBytes(UTF8);
                    buffer.appendByte((byte)9).appendInt(bytes2.length).appendBytes(bytes2);
                    continue;
                }
                if (val2 instanceof Buffer) {
                    Buffer buff = (Buffer)val2;
                    buffer.appendByte((byte)10).appendInt(buff.length()).appendBuffer(buff);
                    continue;
                }
                if (val2 instanceof byte[]) {
                    bytes2 = (byte[])val2;
                    buffer.appendByte((byte)11).appendInt(bytes2.length).appendBytes(bytes2);
                    continue;
                }
                if (val2 instanceof ClusterSerializable) {
                    buffer.appendByte((byte)13);
                    String className = val2.getClass().getName();
                    byte[] classNameBytes = className.getBytes(UTF8);
                    buffer.appendInt(classNameBytes.length).appendBytes(classNameBytes);
                    ((ClusterSerializable)val2).writeToBuffer(buffer);
                    continue;
                }
                if (val2 == null) continue;
                throw new IllegalStateException("Invalid type for data in session: " + val2.getClass());
            }
        }
        return buffer;
    }

    private int readDataFromBuffer(int pos, Buffer buffer) {
        try {
            int entries2 = buffer.getInt(pos);
            pos += 4;
            if (entries2 > 0) {
                ConcurrentHashMap<String, Object> data2 = new ConcurrentHashMap<String, Object>(entries2);
                for (int i = 0; i < entries2; ++i) {
                    Object val2;
                    int keylen = buffer.getInt(pos);
                    byte[] keyBytes = buffer.getBytes(pos += 4, pos + keylen);
                    pos += keylen;
                    String key2 = new String(keyBytes, UTF8);
                    byte type2 = buffer.getByte(pos++);
                    switch (type2) {
                        case 1: {
                            val2 = buffer.getLong(pos);
                            pos += 8;
                            break;
                        }
                        case 2: {
                            val2 = buffer.getInt(pos);
                            pos += 4;
                            break;
                        }
                        case 3: {
                            val2 = buffer.getShort(pos);
                            pos += 2;
                            break;
                        }
                        case 4: {
                            val2 = buffer.getByte(pos);
                            ++pos;
                            break;
                        }
                        case 6: {
                            val2 = Float.valueOf(buffer.getFloat(pos));
                            pos += 4;
                            break;
                        }
                        case 5: {
                            val2 = buffer.getDouble(pos);
                            pos += 8;
                            break;
                        }
                        case 7: {
                            short s2 = buffer.getShort(pos);
                            pos += 2;
                            val2 = Character.valueOf((char)s2);
                            break;
                        }
                        case 8: {
                            byte b = buffer.getByte(pos);
                            ++pos;
                            val2 = b == 1;
                            break;
                        }
                        case 9: {
                            int len = buffer.getInt(pos);
                            byte[] bytes2 = buffer.getBytes(pos += 4, pos + len);
                            val2 = new String(bytes2, UTF8);
                            pos += len;
                            break;
                        }
                        case 10: {
                            int len = buffer.getInt(pos);
                            byte[] bytes2 = buffer.getBytes(pos += 4, pos + len);
                            val2 = Buffer.buffer(bytes2);
                            pos += len;
                            break;
                        }
                        case 11: {
                            int len = buffer.getInt(pos);
                            val2 = buffer.getBytes(pos += 4, pos + len);
                            pos += len;
                            break;
                        }
                        case 13: {
                            int classNameLen = buffer.getInt(pos);
                            byte[] classNameBytes = buffer.getBytes(pos += 4, pos + classNameLen);
                            pos += classNameLen;
                            String className = new String(classNameBytes, UTF8);
                            Class<?> clazz = Utils.getClassLoader().loadClass(className);
                            if (!ClusterSerializable.class.isAssignableFrom(clazz)) {
                                throw new ClassCastException(new String(classNameBytes) + " is not assignable from ClusterSerializable");
                            }
                            ClusterSerializable obj2 = (ClusterSerializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            pos = obj2.readFromBuffer(pos, buffer);
                            val2 = obj2;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid serialized type: " + type2);
                        }
                    }
                    data2.put(key2, val2);
                }
                this.setData(data2);
            }
            return pos;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            throw new VertxException(e2);
        }
    }
}

