/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PRNG;
import io.vertx.ext.web.Session;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractSession
implements Session {
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private PRNG prng;
    private String id;
    private long timeout;
    private volatile Map<String, Object> data;
    private long lastAccessed;
    private int version;
    private boolean destroyed;
    private boolean renewed;
    private String oldId;
    private int crc;

    protected void setId(String id) {
        this.id = id;
    }

    protected void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected void setData(Map<String, Object> data2) {
        if (data2 != null) {
            this.data = data2;
            this.crc = this.checksum();
        }
    }

    protected void setData(JsonObject data2) {
        if (data2 != null) {
            this.setData(data2.getMap());
        }
    }

    protected void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public AbstractSession() {
    }

    public AbstractSession(PRNG random) {
        this.prng = random;
    }

    public AbstractSession(PRNG random, long timeout, int length) {
        this.prng = random;
        this.id = AbstractSession.generateId(this.prng, length);
        this.timeout = timeout;
        this.lastAccessed = System.currentTimeMillis();
    }

    public void setPRNG(PRNG prng) {
        this.prng = prng;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Session regenerateId() {
        if (this.oldId == null) {
            this.oldId = this.id;
        }
        this.id = AbstractSession.generateId(this.prng, this.oldId.length() / 2);
        this.renewed = true;
        return this;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public <T> T get(String key2) {
        if (this.isEmpty()) {
            return null;
        }
        Object obj2 = this.data().get(key2);
        return (T)obj2;
    }

    @Override
    public Session put(String key2, Object obj2) {
        Map<String, Object> data2 = this.data();
        if (obj2 == null) {
            data2.remove(key2);
        } else {
            data2.put(key2, obj2);
        }
        return this;
    }

    @Override
    public <T> T remove(String key2) {
        if (this.isEmpty()) {
            return null;
        }
        Object obj2 = this.data().remove(key2);
        return (T)obj2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> data() {
        if (this.data == null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.data == null) {
                    this.data = new ConcurrentHashMap<String, Object>();
                    if (this.destroyed) {
                        this.regenerateId();
                        this.destroyed = false;
                    }
                }
            }
        }
        return this.data;
    }

    @Override
    public boolean isEmpty() {
        return this.data == null || this.data.size() == 0;
    }

    @Override
    public long lastAccessed() {
        return this.lastAccessed;
    }

    @Override
    public void setAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.destroyed = true;
            this.data = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isRegenerated() {
        return this.renewed;
    }

    @Override
    public String oldId() {
        return this.oldId;
    }

    public int version() {
        return this.version;
    }

    public void incrementVersion() {
        int old = this.crc;
        this.crc = this.checksum();
        if (this.crc != old) {
            ++this.version;
        }
    }

    private static String generateId(PRNG rng, int length) {
        byte[] bytes2 = new byte[length];
        rng.nextBytes(bytes2);
        char[] hex = new char[length * 2];
        for (int j = 0; j < length; ++j) {
            int v = bytes2[j] & 0xFF;
            hex[j * 2] = HEX[v >>> 4];
            hex[j * 2 + 1] = HEX[v & 0xF];
        }
        return new String(hex);
    }

    protected int crc() {
        return this.crc;
    }

    protected int checksum() {
        if (this.isEmpty()) {
            return 0;
        }
        int result2 = 1;
        for (Map.Entry<String, Object> kv : this.data.entrySet()) {
            String key2 = kv.getKey();
            result2 = 31 * result2 + key2.hashCode();
            Object value = kv.getValue();
            if (value == null) continue;
            result2 = 31 * result2 + value.hashCode();
        }
        return result2;
    }
}

