/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class Utils
extends io.vertx.core.impl.Utils {
    private static final ZoneId ZONE_GMT = ZoneId.of("GMT");

    public static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? Utils.class.getClassLoader() : tccl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Buffer readResourceToBuffer(String resource2) {
        ClassLoader cl = Utils.getClassLoader();
        try {
            Buffer buffer = Buffer.buffer();
            try (InputStream in = cl.getResourceAsStream(resource2);){
                int read2;
                if (in == null) {
                    Buffer buffer2 = null;
                    return buffer2;
                }
                byte[] data2 = new byte[4096];
                while ((read2 = in.read(data2, 0, data2.length)) != -1) {
                    if (read2 == data2.length) {
                        buffer.appendBytes(data2);
                        continue;
                    }
                    byte[] slice = new byte[read2];
                    System.arraycopy(data2, 0, slice, 0, slice.length);
                    buffer.appendBytes(slice);
                }
                return buffer;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String readFileToString(Vertx vertx, String resource2) {
        return Utils.readFileToString(vertx, resource2, StandardCharsets.UTF_8);
    }

    public static String readFileToString(Vertx vertx, String resource2, Charset charset) {
        try {
            Buffer buff = vertx.fileSystem().readFileBlocking(resource2);
            return buff.toString(charset);
        }
        catch (Exception e2) {
            throw new VertxException(e2);
        }
    }

    public static String formatRFC1123DateTime(long time2) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.ofEpochMilli(time2).atZone(ZONE_GMT));
    }

    public static long parseRFC1123DateTime(String header) {
        try {
            return header == null || header.isEmpty() ? -1L : LocalDateTime.parse(header, DateTimeFormatter.RFC_1123_DATE_TIME).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (DateTimeParseException ex) {
            return -1L;
        }
    }

    public static String pathOffset(String path2, RoutingContext context) {
        String routePath;
        int prefixLen = 0;
        String mountPoint = context.mountPoint();
        if (mountPoint != null) {
            prefixLen = mountPoint.length();
            if (mountPoint.charAt(mountPoint.length() - 1) == '/') {
                --prefixLen;
            }
        }
        if ((routePath = context.currentRoute().getPath()) != null) {
            prefixLen += routePath.length();
            if (routePath.charAt(routePath.length() - 1) == '/') {
                --prefixLen;
            }
        }
        return prefixLen != 0 ? path2.substring(prefixLen) : path2;
    }

    public static long secondsFactor(long millis2) {
        return millis2 - millis2 % 1000L;
    }

    public static JsonNode toJsonNode(String object) {
        try {
            return new ObjectMapper().readTree(object);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static JsonNode toJsonNode(JsonObject object) {
        try {
            return new ObjectMapper().readTree(object.encode());
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static JsonObject toJsonObject(JsonNode node2) {
        return new JsonObject(node2.toString());
    }

    public static JsonArray toJsonArray(JsonNode node2) {
        return new JsonArray(node2.toString());
    }

    public static Object toVertxJson(JsonNode node2) {
        if (node2.isArray()) {
            return Utils.toJsonArray(node2);
        }
        if (node2.isObject()) {
            return Utils.toJsonObject(node2);
        }
        return node2.toString();
    }

    public static boolean isJsonContentType(String contentType) {
        return contentType.contains("application/json") || contentType.contains("+json");
    }

    public static boolean isXMLContentType(String contentType) {
        return contentType.contains("application/xml") || contentType.contains("text/xml") || contentType.contains("+xml");
    }

    public static void addToMapIfAbsent(MultiMap map2, String key2, String value) {
        if (!map2.contains(key2)) {
            map2.set(key2, value);
        }
    }
}

