/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.RouteState;
import io.vertx.ext.web.impl.RouterImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RouteImpl
implements Route {
    private final RouterImpl router;
    private volatile RouteState state;
    private static final Pattern RE_OPERATORS_NO_STAR = Pattern.compile("([\\(\\)\\$\\+\\.])");
    private static final Pattern RE_TOKEN_SEARCH = Pattern.compile(":([A-Za-z][A-Za-z0-9_]*)");

    RouteImpl(RouterImpl router2, int order) {
        this.router = router2;
        this.state = new RouteState(this, order);
    }

    RouteImpl(RouterImpl router2, int order, String path2) {
        this(router2, order);
        this.checkPath(path2);
        this.setPath(path2);
    }

    RouteImpl(RouterImpl router2, int order, HttpMethod method, String path2) {
        this(router2, order);
        this.method(method);
        this.checkPath(path2);
        this.setPath(path2);
    }

    RouteImpl(RouterImpl router2, int order, String regex, boolean bregex) {
        this(router2, order);
        this.setRegex(regex);
    }

    RouteImpl(RouterImpl router2, int order, HttpMethod method, String regex, boolean bregex) {
        this(router2, order);
        this.method(method);
        this.setRegex(regex);
    }

    RouteState state() {
        return this.state;
    }

    @Override
    public synchronized Route method(HttpMethod method) {
        this.state = this.state.addMethod(method);
        return this;
    }

    @Override
    public Route path(String path2) {
        this.checkPath(path2);
        this.setPath(path2);
        return this;
    }

    @Override
    public Route pathRegex(String regex) {
        this.setRegex(regex);
        return this;
    }

    @Override
    public synchronized Route produces(String contentType) {
        this.state = this.state.addProduce(new ParsableMIMEValue(contentType).forceParse());
        return this;
    }

    @Override
    public synchronized Route consumes(String contentType) {
        this.state = this.state.addConsume(new ParsableMIMEValue(contentType).forceParse());
        return this;
    }

    @Override
    public synchronized Route order(int order) {
        if (this.state.isAdded()) {
            throw new IllegalStateException("Can't change order after route is active");
        }
        this.state = this.state.setOrder(order);
        return this;
    }

    @Override
    public Route last() {
        return this.order(Integer.MAX_VALUE);
    }

    @Override
    public synchronized Route handler(Handler<RoutingContext> contextHandler) {
        if (this.state.isExclusive()) {
            throw new IllegalStateException("This Route is exclusive for already mounted sub router.");
        }
        this.state = this.state.addContextHandler(contextHandler);
        this.checkAdd();
        return this;
    }

    @Override
    public Route blockingHandler(Handler<RoutingContext> contextHandler) {
        return this.blockingHandler(contextHandler, true);
    }

    @Override
    public synchronized Route subRouter(Router subRouter) {
        if (this.state.isExactPath()) {
            throw new IllegalStateException("Sub router cannot be mounted on an exact path.");
        }
        if (this.state.getPath() == null && this.state.getPattern() != null) {
            throw new IllegalStateException("Sub router cannot be mounted on a regular expression path.");
        }
        if (this.state.getContextHandlersLength() > 0 || this.state.getFailureHandlersLength() > 0) {
            throw new IllegalStateException("Only one sub router per Route object is allowed.");
        }
        this.handler(subRouter::handleContext);
        this.failureHandler(subRouter::handleFailure);
        subRouter.modifiedHandler(this::validateMount);
        this.validateMount(subRouter);
        this.state = this.state.setExclusive(true);
        return this;
    }

    @Override
    public Route blockingHandler(Handler<RoutingContext> contextHandler, boolean ordered) {
        return this.handler(new BlockingHandlerDecorator(contextHandler, ordered));
    }

    @Override
    public synchronized Route failureHandler(Handler<RoutingContext> exceptionHandler) {
        if (this.state.isExclusive()) {
            throw new IllegalStateException("This Route is exclusive for already mounted sub router.");
        }
        this.state = this.state.addFailureHandler(exceptionHandler);
        this.checkAdd();
        return this;
    }

    @Override
    public Route remove() {
        this.router.remove(this);
        return this;
    }

    @Override
    public synchronized Route disable() {
        this.state = this.state.setEnabled(false);
        return this;
    }

    @Override
    public synchronized Route enable() {
        this.state = this.state.setEnabled(true);
        return this;
    }

    @Override
    public synchronized Route useNormalisedPath(boolean useNormalisedPath) {
        this.state = this.state.setUseNormalisedPath(useNormalisedPath);
        return this;
    }

    @Override
    public String getPath() {
        return this.state.getPath();
    }

    @Override
    public boolean isRegexPath() {
        return this.state.getPattern() != null;
    }

    @Override
    public Set<HttpMethod> methods() {
        return this.state.getMethods();
    }

    @Override
    public synchronized Route setRegexGroupsNames(List<String> groups2) {
        this.state = this.state.setGroups(groups2);
        return this;
    }

    public String toString() {
        return "RouteImpl@" + System.identityHashCode(this) + "{state=" + this.state + '}';
    }

    RouterImpl router() {
        return this.router;
    }

    private synchronized void setPath(String path2) {
        if (path2.charAt(path2.length() - 1) != '*') {
            this.state = this.state.setExactPath(true);
            this.state = this.state.setPath(path2);
        } else {
            this.state = this.state.setExactPath(false);
            this.state = this.state.setPath(path2.substring(0, path2.length() - 1));
        }
        if (path2.indexOf(58) != -1) {
            this.createPatternRegex(path2);
        }
        this.state = this.state.setPathEndsWithSlash(this.state.getPath().endsWith("/"));
    }

    private synchronized void setRegex(String regex) {
        this.state = this.state.setPattern(Pattern.compile(regex));
        this.state = this.state.setExactPath(true);
        this.findNamedGroups(this.state.getPattern().pattern());
    }

    private synchronized void findNamedGroups(String path2) {
        Matcher m3 = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>").matcher(path2);
        while (m3.find()) {
            this.state = this.state.addNamedGroupInRegex(m3.group(1));
        }
    }

    private synchronized void createPatternRegex(String path2) {
        if ((path2 = RE_OPERATORS_NO_STAR.matcher(path2).replaceAll("\\\\$1")).charAt(path2.length() - 1) == '*') {
            path2 = path2.substring(0, path2.length() - 1) + "(?<rest>.*)";
            this.state = this.state.setExactPath(false);
        } else {
            this.state = this.state.setExactPath(true);
        }
        Matcher m3 = RE_TOKEN_SEARCH.matcher(path2);
        StringBuffer sb = new StringBuffer();
        ArrayList<String> groups2 = new ArrayList<String>();
        int index2 = 0;
        while (m3.find()) {
            String param = "p" + index2;
            String group = m3.group().substring(1);
            if (groups2.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m3.appendReplacement(sb, "(?<" + param + ">[^/]+)");
            groups2.add(group);
            ++index2;
        }
        m3.appendTail(sb);
        path2 = sb.toString();
        this.state = this.state.setGroups(groups2);
        this.state = this.state.setPattern(Pattern.compile(path2));
    }

    private void checkPath(String path2) {
        if ("".equals(path2) || path2.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with /");
        }
    }

    int order() {
        return this.state.getOrder();
    }

    private synchronized void checkAdd() {
        if (!this.state.isAdded()) {
            this.router.add(this);
            this.state = this.state.setAdded(true);
        }
    }

    public synchronized RouteImpl setEmptyBodyPermittedWithConsumes(boolean emptyBodyPermittedWithConsumes) {
        this.state = this.state.setEmptyBodyPermittedWithConsumes(emptyBodyPermittedWithConsumes);
        return this;
    }

    private void validateMount(Router router2) {
        for (Route route : router2.getRoutes()) {
            if (route.getPath() == null) continue;
            String combinedPath = RE_OPERATORS_NO_STAR.matcher(this.state.getPath() + (this.state.isPathEndsWithSlash() ? route.getPath().substring(1) : route.getPath())).replaceAll("\\\\$1");
            Matcher m3 = RE_TOKEN_SEARCH.matcher(combinedPath);
            HashSet<String> groups2 = new HashSet<String>();
            while (m3.find()) {
                String group = m3.group();
                if (groups2.contains(group)) {
                    throw new IllegalStateException("Cannot use identifier " + group + " more than once in pattern string");
                }
                groups2.add(group);
            }
        }
    }
}

