/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import java.io.IOException;

public class JsonCodec {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String encode(Object obj2) throws EncodeException {
        try {
            return mapper.writeValueAsString(obj2);
        }
        catch (Exception e2) {
            throw new EncodeException("Failed to encode as JSON");
        }
    }

    public static <T> T decodeValue(String str2, Class<T> clazz) throws DecodeException {
        try {
            return mapper.readValue(str2, clazz);
        }
        catch (Exception e2) {
            throw new DecodeException("Failed to decode");
        }
    }

    static {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(String.class, new JsonSerializer<String>(){
            final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
            final int[] ESCAPE_CODES = CharTypes.get7BitOutputEscapes();

            private void writeUnicodeEscape(JsonGenerator gen, char c) throws IOException {
                gen.writeRaw('\\');
                gen.writeRaw('u');
                gen.writeRaw(this.HEX_CHARS[c >> 12 & 0xF]);
                gen.writeRaw(this.HEX_CHARS[c >> 8 & 0xF]);
                gen.writeRaw(this.HEX_CHARS[c >> 4 & 0xF]);
                gen.writeRaw(this.HEX_CHARS[c & 0xF]);
            }

            private void writeShortEscape(JsonGenerator gen, char c) throws IOException {
                gen.writeRaw('\\');
                gen.writeRaw(c);
            }

            @Override
            public void serialize(String str2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
                int status = ((JsonWriteContext)gen.getOutputContext()).writeValue();
                switch (status) {
                    case 2: {
                        gen.writeRaw(':');
                        break;
                    }
                    case 1: {
                        gen.writeRaw(',');
                        break;
                    }
                    case 5: {
                        throw new JsonGenerationException("Can not write string value here", gen);
                    }
                }
                gen.writeRaw('\"');
                for (char c : str2.toCharArray()) {
                    int code;
                    if (c >= '\u0080') {
                        this.writeUnicodeEscape(gen, c);
                        continue;
                    }
                    int n = code = c < this.ESCAPE_CODES.length ? this.ESCAPE_CODES[c] : 0;
                    if (code == 0) {
                        gen.writeRaw(c);
                        continue;
                    }
                    if (code == -1) {
                        this.writeUnicodeEscape(gen, c);
                        continue;
                    }
                    this.writeShortEscape(gen, (char)code);
                }
                gen.writeRaw('\"');
            }
        });
        mapper.registerModule(simpleModule);
    }
}

