/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.VirtualHostHandler;
import java.util.regex.Pattern;

public class VirtualHostHandlerImpl
implements VirtualHostHandler {
    private final Pattern regex;
    private final Handler<RoutingContext> handler;

    public VirtualHostHandlerImpl(String hostname, Handler<RoutingContext> handler) {
        this.handler = handler;
        this.regex = Pattern.compile("^" + hostname.replaceAll("\\.", "\\\\.").replaceAll("[*]", "(.*?)") + "$", 2);
    }

    @Override
    public void handle(RoutingContext ctx) {
        String host = ctx.request().host();
        if (host == null) {
            ctx.next();
        } else {
            boolean match2 = false;
            for (String h2 : host.split(":")) {
                if (!this.regex.matcher(h2).matches()) continue;
                match2 = true;
                break;
            }
            if (match2) {
                this.handler.handle(ctx);
            } else {
                ctx.next();
            }
        }
    }
}

