/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;

public class UserHolder
implements ClusterSerializable {
    private RoutingContext context;
    private User user;

    public UserHolder() {
    }

    public UserHolder(RoutingContext context) {
        this.context = context;
    }

    public synchronized void refresh(RoutingContext context) {
        if (this.context != null) {
            this.user = this.context.user();
        }
        this.context = context;
        if (this.user != null) {
            this.context.setUser(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToBuffer(Buffer buffer) {
        User user;
        UserHolder userHolder = this;
        synchronized (userHolder) {
            user = this.context != null ? this.context.user() : this.user;
            this.context = null;
        }
        if (user instanceof ClusterSerializable) {
            buffer.appendByte((byte)1);
            String className = user.getClass().getName();
            if (className == null) {
                throw new IllegalStateException("Cannot serialize " + user.getClass().getName());
            }
            byte[] bytes2 = className.getBytes(StandardCharsets.UTF_8);
            buffer.appendInt(bytes2.length);
            buffer.appendBytes(bytes2);
            ClusterSerializable cs = (ClusterSerializable)((Object)user);
            cs.writeToBuffer(buffer);
        } else {
            buffer.appendByte((byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        block10: {
            byte b;
            if ((b = buffer.getByte(pos++)) == 1) {
                int len = buffer.getInt(pos);
                byte[] bytes2 = buffer.getBytes(pos += 4, pos + len);
                pos += len;
                String className = new String(bytes2, StandardCharsets.UTF_8);
                try {
                    Class<?> clazz = Utils.getClassLoader().loadClass(className);
                    if (!ClusterSerializable.class.isAssignableFrom(clazz)) {
                        throw new ClassCastException(className + " is not ClusterSerializable");
                    }
                    ClusterSerializable obj2 = (ClusterSerializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    pos = obj2.readFromBuffer(pos, buffer);
                    UserHolder userHolder = this;
                    synchronized (userHolder) {
                        this.user = (User)((Object)obj2);
                        this.context = null;
                        break block10;
                    }
                }
                catch (Exception e2) {
                    throw new VertxException(e2);
                }
            }
            UserHolder userHolder = this;
            synchronized (userHolder) {
                this.user = null;
                this.context = null;
            }
        }
        return pos;
    }
}

