/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.json.JsonArray;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.ext.web.Http2PushMapping;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.impl.LRUCache;
import io.vertx.ext.web.impl.Utils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticHandlerImpl
implements StaticHandler {
    private static final Logger log = LoggerFactory.getLogger(StaticHandlerImpl.class);
    private String webRoot = "webroot";
    private long maxAgeSeconds = 86400L;
    private boolean directoryListing = false;
    private String directoryTemplateResource = "META-INF/vertx/web/vertx-web-directory.html";
    private String directoryTemplate;
    private boolean includeHidden = true;
    private boolean filesReadOnly = true;
    private String indexPage = "/index.html";
    private List<Http2PushMapping> http2PushMappings;
    private boolean rangeSupport = true;
    private boolean allowRootFileSystemAccess = false;
    private boolean sendVaryHeader = true;
    private String defaultContentEncoding = Charset.defaultCharset().name();
    private Set<String> compressedMediaTypes = Collections.emptySet();
    private Set<String> compressedFileSuffixes = Collections.emptySet();
    private final ClassLoader classLoader;
    private final FSTune tune = new FSTune();
    private final FSPropsCache cache = new FSPropsCache();
    private static final Pattern RANGE = Pattern.compile("^bytes=(\\d+)-(\\d*)$");

    @Deprecated
    public StaticHandlerImpl(String root2, ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (root2 != null) {
            this.setRoot(root2);
        }
    }

    public StaticHandlerImpl(String root2) {
        this.classLoader = null;
        if (root2 != null) {
            this.setRoot(root2);
        }
    }

    private String directoryTemplate(Vertx vertx) {
        if (this.directoryTemplate == null) {
            this.directoryTemplate = Utils.readFileToString(vertx, this.directoryTemplateResource);
        }
        return this.directoryTemplate;
    }

    private void writeCacheHeaders(HttpServerRequest request, FileProps props) {
        MultiMap headers = request.response().headers();
        if (this.cache.enabled()) {
            Utils.addToMapIfAbsent(headers, "cache-control", "public, max-age=" + this.maxAgeSeconds);
            Utils.addToMapIfAbsent(headers, "last-modified", Utils.formatRFC1123DateTime(props.lastModifiedTime()));
            if (this.sendVaryHeader && request.headers().contains("accept-encoding")) {
                Utils.addToMapIfAbsent(headers, "vary", "accept-encoding");
            }
        }
        headers.set("date", Utils.formatRFC1123DateTime(System.currentTimeMillis()));
    }

    @Override
    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.method() != HttpMethod.GET && request.method() != HttpMethod.HEAD) {
            if (log.isTraceEnabled()) {
                log.trace("Not GET or HEAD so ignoring request");
            }
            context.next();
        } else {
            String uriDecodedPath = URIDecoder.decodeURIComponent(context.normalisedPath(), false);
            if (uriDecodedPath == null) {
                log.warn("Invalid path: " + context.request().path());
                context.next();
                return;
            }
            String path2 = HttpUtils.removeDots(uriDecodedPath.replace('\\', '/'));
            if (!this.directoryListing && "/".equals(path2)) {
                path2 = this.indexPage;
            }
            this.sendStatic(context, path2);
        }
    }

    private void sendStatic(RoutingContext context, String path2) {
        int idx;
        String name2;
        String file2 = null;
        if (!this.includeHidden && (name2 = (file2 = this.getFile(path2, context)).substring((idx = file2.lastIndexOf(47)) + 1)).length() > 0 && name2.charAt(0) == '.') {
            context.next();
            return;
        }
        CacheEntry entry = this.cache.get(path2);
        if (entry != null && (this.filesReadOnly || !entry.isOutOfDate())) {
            if (entry.isMissing()) {
                context.next();
                return;
            }
            if (entry.shouldUseCached(context.request())) {
                context.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                return;
            }
        }
        boolean dirty = this.cache.enabled() && entry != null;
        String sfile = file2 == null ? this.getFile(path2, context) : file2;
        this.isFileExisting(context, sfile, exists -> {
            if (exists.failed()) {
                context.fail(exists.cause());
                return;
            }
            if (!((Boolean)exists.result()).booleanValue()) {
                if (this.cache.enabled()) {
                    this.cache.put(path2, null);
                }
                context.next();
                return;
            }
            this.getFileProps(context, sfile, res -> {
                if (res.succeeded()) {
                    FileProps fprops = (FileProps)res.result();
                    if (fprops == null) {
                        if (dirty) {
                            this.cache.remove(path2);
                        }
                        context.next();
                    } else if (fprops.isDirectory()) {
                        if (dirty) {
                            this.cache.remove(path2);
                        }
                        this.sendDirectory(context, path2, sfile);
                    } else {
                        CacheEntry now2;
                        if (this.cache.enabled() && (now2 = this.cache.put(path2, fprops)).shouldUseCached(context.request())) {
                            context.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                            return;
                        }
                        this.sendFile(context, sfile, fprops);
                    }
                } else {
                    context.fail(res.cause());
                }
            });
        });
    }

    private void sendDirectory(RoutingContext context, String path2, String file2) {
        if (!path2.endsWith("/")) {
            context.response().putHeader(HttpHeaders.LOCATION, (CharSequence)(path2 + "/")).setStatusCode(301).end();
            return;
        }
        if (this.directoryListing) {
            this.sendDirectoryListing(file2, context);
        } else if (this.indexPage != null) {
            String indexPath = path2.endsWith("/") && this.indexPage.startsWith("/") ? path2 + this.indexPage.substring(1) : (!path2.endsWith("/") && !this.indexPage.startsWith("/") ? path2 + "/" + this.indexPage.substring(1) : path2 + this.indexPage);
            this.sendStatic(context, indexPath);
        } else {
            context.fail(HttpResponseStatus.FORBIDDEN.code());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T wrapInTCCLSwitch(Callable<T> callable) {
        try {
            if (this.classLoader == null) {
                return callable.call();
            }
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                T t3 = callable.call();
                return t3;
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private void isFileExisting(RoutingContext context, String file2, Handler<AsyncResult<Boolean>> resultHandler) {
        FileSystem fs = context.vertx().fileSystem();
        this.wrapInTCCLSwitch(() -> fs.exists(file2, resultHandler));
    }

    private void getFileProps(RoutingContext context, String file2, Handler<AsyncResult<FileProps>> resultHandler) {
        FileSystem fs = context.vertx().fileSystem();
        if (this.tune.useAsyncFS()) {
            this.wrapInTCCLSwitch(() -> fs.props(file2, resultHandler));
        } else {
            try {
                boolean tuneEnabled = this.tune.enabled();
                long start2 = tuneEnabled ? System.nanoTime() : 0L;
                FileProps props = this.wrapInTCCLSwitch(() -> fs.propsBlocking(file2));
                if (tuneEnabled) {
                    this.tune.update(start2, System.nanoTime());
                }
                resultHandler.handle(Future.succeededFuture(props));
            }
            catch (RuntimeException e2) {
                resultHandler.handle(Future.failedFuture(e2.getCause()));
            }
        }
    }

    private void sendFile(RoutingContext context, String file2, FileProps fileProps) {
        HttpServerRequest request = context.request();
        Long offset = null;
        long end2 = 0L;
        MultiMap headers = null;
        if (this.rangeSupport) {
            Matcher m3;
            String range2 = request.getHeader("Range");
            end2 = fileProps.size() - 1L;
            if (range2 != null && (m3 = RANGE.matcher(range2)).matches()) {
                try {
                    String part = m3.group(1);
                    offset = Long.parseLong(part);
                    if (offset < 0L || offset >= fileProps.size()) {
                        throw new IndexOutOfBoundsException();
                    }
                    part = m3.group(2);
                    if (part != null && part.length() > 0 && (end2 = Math.min(end2, Long.parseLong(part))) < offset) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                catch (IndexOutOfBoundsException | NumberFormatException e2) {
                    context.response().putHeader("Content-Range", "bytes */" + fileProps.size());
                    context.fail(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE.code());
                    return;
                }
            }
            headers = request.response().headers();
            headers.set("Accept-Ranges", "bytes");
            headers.set("Content-Length", Long.toString(end2 + 1L - (offset == null ? 0L : offset)));
        }
        this.writeCacheHeaders(request, fileProps);
        if (request.method() == HttpMethod.HEAD) {
            request.response().end();
        } else if (this.rangeSupport && offset != null) {
            headers.set("Content-Range", "bytes " + offset + "-" + end2 + "/" + fileProps.size());
            request.response().setStatusCode(HttpResponseStatus.PARTIAL_CONTENT.code());
            long finalOffset = offset;
            long finalLength = end2 + 1L - offset;
            this.wrapInTCCLSwitch(() -> {
                String contentType = MimeMapping.getMimeTypeForFilename(file2);
                if (contentType != null) {
                    if (contentType.startsWith("text")) {
                        request.response().putHeader("Content-Type", contentType + ";charset=" + this.defaultContentEncoding);
                    } else {
                        request.response().putHeader("Content-Type", contentType);
                    }
                }
                return request.response().sendFile(file2, finalOffset, finalLength, res2 -> {
                    if (res2.failed()) {
                        context.fail(res2.cause());
                    }
                });
            });
        } else {
            this.wrapInTCCLSwitch(() -> {
                String extension = this.getFileExtension(file2);
                String contentType = MimeMapping.getMimeTypeForExtension(extension);
                if (this.compressedMediaTypes.contains(contentType) || this.compressedFileSuffixes.contains(extension)) {
                    request.response().putHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY);
                }
                if (contentType != null) {
                    if (contentType.startsWith("text")) {
                        request.response().putHeader("Content-Type", contentType + ";charset=" + this.defaultContentEncoding);
                    } else {
                        request.response().putHeader("Content-Type", contentType);
                    }
                }
                if (request.version() == HttpVersion.HTTP_2 && this.http2PushMappings != null) {
                    for (Http2PushMapping dependency : this.http2PushMappings) {
                        if (dependency.isNoPush()) continue;
                        String dep = this.webRoot + "/" + dependency.getFilePath();
                        HttpServerResponse response = request.response();
                        this.getFileProps(context, dep, filePropsAsyncResult -> {
                            if (filePropsAsyncResult.succeeded()) {
                                this.writeCacheHeaders(request, (FileProps)filePropsAsyncResult.result());
                                response.push(HttpMethod.GET, "/" + dependency.getFilePath(), pushAsyncResult -> {
                                    if (pushAsyncResult.succeeded()) {
                                        HttpServerResponse res = (HttpServerResponse)pushAsyncResult.result();
                                        String depContentType = MimeMapping.getMimeTypeForExtension(file2);
                                        if (depContentType != null) {
                                            if (depContentType.startsWith("text")) {
                                                res.putHeader("Content-Type", contentType + ";charset=" + this.defaultContentEncoding);
                                            } else {
                                                res.putHeader("Content-Type", contentType);
                                            }
                                        }
                                        res.sendFile(this.webRoot + "/" + dependency.getFilePath());
                                    }
                                });
                            }
                        });
                    }
                } else if (this.http2PushMappings != null) {
                    HttpServerResponse response = request.response();
                    ArrayList<String> links = new ArrayList<String>();
                    for (Http2PushMapping dependency : this.http2PushMappings) {
                        String dep = this.webRoot + "/" + dependency.getFilePath();
                        this.getFileProps(context, dep, filePropsAsyncResult -> {
                            if (filePropsAsyncResult.succeeded()) {
                                this.writeCacheHeaders(request, (FileProps)filePropsAsyncResult.result());
                                links.add("<" + dependency.getFilePath() + ">; rel=preload; as=" + dependency.getExtensionTarget() + (dependency.isNoPush() ? "; nopush" : ""));
                            }
                        });
                    }
                    response.putHeader("Link", links);
                }
                return request.response().sendFile(file2, res2 -> {
                    if (res2.failed()) {
                        context.fail(res2.cause());
                    }
                });
            });
        }
    }

    @Override
    public StaticHandler setAllowRootFileSystemAccess(boolean allowRootFileSystemAccess) {
        this.allowRootFileSystemAccess = allowRootFileSystemAccess;
        return this;
    }

    @Override
    public StaticHandler setWebRoot(String webRoot) {
        this.setRoot(webRoot);
        return this;
    }

    @Override
    public StaticHandler setFilesReadOnly(boolean readOnly) {
        this.filesReadOnly = readOnly;
        return this;
    }

    @Override
    public StaticHandler setMaxAgeSeconds(long maxAgeSeconds) {
        if (maxAgeSeconds < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        this.maxAgeSeconds = maxAgeSeconds;
        return this;
    }

    @Override
    public StaticHandler setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    @Override
    public StaticHandler setCachingEnabled(boolean enabled) {
        this.cache.setEnabled(enabled);
        return this;
    }

    @Override
    public StaticHandler setDirectoryListing(boolean directoryListing) {
        this.directoryListing = directoryListing;
        return this;
    }

    @Override
    public StaticHandler setDirectoryTemplate(String directoryTemplate) {
        this.directoryTemplateResource = directoryTemplate;
        this.directoryTemplate = null;
        return this;
    }

    @Override
    public StaticHandler setEnableRangeSupport(boolean enableRangeSupport) {
        this.rangeSupport = enableRangeSupport;
        return this;
    }

    @Override
    public StaticHandler setIncludeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
        return this;
    }

    @Override
    public StaticHandler setCacheEntryTimeout(long timeout) {
        this.cache.setCacheEntryTimeout(timeout);
        return this;
    }

    @Override
    public StaticHandler setIndexPage(String indexPage) {
        Objects.requireNonNull(indexPage);
        if (!indexPage.startsWith("/")) {
            indexPage = "/" + indexPage;
        }
        this.indexPage = indexPage;
        return this;
    }

    @Override
    public StaticHandler setAlwaysAsyncFS(boolean alwaysAsyncFS) {
        this.tune.setAlwaysAsyncFS(alwaysAsyncFS);
        return this;
    }

    @Override
    public StaticHandler setHttp2PushMapping(List<Http2PushMapping> http2PushMap) {
        if (http2PushMap != null) {
            this.http2PushMappings = new ArrayList<Http2PushMapping>(http2PushMap);
        }
        return this;
    }

    @Override
    public StaticHandler skipCompressionForMediaTypes(Set<String> mediaTypes) {
        if (mediaTypes != null) {
            this.compressedMediaTypes = new HashSet<String>(mediaTypes);
        }
        return this;
    }

    @Override
    public StaticHandler skipCompressionForSuffixes(Set<String> fileSuffixes) {
        if (fileSuffixes != null) {
            this.compressedFileSuffixes = new HashSet<String>(fileSuffixes);
        }
        return this;
    }

    @Override
    public synchronized StaticHandler setEnableFSTuning(boolean enableFSTuning) {
        this.tune.setEnabled(enableFSTuning);
        return this;
    }

    @Override
    public StaticHandler setMaxAvgServeTimeNs(long maxAvgServeTimeNanoSeconds) {
        this.tune.maxAvgServeTimeNanoSeconds = maxAvgServeTimeNanoSeconds;
        return this;
    }

    @Override
    public StaticHandler setSendVaryHeader(boolean sendVaryHeader) {
        this.sendVaryHeader = sendVaryHeader;
        return this;
    }

    @Override
    public StaticHandler setDefaultContentEncoding(String contentEncoding) {
        this.defaultContentEncoding = contentEncoding;
        return this;
    }

    private String getFile(String path2, RoutingContext context) {
        String file2 = this.webRoot + Utils.pathOffset(path2, context);
        if (log.isTraceEnabled()) {
            log.trace("File to serve is " + file2);
        }
        return file2;
    }

    private void setRoot(String webRoot) {
        Objects.requireNonNull(webRoot);
        if (!this.allowRootFileSystemAccess) {
            for (File root2 : File.listRoots()) {
                if (!webRoot.startsWith(root2.getAbsolutePath())) continue;
                throw new IllegalArgumentException("root cannot start with '" + root2.getAbsolutePath() + "'");
            }
        }
        this.webRoot = webRoot;
    }

    private void sendDirectoryListing(String dir2, RoutingContext context) {
        FileSystem fileSystem = context.vertx().fileSystem();
        HttpServerRequest request = context.request();
        fileSystem.readDir(dir2, asyncResult -> {
            if (asyncResult.failed()) {
                context.fail(asyncResult.cause());
            } else {
                String accept = request.headers().get("accept");
                if (accept == null) {
                    accept = "text/plain";
                }
                if (accept.contains("html")) {
                    String normalizedDir = context.normalisedPath();
                    if (!normalizedDir.endsWith("/")) {
                        normalizedDir = normalizedDir + "/";
                    }
                    StringBuilder files = new StringBuilder("<ul id=\"files\">");
                    List list = (List)asyncResult.result();
                    Collections.sort(list);
                    for (String s2 : list) {
                        String file2 = s2.substring(s2.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file2.charAt(0) == '.') continue;
                        files.append("<li><a href=\"");
                        files.append(normalizedDir);
                        files.append(file2);
                        files.append("\" title=\"");
                        files.append(file2);
                        files.append("\">");
                        files.append(file2);
                        files.append("</a></li>");
                    }
                    files.append("</ul>");
                    int slashPos = 0;
                    for (int i = normalizedDir.length() - 2; i > 0; --i) {
                        if (normalizedDir.charAt(i) != '/') continue;
                        slashPos = i;
                        break;
                    }
                    String parent = "<a href=\"" + normalizedDir.substring(0, slashPos + 1) + "\">..</a>";
                    request.response().putHeader("content-type", "text/html");
                    request.response().end(this.directoryTemplate(context.vertx()).replace("{directory}", normalizedDir).replace("{parent}", parent).replace("{files}", files.toString()));
                } else if (accept.contains("json")) {
                    JsonArray json = new JsonArray();
                    for (String s3 : (List)asyncResult.result()) {
                        String file3 = s3.substring(s3.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file3.charAt(0) == '.') continue;
                        json.add(file3);
                    }
                    request.response().putHeader("content-type", "application/json");
                    request.response().end(json.encode());
                } else {
                    StringBuilder buffer = new StringBuilder();
                    for (String s4 : (List)asyncResult.result()) {
                        String file4 = s4.substring(s4.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file4.charAt(0) == '.') continue;
                        buffer.append(file4);
                        buffer.append('\n');
                    }
                    request.response().putHeader("content-type", "text/plain");
                    request.response().end(buffer.toString());
                }
            }
        });
    }

    private String getFileExtension(String file2) {
        int li = file2.lastIndexOf(46);
        if (li != -1 && li != file2.length() - 1) {
            return file2.substring(li + 1);
        }
        return null;
    }

    private class FSPropsCache {
        private Map<String, CacheEntry> propsCache;
        private long cacheEntryTimeout = 30000L;
        private int maxCacheSize = 10000;

        FSPropsCache() {
            this.setEnabled(StaticHandler.DEFAULT_CACHING_ENABLED);
        }

        boolean enabled() {
            return this.propsCache != null;
        }

        synchronized void setMaxSize(int maxCacheSize) {
            if (maxCacheSize < 1) {
                throw new IllegalArgumentException("maxCacheSize must be >= 1");
            }
            if (this.maxCacheSize != maxCacheSize) {
                this.maxCacheSize = maxCacheSize;
                this.setEnabled(this.enabled(), true);
            }
        }

        void setEnabled(boolean enable) {
            this.setEnabled(enable, false);
        }

        private synchronized void setEnabled(boolean enable, boolean force2) {
            if (force2 || enable != this.enabled()) {
                if (this.propsCache != null) {
                    this.propsCache.clear();
                }
                this.propsCache = enable ? new LRUCache<String, CacheEntry>(this.maxCacheSize) : null;
            }
        }

        void setCacheEntryTimeout(long timeout) {
            if (timeout < 1L) {
                throw new IllegalArgumentException("timeout must be >= 1");
            }
            this.cacheEntryTimeout = timeout;
        }

        private void remove(String path2) {
            if (this.propsCache != null) {
                this.propsCache.remove(path2);
            }
        }

        CacheEntry get(String key2) {
            if (this.propsCache != null) {
                return this.propsCache.get(key2);
            }
            return null;
        }

        CacheEntry put(String path2, FileProps props) {
            if (this.propsCache != null) {
                CacheEntry now2 = new CacheEntry(props, this.cacheEntryTimeout);
                this.propsCache.put(path2, now2);
                return now2;
            }
            return null;
        }
    }

    private static class FSTune {
        private static final int NUM_SERVES_TUNING_FS_ACCESS = 1000;
        private volatile boolean enabled = true;
        private volatile boolean useAsyncFS;
        private long totalTime;
        private long numServesBlocking;
        private long nextAvgCheck = 1000L;
        private long maxAvgServeTimeNanoSeconds = 1000000L;
        private boolean alwaysAsyncFS = false;

        private FSTune() {
        }

        boolean enabled() {
            return this.enabled;
        }

        boolean useAsyncFS() {
            return this.alwaysAsyncFS || this.useAsyncFS;
        }

        synchronized void setEnabled(boolean enabled) {
            this.enabled = enabled;
            if (!enabled) {
                this.reset();
            }
        }

        void setAlwaysAsyncFS(boolean alwaysAsyncFS) {
            this.alwaysAsyncFS = alwaysAsyncFS;
        }

        synchronized void update(long start2, long end2) {
            long dur = end2 - start2;
            this.totalTime += dur;
            ++this.numServesBlocking;
            if (this.numServesBlocking == Long.MAX_VALUE) {
                this.reset();
            } else if (this.numServesBlocking == this.nextAvgCheck) {
                double avg = (double)this.totalTime / (double)this.numServesBlocking;
                if (avg > (double)this.maxAvgServeTimeNanoSeconds) {
                    this.useAsyncFS = true;
                    log.info("Switching to async file system access in static file server as fs access is slow! (Average access time of " + avg + " ns)");
                    this.enabled = false;
                }
                this.nextAvgCheck += 1000L;
            }
        }

        synchronized void reset() {
            this.nextAvgCheck = 1000L;
            this.totalTime = 0L;
            this.numServesBlocking = 0L;
        }
    }

    private final class CacheEntry {
        final long createDate = System.currentTimeMillis();
        final FileProps props;
        final long cacheEntryTimeout;

        private CacheEntry(FileProps props, long cacheEntryTimeout) {
            this.props = props;
            this.cacheEntryTimeout = cacheEntryTimeout;
        }

        boolean shouldUseCached(HttpServerRequest request) {
            String ifModifiedSince = request.headers().get("if-modified-since");
            if (ifModifiedSince == null) {
                return false;
            }
            long ifModifiedSinceDate = Utils.parseRFC1123DateTime(ifModifiedSince);
            boolean modifiedSince = Utils.secondsFactor(this.props.lastModifiedTime()) > ifModifiedSinceDate;
            return !modifiedSince;
        }

        boolean isOutOfDate() {
            return System.currentTimeMillis() - this.createDate > this.cacheEntryTimeout;
        }

        public boolean isMissing() {
            return this.props == null;
        }
    }
}

