/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.impl.UserHolder;
import io.vertx.ext.web.sstore.SessionStore;

public class SessionHandlerImpl
implements SessionHandler {
    private static final String SESSION_USER_HOLDER_KEY = "__vertx.userHolder";
    private static final String SESSION_FLUSHED_KEY = "__vertx.session-flushed";
    private static final String SESSION_STOREUSER_KEY = "__vertx.session-storeuser";
    private static final Logger log = LoggerFactory.getLogger(SessionHandlerImpl.class);
    private final SessionStore sessionStore;
    private String sessionCookieName;
    private String sessionCookiePath;
    private long sessionTimeout;
    private boolean nagHttps;
    private boolean sessionCookieSecure;
    private boolean sessionCookieHttpOnly;
    private int minLength;
    private CookieSameSite cookieSameSite;
    private boolean lazySession;

    public SessionHandlerImpl(String sessionCookieName, String sessionCookiePath, long sessionTimeout, boolean nagHttps, boolean sessionCookieSecure, boolean sessionCookieHttpOnly, int minLength, boolean lazySession, SessionStore sessionStore) {
        this.sessionCookieName = sessionCookieName;
        this.sessionCookiePath = sessionCookiePath;
        this.sessionTimeout = sessionTimeout;
        this.nagHttps = nagHttps;
        this.sessionStore = sessionStore;
        this.sessionCookieSecure = sessionCookieSecure;
        this.sessionCookieHttpOnly = sessionCookieHttpOnly;
        this.minLength = minLength;
        this.lazySession = lazySession;
    }

    @Override
    public SessionHandler setSessionTimeout(long timeout) {
        this.sessionTimeout = timeout;
        return this;
    }

    @Override
    public SessionHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    @Override
    public SessionHandler setCookieSecureFlag(boolean secure) {
        this.sessionCookieSecure = secure;
        return this;
    }

    @Override
    public SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) {
        this.sessionCookieHttpOnly = httpOnly;
        return this;
    }

    @Override
    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        return this;
    }

    @Override
    public SessionHandler setSessionCookiePath(String sessionCookiePath) {
        this.sessionCookiePath = sessionCookiePath;
        return this;
    }

    @Override
    public SessionHandler setMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    @Override
    public SessionHandler setCookieSameSite(CookieSameSite policy) {
        this.cookieSameSite = policy;
        return this;
    }

    @Override
    public SessionHandler setLazySession(boolean lazySession) {
        this.lazySession = lazySession;
        return this;
    }

    @Override
    @Deprecated
    public SessionHandler setAuthProvider(AuthProvider authProvider) {
        return this;
    }

    @Override
    public SessionHandler flush(RoutingContext context, Handler<AsyncResult<Void>> handler) {
        boolean sessionUsed = context.isSessionAccessed();
        Session session = context.session();
        if (!session.isDestroyed()) {
            int currentStatusCode = context.response().getStatusCode();
            if (currentStatusCode >= 200 && currentStatusCode < 400) {
                Boolean storeUser = (Boolean)context.get(SESSION_STOREUSER_KEY);
                if (storeUser != null && storeUser.booleanValue() && context.user() != null) {
                    session.put(SESSION_USER_HOLDER_KEY, new UserHolder(context));
                }
                if (session.isRegenerated()) {
                    io.vertx.core.http.Cookie cookie = this.sessionCookie(context, session);
                    session.setAccessed();
                    cookie.setValue(session.value()).setPath(this.sessionCookiePath).setSecure(this.sessionCookieSecure).setHttpOnly(this.sessionCookieHttpOnly);
                    this.sessionStore.delete(session.oldId(), delete -> {
                        if (delete.failed()) {
                            handler.handle(Future.failedFuture(delete.cause()));
                        } else {
                            this.sessionStore.put(session, put -> {
                                if (put.failed()) {
                                    handler.handle(Future.failedFuture(put.cause()));
                                } else {
                                    context.put(SESSION_FLUSHED_KEY, true);
                                    handler.handle(Future.succeededFuture());
                                }
                            });
                        }
                    });
                } else if (!this.lazySession || sessionUsed) {
                    this.sessionCookie(context, session);
                    session.setAccessed();
                    this.sessionStore.put(session, put -> {
                        if (put.failed()) {
                            handler.handle(Future.failedFuture(put.cause()));
                        } else {
                            context.put(SESSION_FLUSHED_KEY, true);
                            handler.handle(Future.succeededFuture());
                        }
                    });
                }
            }
        } else {
            context.removeCookie(this.sessionCookieName);
            if (session.isRegenerated()) {
                this.sessionStore.delete(session.oldId(), delete -> {
                    if (delete.failed()) {
                        handler.handle(Future.failedFuture(delete.cause()));
                    } else {
                        this.sessionStore.delete(session.id(), delete2 -> {
                            if (delete2.failed()) {
                                handler.handle(Future.failedFuture(delete2.cause()));
                            } else {
                                context.put(SESSION_FLUSHED_KEY, true);
                                handler.handle(Future.succeededFuture());
                            }
                        });
                    }
                });
            } else {
                this.sessionStore.delete(session.id(), delete -> {
                    if (delete.failed()) {
                        handler.handle(Future.failedFuture(delete.cause()));
                    } else {
                        context.put(SESSION_FLUSHED_KEY, true);
                        handler.handle(Future.succeededFuture());
                    }
                });
            }
        }
        return this;
    }

    @Override
    public void handle(RoutingContext context) {
        String sessionID;
        Cookie cookie;
        String uri;
        if (this.nagHttps && log.isDebugEnabled() && !(uri = context.request().absoluteURI()).startsWith("https:")) {
            log.debug("Using session cookies without https could make you susceptible to session hijacking: " + uri);
        }
        if ((cookie = context.getCookie(this.sessionCookieName)) != null && (sessionID = cookie.getValue()) != null && sessionID.length() > this.minLength) {
            this.getSession(context.vertx(), sessionID, res -> {
                if (res.succeeded()) {
                    Session session = (Session)res.result();
                    if (session != null) {
                        context.setSession(session);
                        UserHolder holder = (UserHolder)session.get(SESSION_USER_HOLDER_KEY);
                        if (holder != null) {
                            holder.refresh(context);
                        } else {
                            context.put(SESSION_STOREUSER_KEY, true);
                        }
                        this.addStoreSessionHandler(context);
                    } else {
                        this.createNewSession(context);
                    }
                } else {
                    context.fail(res.cause());
                }
                context.next();
            });
            return;
        }
        this.createNewSession(context);
        context.next();
    }

    private void getSession(Vertx vertx, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.doGetSession(vertx, System.currentTimeMillis(), sessionID, resultHandler);
    }

    private void doGetSession(Vertx vertx, long startTime, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.sessionStore.get(sessionID, res -> {
            long retryTimeout;
            if (res.succeeded() && res.result() == null && (retryTimeout = this.sessionStore.retryTimeout()) > 0L && System.currentTimeMillis() - startTime < retryTimeout) {
                vertx.setTimer(5L, v -> this.doGetSession(vertx, startTime, sessionID, resultHandler));
                return;
            }
            resultHandler.handle((AsyncResult<Session>)res);
        });
    }

    private void addStoreSessionHandler(RoutingContext context) {
        context.addHeadersEndHandler(v -> {
            Boolean flushed = (Boolean)context.get(SESSION_FLUSHED_KEY);
            if (flushed == null || !flushed.booleanValue()) {
                this.flush(context, flush2 -> {
                    if (flush2.failed()) {
                        log.warn((Object)"Failed to flush the session to the underlying store", flush2.cause());
                    }
                });
            }
        });
    }

    private void createNewSession(RoutingContext context) {
        Session session = this.sessionStore.createSession(this.sessionTimeout, this.minLength);
        context.setSession(session);
        context.removeCookie(this.sessionCookieName, false);
        context.put(SESSION_STOREUSER_KEY, true);
        this.addStoreSessionHandler(context);
    }

    private io.vertx.core.http.Cookie sessionCookie(RoutingContext context, Session session) {
        io.vertx.core.http.Cookie cookie = context.getCookie(this.sessionCookieName);
        if (cookie != null) {
            return cookie;
        }
        cookie = io.vertx.core.http.Cookie.cookie(this.sessionCookieName, session.value());
        cookie.setPath(this.sessionCookiePath);
        cookie.setSecure(this.sessionCookieSecure);
        cookie.setHttpOnly(this.sessionCookieHttpOnly);
        cookie.setSameSite(this.cookieSameSite);
        context.addCookie(cookie);
        return cookie;
    }
}

