/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.impl.Utils;
import java.util.List;
import java.util.Objects;

public class ErrorHandlerImpl
implements ErrorHandler {
    private final boolean displayExceptionDetails;
    private final String errorTemplate;

    public ErrorHandlerImpl(String errorTemplateName, boolean displayExceptionDetails) {
        Objects.requireNonNull(errorTemplateName);
        this.displayExceptionDetails = displayExceptionDetails;
        this.errorTemplate = Utils.readResourceToBuffer(errorTemplateName).toString();
    }

    @Override
    public void handle(RoutingContext context) {
        HttpServerResponse response = context.response();
        Throwable failure = context.failure();
        int errorCode = context.statusCode();
        if (errorCode == -1) {
            errorCode = 500;
        }
        response.setStatusCode(errorCode);
        String errorMessage2 = response.getStatusMessage();
        if (this.displayExceptionDetails && (errorMessage2 = failure.getMessage()) != null) {
            errorMessage2 = errorMessage2.replaceAll("\\r|\\n", " ");
            response.setStatusMessage(errorMessage2);
        }
        this.answerWithError(context, errorCode, errorMessage2);
    }

    private void answerWithError(RoutingContext context, int errorCode, String errorMessage2) {
        if (!this.sendErrorResponseMIME(context, errorCode, errorMessage2) && !this.sendErrorAcceptMIME(context, errorCode, errorMessage2)) {
            this.sendError(context, "text/plain", errorCode, errorMessage2);
        }
    }

    private boolean sendErrorResponseMIME(RoutingContext context, int errorCode, String errorMessage2) {
        String mime = context.response().headers().get(HttpHeaders.CONTENT_TYPE);
        if (mime == null) {
            mime = context.getAcceptableContentType();
        }
        return mime != null && this.sendError(context, mime, errorCode, errorMessage2);
    }

    private boolean sendErrorAcceptMIME(RoutingContext context, int errorCode, String errorMessage2) {
        List<MIMEHeader> acceptableMimes = context.parsedHeaders().accept();
        for (MIMEHeader accept : acceptableMimes) {
            if (!this.sendError(context, accept.value(), errorCode, errorMessage2)) continue;
            return true;
        }
        return false;
    }

    private boolean sendError(RoutingContext context, String mime, int errorCode, String errorMessage2) {
        String title = "An unexpected error occurred";
        HttpServerResponse response = context.response();
        if (mime.startsWith("text/html")) {
            StringBuilder stack = new StringBuilder();
            if (context.failure() != null && this.displayExceptionDetails) {
                for (StackTraceElement elem : context.failure().getStackTrace()) {
                    stack.append("<li>").append(elem).append("</li>");
                }
            }
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            response.end(this.errorTemplate.replace("{title}", "An unexpected error occurred").replace("{errorCode}", Integer.toString(errorCode)).replace("{errorMessage}", errorMessage2).replace("{stackTrace}", stack.toString()));
            return true;
        }
        if (mime.startsWith("application/json")) {
            JsonObject jsonError = new JsonObject();
            jsonError.put("error", new JsonObject().put("code", errorCode).put("message", errorMessage2));
            if (context.failure() != null && this.displayExceptionDetails) {
                JsonArray stack = new JsonArray();
                for (StackTraceElement elem : context.failure().getStackTrace()) {
                    stack.add(elem.toString());
                }
                jsonError.put("stack", stack);
            }
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            response.end(jsonError.encode());
            return true;
        }
        if (mime.startsWith("text/plain")) {
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
            StringBuilder sb = new StringBuilder();
            sb.append("Error ");
            sb.append(errorCode);
            sb.append(": ");
            sb.append(errorMessage2);
            if (context.failure() != null && this.displayExceptionDetails) {
                for (StackTraceElement elem : context.failure().getStackTrace()) {
                    sb.append("\tat ").append(elem).append("\n");
                }
            }
            response.end(sb.toString());
            return true;
        }
        return false;
    }
}

