/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.DigestAuthHandler;
import io.vertx.ext.web.handler.impl.AuthorizationAuthHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DigestAuthHandlerImpl
extends AuthorizationAuthHandler
implements DigestAuthHandler {
    private static final Pattern PARSER = Pattern.compile("(\\w+)=[\"]?([^\"]*)[\"]?$");
    private static final Pattern SPLITTER = Pattern.compile(",(?=(?:[^\"]|\"[^\"]*\")*$)");
    private static final MessageDigest MD5;
    private final SecureRandom random = new SecureRandom();
    private final Map<String, Nonce> nonces = new HashMap<String, Nonce>();
    private final long nonceExpireTimeout;
    private long lastExpireRun;
    private static final char[] hexArray;

    public DigestAuthHandlerImpl(HtdigestAuth authProvider, long nonceExpireTimeout) {
        super((AuthProvider)authProvider, authProvider.realm(), AuthorizationAuthHandler.Type.DIGEST);
        this.nonceExpireTimeout = nonceExpireTimeout;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        long now2 = System.currentTimeMillis();
        if (now2 - this.lastExpireRun > this.nonceExpireTimeout / 2L) {
            this.nonces.entrySet().removeIf(entry -> ((Nonce)entry.getValue()).createdAt + this.nonceExpireTimeout < now2);
            this.lastExpireRun = now2;
        }
        this.parseAuthorization(context, false, parseAuthorization -> {
            String opaque;
            if (parseAuthorization.failed()) {
                handler.handle(Future.failedFuture(parseAuthorization.cause()));
                return;
            }
            JsonObject authInfo = new JsonObject();
            try {
                String[] tokens = SPLITTER.split((CharSequence)parseAuthorization.result());
                int len = tokens.length;
                for (int i = 0; i < len; ++i) {
                    Matcher m3 = PARSER.matcher(tokens[i]);
                    if (!m3.find()) continue;
                    authInfo.put(m3.group(1), m3.group(2));
                }
                String nonce = authInfo.getString("nonce");
                if (!this.nonces.containsKey(nonce)) {
                    handler.handle(Future.failedFuture(UNAUTHORIZED));
                    return;
                }
                if (authInfo.containsKey("qop")) {
                    Nonce n;
                    int nc = Integer.parseInt(authInfo.getString("nc"));
                    if (nc <= (n = this.nonces.get(nonce)).count) {
                        handler.handle(Future.failedFuture(UNAUTHORIZED));
                        return;
                    }
                    n.count = nc;
                }
            }
            catch (RuntimeException e2) {
                handler.handle(Future.failedFuture(e2));
            }
            Session session = context.session();
            if (session != null && (opaque = (String)session.data().get("opaque")) != null && !opaque.equals(authInfo.getString("opaque"))) {
                handler.handle(Future.failedFuture(UNAUTHORIZED));
                return;
            }
            authInfo.put("method", context.request().method().name());
            handler.handle(Future.succeededFuture(authInfo));
        });
    }

    @Override
    protected String authenticateHeader(RoutingContext context) {
        byte[] bytes2 = new byte[32];
        this.random.nextBytes(bytes2);
        String nonce = DigestAuthHandlerImpl.md5(bytes2);
        this.nonces.put(nonce, new Nonce());
        String opaque = null;
        Session session = context.session();
        if (session != null) {
            opaque = (String)session.data().get("opaque");
        }
        if (opaque == null) {
            this.random.nextBytes(bytes2);
            opaque = DigestAuthHandlerImpl.md5(bytes2);
        }
        return "Digest realm=\"" + this.realm + "\", qop=\"auth\", nonce=\"" + nonce + "\", opaque=\"" + opaque + "\"";
    }

    private static String bytesToHex(byte[] bytes2) {
        char[] hexChars = new char[bytes2.length * 2];
        for (int j = 0; j < bytes2.length; ++j) {
            int v = bytes2[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static synchronized String md5(byte[] payload) {
        MD5.reset();
        return DigestAuthHandlerImpl.bytesToHex(MD5.digest(payload));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
        hexArray = "0123456789abcdef".toCharArray();
    }

    private static class Nonce {
        private final long createdAt = System.currentTimeMillis();
        private int count = 0;

        Nonce() {
        }
    }
}

