/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthHandlerImpl;

abstract class AuthorizationAuthHandler
extends AuthHandlerImpl {
    protected final Type type;

    AuthorizationAuthHandler(AuthProvider authProvider, Type type2) {
        super(authProvider);
        this.type = type2;
    }

    AuthorizationAuthHandler(AuthProvider authProvider, String realm, Type type2) {
        super(authProvider, realm);
        this.type = type2;
    }

    protected final void parseAuthorization(RoutingContext ctx, boolean optional2, Handler<AsyncResult<String>> handler) {
        HttpServerRequest request = ctx.request();
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            if (optional2) {
                handler.handle(Future.succeededFuture());
            } else {
                handler.handle(Future.failedFuture(UNAUTHORIZED));
            }
            return;
        }
        try {
            int idx = authorization.indexOf(32);
            if (idx <= 0) {
                handler.handle(Future.failedFuture(BAD_REQUEST));
                return;
            }
            if (!this.type.is(authorization.substring(0, idx))) {
                handler.handle(Future.failedFuture(UNAUTHORIZED));
                return;
            }
            handler.handle(Future.succeededFuture(authorization.substring(idx + 1)));
        }
        catch (RuntimeException e2) {
            handler.handle(Future.failedFuture(e2));
        }
    }

    static enum Type {
        BASIC("Basic"),
        DIGEST("Digest"),
        BEARER("Bearer"),
        HOBA("HOBA"),
        MUTUAL("Mutual"),
        NEGOTIATE("Negotiate"),
        OAUTH("OAuth"),
        SCRAM_SHA_1("SCRAM-SHA-1"),
        SCRAM_SHA_256("SCRAM-SHA-256");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public boolean is(String other) {
            return this.label.equalsIgnoreCase(other);
        }
    }
}

