/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.codec.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.codec.spi.BodyStream;

public class StreamingBodyCodec
implements BodyCodec<Void> {
    private final WriteStream<Buffer> stream;
    private final boolean close;
    private Throwable error;

    public StreamingBodyCodec(WriteStream<Buffer> stream) {
        this(stream, true);
    }

    public StreamingBodyCodec(WriteStream<Buffer> stream, boolean close) {
        this.stream = stream;
        this.close = close;
    }

    public void init() {
        this.stream.exceptionHandler(err -> {
            StreamingBodyCodec streamingBodyCodec = this;
            synchronized (streamingBodyCodec) {
                this.error = err;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Handler<AsyncResult<BodyStream<Void>>> handler) {
        Future<Object> result2;
        StreamingBodyCodec streamingBodyCodec = this;
        synchronized (streamingBodyCodec) {
            result2 = this.error != null ? Future.failedFuture(this.error) : Future.succeededFuture(new BodyStream<Void>(){
                Promise<Void> promise = Promise.promise();

                @Override
                public Future<Void> result() {
                    return this.promise.future();
                }

                @Override
                public void handle(Throwable cause) {
                    this.promise.tryFail(cause);
                }

                @Override
                public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
                    StreamingBodyCodec.this.stream.exceptionHandler((Handler)handler);
                    return this;
                }

                @Override
                public WriteStream<Buffer> write(Buffer data2, Handler<AsyncResult<Void>> handler) {
                    StreamingBodyCodec.this.stream.write(data2, handler);
                    return this;
                }

                @Override
                public WriteStream<Buffer> write(Buffer data2) {
                    return this.write(data2, (Handler<AsyncResult<Void>>)null);
                }

                @Override
                public void end() {
                    this.end((Handler<AsyncResult<Void>>)null);
                }

                @Override
                public void end(Handler<AsyncResult<Void>> handler) {
                    if (StreamingBodyCodec.this.close) {
                        StreamingBodyCodec.this.stream.end(ar -> {
                            if (ar.succeeded()) {
                                this.promise.tryComplete();
                            } else {
                                this.promise.tryFail(ar.cause());
                            }
                            if (handler != null) {
                                handler.handle((AsyncResult<Void>)ar);
                            }
                        });
                    } else {
                        this.promise.tryComplete();
                        if (handler != null) {
                            handler.handle(Future.succeededFuture());
                        }
                    }
                }

                @Override
                public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
                    StreamingBodyCodec.this.stream.setWriteQueueMaxSize(maxSize);
                    return this;
                }

                @Override
                public boolean writeQueueFull() {
                    return StreamingBodyCodec.this.stream.writeQueueFull();
                }

                @Override
                public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
                    StreamingBodyCodec.this.stream.drainHandler(handler);
                    return this;
                }
            });
        }
        handler.handle(result2);
    }
}

