/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.codec;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.codec.impl.BodyCodecImpl;
import io.vertx.ext.web.codec.impl.StreamingBodyCodec;
import io.vertx.ext.web.codec.spi.BodyStream;
import java.util.function.Function;

@VertxGen
public interface BodyCodec<T> {
    public static BodyCodec<String> string() {
        return BodyCodecImpl.STRING;
    }

    public static BodyCodec<String> string(String encoding2) {
        return BodyCodecImpl.string(encoding2);
    }

    public static BodyCodec<Buffer> buffer() {
        return BodyCodecImpl.BUFFER;
    }

    public static BodyCodec<JsonObject> jsonObject() {
        return BodyCodecImpl.JSON_OBJECT;
    }

    public static BodyCodec<JsonArray> jsonArray() {
        return BodyCodecImpl.JSON_ARRAY;
    }

    public static <U> BodyCodec<U> json(Class<U> type2) {
        return BodyCodecImpl.json(type2);
    }

    public static BodyCodec<Void> none() {
        return BodyCodecImpl.NONE;
    }

    public static <T> BodyCodec<T> create(Function<Buffer, T> decode) {
        return new BodyCodecImpl<T>(decode);
    }

    public static BodyCodec<Void> pipe(WriteStream<Buffer> stream) {
        return BodyCodec.pipe(stream, true);
    }

    public static BodyCodec<Void> pipe(WriteStream<Buffer> stream, boolean close) {
        StreamingBodyCodec bodyCodec = new StreamingBodyCodec(stream, close);
        bodyCodec.init();
        return bodyCodec;
    }

    @GenIgnore
    public void create(Handler<AsyncResult<BodyStream<T>>> var1);
}

