/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.transport.EpollTransport;
import io.vertx.core.net.impl.transport.KQueueTransport;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.concurrent.ThreadFactory;

public class Transport {
    public static final int ACCEPTOR_EVENT_LOOP_GROUP = 0;
    public static final int IO_EVENT_LOOP_GROUP = 1;
    public static Transport JDK = new Transport();

    public static Transport nativeTransport() {
        Transport transport = null;
        try {
            EpollTransport epoll = new EpollTransport();
            if (((Transport)epoll).isAvailable()) {
                return epoll;
            }
            transport = epoll;
        }
        catch (Throwable epoll) {
            // empty catch block
        }
        try {
            KQueueTransport kqueue = new KQueueTransport();
            if (((Transport)kqueue).isAvailable()) {
                return kqueue;
            }
            if (transport == null) {
                transport = kqueue;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return transport;
    }

    public static Transport transport(boolean preferNative) {
        if (preferNative) {
            Transport nativeTransport = Transport.nativeTransport();
            if (nativeTransport != null && nativeTransport.isAvailable()) {
                return nativeTransport;
            }
            return JDK;
        }
        return JDK;
    }

    protected Transport() {
    }

    public boolean isAvailable() {
        return true;
    }

    public Throwable unavailabilityCause() {
        return null;
    }

    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            throw new IllegalArgumentException("Domain socket not supported by JDK transport");
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            if (inetSocketAddress.isUnresolved()) {
                return new SocketAddressImpl(inetSocketAddress.getPort(), inetSocketAddress.getHostName());
            }
            return new SocketAddressImpl(inetSocketAddress.getPort(), inetSocketAddress.getAddress().getHostAddress());
        }
        return null;
    }

    ChannelOption<?> channelOption(String name2) {
        return null;
    }

    public EventLoopGroup eventLoopGroup(int type2, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    public DatagramChannel datagramChannel() {
        return new NioDatagramChannel();
    }

    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        switch (family) {
            case IPv4: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv4);
            }
            case IPv6: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv6);
            }
        }
        throw new UnsupportedOperationException();
    }

    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return NioSocketChannel::new;
    }

    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return NioServerSocketChannel::new;
    }

    public void configure(DatagramChannel channel, DatagramSocketOptions options2) {
        channel.config().setAllocator(PartialPooledByteBufAllocator.INSTANCE);
        if (options2.getSendBufferSize() != -1) {
            channel.config().setSendBufferSize(options2.getSendBufferSize());
        }
        if (options2.getReceiveBufferSize() != -1) {
            channel.config().setReceiveBufferSize(options2.getReceiveBufferSize());
            channel.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(options2.getReceiveBufferSize()));
        }
        channel.config().setOption(ChannelOption.SO_REUSEADDR, options2.isReuseAddress());
        if (options2.getTrafficClass() != -1) {
            channel.config().setTrafficClass(options2.getTrafficClass());
        }
        channel.config().setBroadcast(options2.isBroadcast());
        if (this == JDK) {
            channel.config().setLoopbackModeDisabled(options2.isLoopbackModeDisabled());
            if (options2.getMulticastTimeToLive() != -1) {
                channel.config().setTimeToLive(options2.getMulticastTimeToLive());
            }
            if (options2.getMulticastNetworkInterface() != null) {
                try {
                    channel.config().setNetworkInterface(NetworkInterface.getByName(options2.getMulticastNetworkInterface()));
                }
                catch (SocketException e2) {
                    throw new IllegalArgumentException("Could not find network interface with name " + options2.getMulticastNetworkInterface());
                }
            }
        }
    }

    public void configure(ClientOptionsBase options2, boolean domainSocket, Bootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(ChannelOption.SO_REUSEADDR, options2.isReuseAddress());
            bootstrap.option(ChannelOption.TCP_NODELAY, options2.isTcpNoDelay());
            bootstrap.option(ChannelOption.SO_KEEPALIVE, options2.isTcpKeepAlive());
        }
        if (options2.getLocalAddress() != null) {
            bootstrap.localAddress(options2.getLocalAddress(), 0);
        }
        if (options2.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, options2.getSendBufferSize());
        }
        if (options2.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, options2.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(options2.getReceiveBufferSize()));
        }
        if (options2.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, options2.getSoLinger());
        }
        if (options2.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, options2.getTrafficClass());
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, options2.getConnectTimeout());
        bootstrap.option(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
    }

    public void configure(NetServerOptions options2, boolean domainSocket, ServerBootstrap bootstrap) {
        bootstrap.option(ChannelOption.SO_REUSEADDR, options2.isReuseAddress());
        if (!domainSocket) {
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, options2.isTcpKeepAlive());
            bootstrap.childOption(ChannelOption.TCP_NODELAY, options2.isTcpNoDelay());
        }
        if (options2.getSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, options2.getSendBufferSize());
        }
        if (options2.getReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, options2.getReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(options2.getReceiveBufferSize()));
        }
        if (options2.getSoLinger() != -1) {
            bootstrap.childOption(ChannelOption.SO_LINGER, options2.getSoLinger());
        }
        if (options2.getTrafficClass() != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, options2.getTrafficClass());
        }
        bootstrap.childOption(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
        if (options2.getAcceptBacklog() != -1) {
            bootstrap.option(ChannelOption.SO_BACKLOG, options2.getAcceptBacklog());
        }
    }
}

