/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.impl.Arguments;
import io.vertx.core.net.SocketAddress;
import java.util.Objects;

public class SocketAddressImpl
implements SocketAddress {
    private final String hostAddress;
    private final int port;
    private final String path;

    public SocketAddressImpl(int port, String host) {
        Objects.requireNonNull(host, "no null host accepted");
        Arguments.require(!host.isEmpty(), "no empty host accepted");
        Arguments.requireInRange(port, 0, 65535, "port p must be in range 0 <= p <= 65535");
        this.port = port;
        this.hostAddress = host;
        this.path = null;
    }

    public SocketAddressImpl(String path2) {
        this.port = -1;
        this.hostAddress = null;
        this.path = path2;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String host() {
        return this.hostAddress;
    }

    @Override
    public int port() {
        return this.port;
    }

    public String toString() {
        if (this.path == null) {
            return this.hostAddress + ":" + this.port;
        }
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketAddressImpl that = (SocketAddressImpl)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.hostAddress != null ? !this.hostAddress.equals(that.hostAddress) : that.hostAddress != null) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        int result2 = this.hostAddress != null ? this.hostAddress.hashCode() : 0;
        result2 = 31 * result2 + (this.path != null ? this.path.hashCode() : 0);
        result2 = 31 * result2 + this.port;
        return result2;
    }
}

