/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ChannelFutureListenerAdapter;
import io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public abstract class ConnectionBase {
    public static final VertxException CLOSED_EXCEPTION = new VertxException("Connection was closed", true);
    private static final Logger log = LoggerFactory.getLogger(ConnectionBase.class);
    private static final int MAX_REGION_SIZE = 0x100000;
    public final VoidChannelPromise voidPromise;
    protected final VertxInternal vertx;
    protected final ChannelHandlerContext chctx;
    protected final ContextInternal context;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private int writeInProgress;
    private Object metric;
    private SocketAddress remoteAddress;
    private SocketAddress localAddress;
    private boolean read;
    private boolean needsFlush;
    private boolean closed;

    protected ConnectionBase(VertxInternal vertx, ChannelHandlerContext chctx, ContextInternal context) {
        this.vertx = vertx;
        this.chctx = chctx;
        this.context = context;
        this.voidPromise = new VoidChannelPromise(chctx.channel(), false);
    }

    public void fail(Throwable error2) {
        this.handler().fail(error2);
    }

    public VertxHandler handler() {
        return (VertxHandler)this.chctx.handler();
    }

    final void endReadAndFlush() {
        if (this.read) {
            this.read = false;
            if (this.needsFlush) {
                this.needsFlush = false;
                this.chctx.flush();
            }
        }
    }

    final boolean setRead() {
        this.read = true;
        return !this.closed;
    }

    private void write(Object msg, boolean flush2, ChannelPromise promise2) {
        boolean bl = this.needsFlush = !flush2;
        if (flush2) {
            this.chctx.writeAndFlush(msg, promise2);
        } else {
            this.chctx.write(msg, promise2);
        }
    }

    private void writeFlush(ChannelPromise promise2) {
        if (this.needsFlush) {
            this.needsFlush = false;
            this.chctx.writeAndFlush(Unpooled.EMPTY_BUFFER, promise2);
        } else {
            promise2.setSuccess();
        }
    }

    private void writeClose(Handler<AsyncResult<Void>> handler) {
        if (this.closed) {
            if (handler != null) {
                handler.handle(Future.succeededFuture());
            }
            return;
        }
        this.closed = true;
        ChannelPromise promise2 = this.chctx.newPromise().addListener(f -> {
            ChannelFuture closeFut = this.chctx.channel().close();
            if (handler != null) {
                closeFut.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)new ChannelFutureListenerAdapter<Object>(this.context, null, handler));
            }
        });
        this.writeFlush(promise2);
    }

    public final ChannelPromise toPromise(Handler<AsyncResult<Void>> handler) {
        return handler == null ? this.voidPromise : this.wrap(handler);
    }

    private ChannelPromise wrap(Handler<AsyncResult<Void>> handler) {
        ChannelPromise promise2 = this.chctx.newPromise();
        promise2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)fut -> {
            if (fut.isSuccess()) {
                handler.handle(Future.succeededFuture());
            } else {
                handler.handle(Future.failedFuture(fut.cause()));
            }
        }));
        return promise2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToChannel(Object msg, ChannelPromise promise2) {
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            if (!this.chctx.executor().inEventLoop() || this.writeInProgress > 0) {
                this.queueForWrite(msg, promise2);
                return;
            }
        }
        this.write(msg, !this.read, promise2);
    }

    private void queueForWrite(Object msg, ChannelPromise promise2) {
        ++this.writeInProgress;
        this.chctx.executor().execute(() -> {
            boolean flush2;
            ConnectionBase connectionBase = this;
            synchronized (connectionBase) {
                flush2 = --this.writeInProgress == 0 && !this.read;
            }
            this.write(msg, flush2, promise2);
        });
    }

    public void writeToChannel(Object obj2) {
        this.writeToChannel(obj2, this.voidPromise);
    }

    public final void flush() {
        this.flush(this.voidPromise);
    }

    public final void flush(ChannelPromise promise2) {
        if (this.chctx.executor().inEventLoop()) {
            this.writeFlush(promise2);
        } else {
            this.chctx.executor().execute(() -> this.writeFlush(promise2));
        }
    }

    public boolean isNotWritable() {
        return !this.chctx.channel().isWritable();
    }

    public void close() {
        this.close(null);
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        EventExecutor exec = this.chctx.executor();
        if (exec.inEventLoop()) {
            this.writeClose(handler);
        } else {
            exec.execute(() -> this.writeClose(handler));
        }
    }

    public synchronized ConnectionBase closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    public synchronized ConnectionBase exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    protected synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    public void doPause() {
        this.chctx.channel().config().setAutoRead(false);
    }

    public void doResume() {
        this.chctx.channel().config().setAutoRead(true);
    }

    public void doSetWriteQueueMaxSize(int size) {
        ChannelConfig config = this.chctx.channel().config();
        config.setWriteBufferWaterMark(new WriteBufferWaterMark(size / 2, size));
    }

    protected final void checkContext() {
        if (this.context != this.vertx.getContext()) {
            throw new IllegalStateException("Wrong context!");
        }
    }

    public final Channel channel() {
        return this.chctx.channel();
    }

    public final ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    public final ContextInternal getContext() {
        return this.context;
    }

    public final synchronized void metric(Object metric2) {
        this.metric = metric2;
    }

    public final synchronized Object metric() {
        return this.metric;
    }

    public abstract NetworkMetrics metrics();

    protected synchronized void handleException(Throwable t3) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            metrics.exceptionOccurred(this.metric, this.remoteAddress(), t3);
        }
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t3);
        } else if (log.isDebugEnabled()) {
            log.error((Object)t3.getMessage(), t3);
        } else {
            log.error(t3.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClosed() {
        Handler<Void> handler;
        this.closed = true;
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            NetworkMetrics metrics = this.metrics();
            if (metrics != null && metrics instanceof TCPMetrics) {
                ((TCPMetrics)metrics).disconnected(this.metric(), this.remoteAddress());
            }
            handler = this.closeHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    protected void handleIdle() {
        this.chctx.close();
    }

    protected abstract void handleInterestedOpsChanged();

    protected void addFuture(Handler<AsyncResult<Void>> completionHandler, ChannelFuture future2) {
        if (future2 != null) {
            future2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)channelFuture -> this.context.executeFromIO(v -> {
                if (completionHandler != null) {
                    if (channelFuture.isSuccess()) {
                        completionHandler.handle(Future.succeededFuture());
                    } else {
                        completionHandler.handle(Future.failedFuture(channelFuture.cause()));
                    }
                } else if (!channelFuture.isSuccess()) {
                    this.handleException(channelFuture.cause());
                }
            })));
        }
    }

    protected boolean supportsFileRegion() {
        return !this.isSsl();
    }

    public void reportBytesRead(long numberOfBytes) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            metrics.bytesRead(this.metric(), this.remoteAddress(), numberOfBytes);
        }
    }

    public void reportBytesWritten(long numberOfBytes) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            metrics.bytesWritten(this.metric(), this.remoteAddress(), numberOfBytes);
        }
    }

    private void sendFileRegion(RandomAccessFile file2, long offset, long length, ChannelPromise writeFuture) {
        if (length < 0x100000L) {
            this.writeToChannel(new DefaultFileRegion(file2.getChannel(), offset, length), writeFuture);
        } else {
            ChannelPromise promise2 = this.chctx.newPromise();
            DefaultFileRegion region = new DefaultFileRegion(file2.getChannel(), offset, 0x100000L);
            region.retain();
            this.writeToChannel(region, promise2);
            promise2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)future2 -> {
                if (future2.isSuccess()) {
                    this.sendFileRegion(file2, offset + 0x100000L, length - 0x100000L, writeFuture);
                } else {
                    log.error((Object)future2.cause().getMessage(), future2.cause());
                    writeFuture.setFailure(future2.cause());
                }
            }));
        }
    }

    protected ChannelFuture sendFile(RandomAccessFile raf, long offset, long length) throws IOException {
        ChannelPromise writeFuture = this.chctx.newPromise();
        if (!this.supportsFileRegion()) {
            this.writeToChannel(new ChunkedFile(raf, offset, length, 8192), writeFuture);
        } else {
            this.sendFileRegion(raf, offset, length, writeFuture);
        }
        if (writeFuture != null) {
            writeFuture.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)fut -> raf.close()));
        } else {
            raf.close();
        }
        return writeFuture;
    }

    public boolean isSsl() {
        return this.chctx.pipeline().get(SslHandler.class) != null;
    }

    public SSLSession sslSession() {
        ChannelHandlerContext sslHandlerContext = this.chctx.pipeline().context(SslHandler.class);
        if (sslHandlerContext != null) {
            SslHandler sslHandler = (SslHandler)sslHandlerContext.handler();
            return sslHandler.engine().getSession();
        }
        return null;
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        SSLSession session = this.sslSession();
        if (session != null) {
            return session.getPeerCertificateChain();
        }
        return null;
    }

    public String indicatedServerName() {
        if (this.chctx.channel().hasAttr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR)) {
            return this.chctx.channel().attr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR).get();
        }
        return null;
    }

    public ChannelPromise channelFuture() {
        return this.chctx.newPromise();
    }

    public String remoteName() {
        java.net.SocketAddress addr = this.chctx.channel().remoteAddress();
        if (addr instanceof InetSocketAddress) {
            return ((InetSocketAddress)addr).getHostString();
        }
        return null;
    }

    public SocketAddress remoteAddress() {
        java.net.SocketAddress addr;
        SocketAddress address = this.remoteAddress;
        if (address == null && (addr = this.chctx.channel().remoteAddress()) != null) {
            this.remoteAddress = address = this.vertx.transport().convert(addr);
        }
        return address;
    }

    public SocketAddress localAddress() {
        java.net.SocketAddress addr;
        SocketAddress address = this.localAddress;
        if (address == null && (addr = this.chctx.channel().localAddress()) != null) {
            this.localAddress = address = this.vertx.transport().convert(addr);
        }
        return address;
    }

    public void handleMessage(Object msg) {
    }
}

