/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class TCPSSLOptionsConverter {
    TCPSSLOptionsConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, TCPSSLOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "crlPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addCrlPath((String)item);
                        }
                    });
                    break;
                }
                case "crlValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addCrlValue(Buffer.buffer(Base64.getDecoder().decode((String)item)));
                        }
                    });
                    break;
                }
                case "enabledCipherSuites": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addEnabledCipherSuite((String)item);
                        }
                    });
                    break;
                }
                case "enabledSecureTransportProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new LinkedHashSet<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setEnabledSecureTransportProtocols(list);
                    break;
                }
                case "idleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "idleTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setIdleTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "jdkSslEngineOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setJdkSslEngineOptions(new JdkSSLEngineOptions((JsonObject)member.getValue()));
                    break;
                }
                case "keyStoreOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setKeyStoreOptions(new JksOptions((JsonObject)member.getValue()));
                    break;
                }
                case "openSslEngineOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setOpenSslEngineOptions(new OpenSSLEngineOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pemKeyCertOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setPemKeyCertOptions(new PemKeyCertOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pemTrustOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setPemTrustOptions(new PemTrustOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pfxKeyCertOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setPfxKeyCertOptions(new PfxOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pfxTrustOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setPfxTrustOptions(new PfxOptions((JsonObject)member.getValue()));
                    break;
                }
                case "soLinger": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setSoLinger(((Number)member.getValue()).intValue());
                    break;
                }
                case "ssl": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setSsl((Boolean)member.getValue());
                    break;
                }
                case "sslHandshakeTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setSslHandshakeTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "sslHandshakeTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setSslHandshakeTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "tcpCork": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpCork((Boolean)member.getValue());
                    break;
                }
                case "tcpFastOpen": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpFastOpen((Boolean)member.getValue());
                    break;
                }
                case "tcpKeepAlive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpKeepAlive((Boolean)member.getValue());
                    break;
                }
                case "tcpNoDelay": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpNoDelay((Boolean)member.getValue());
                    break;
                }
                case "tcpQuickAck": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpQuickAck((Boolean)member.getValue());
                    break;
                }
                case "trustStoreOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setTrustStoreOptions(new JksOptions((JsonObject)member.getValue()));
                    break;
                }
                case "useAlpn": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setUseAlpn((Boolean)member.getValue());
                    break;
                }
                case "usePooledBuffers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setUsePooledBuffers((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(TCPSSLOptions obj2, JsonObject json) {
        TCPSSLOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(TCPSSLOptions obj2, Map<String, Object> json) {
        JsonArray array2;
        if (obj2.getCrlPaths() != null) {
            array2 = new JsonArray();
            obj2.getCrlPaths().forEach(item -> array2.add((String)item));
            json.put("crlPaths", array2);
        }
        if (obj2.getCrlValues() != null) {
            array2 = new JsonArray();
            obj2.getCrlValues().forEach(item -> array2.add(Base64.getEncoder().encodeToString(item.getBytes())));
            json.put("crlValues", array2);
        }
        if (obj2.getEnabledCipherSuites() != null) {
            array2 = new JsonArray();
            obj2.getEnabledCipherSuites().forEach(item -> array2.add((String)item));
            json.put("enabledCipherSuites", array2);
        }
        if (obj2.getEnabledSecureTransportProtocols() != null) {
            array2 = new JsonArray();
            obj2.getEnabledSecureTransportProtocols().forEach(item -> array2.add((String)item));
            json.put("enabledSecureTransportProtocols", array2);
        }
        json.put("idleTimeout", obj2.getIdleTimeout());
        if (obj2.getIdleTimeoutUnit() != null) {
            json.put("idleTimeoutUnit", obj2.getIdleTimeoutUnit().name());
        }
        if (obj2.getJdkSslEngineOptions() != null) {
            json.put("jdkSslEngineOptions", obj2.getJdkSslEngineOptions().toJson());
        }
        if (obj2.getKeyStoreOptions() != null) {
            json.put("keyStoreOptions", obj2.getKeyStoreOptions().toJson());
        }
        if (obj2.getOpenSslEngineOptions() != null) {
            json.put("openSslEngineOptions", obj2.getOpenSslEngineOptions().toJson());
        }
        if (obj2.getPemKeyCertOptions() != null) {
            json.put("pemKeyCertOptions", obj2.getPemKeyCertOptions().toJson());
        }
        if (obj2.getPemTrustOptions() != null) {
            json.put("pemTrustOptions", obj2.getPemTrustOptions().toJson());
        }
        if (obj2.getPfxKeyCertOptions() != null) {
            json.put("pfxKeyCertOptions", obj2.getPfxKeyCertOptions().toJson());
        }
        if (obj2.getPfxTrustOptions() != null) {
            json.put("pfxTrustOptions", obj2.getPfxTrustOptions().toJson());
        }
        json.put("soLinger", obj2.getSoLinger());
        json.put("ssl", obj2.isSsl());
        json.put("sslHandshakeTimeout", obj2.getSslHandshakeTimeout());
        if (obj2.getSslHandshakeTimeoutUnit() != null) {
            json.put("sslHandshakeTimeoutUnit", obj2.getSslHandshakeTimeoutUnit().name());
        }
        json.put("tcpCork", obj2.isTcpCork());
        json.put("tcpFastOpen", obj2.isTcpFastOpen());
        json.put("tcpKeepAlive", obj2.isTcpKeepAlive());
        json.put("tcpNoDelay", obj2.isTcpNoDelay());
        json.put("tcpQuickAck", obj2.isTcpQuickAck());
        if (obj2.getTrustStoreOptions() != null) {
            json.put("trustStoreOptions", obj2.getTrustStoreOptions().toJson());
        }
        json.put("useAlpn", obj2.isUseAlpn());
        json.put("usePooledBuffers", obj2.isUsePooledBuffers());
    }
}

