/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemTrustOptions;
import java.util.Base64;
import java.util.Map;

class PemTrustOptionsConverter {
    PemTrustOptionsConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, PemTrustOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "certPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addCertPath((String)item);
                        }
                    });
                    break;
                }
                case "certValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addCertValue(Buffer.buffer(Base64.getDecoder().decode((String)item)));
                        }
                    });
                }
            }
        }
    }

    static void toJson(PemTrustOptions obj2, JsonObject json) {
        PemTrustOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(PemTrustOptions obj2, Map<String, Object> json) {
        JsonArray array2;
        if (obj2.getCertPaths() != null) {
            array2 = new JsonArray();
            obj2.getCertPaths().forEach(item -> array2.add((String)item));
            json.put("certPaths", array2);
        }
        if (obj2.getCertValues() != null) {
            array2 = new JsonArray();
            obj2.getCertValues().forEach(item -> array2.add(Base64.getEncoder().encodeToString(item.getBytes())));
            json.put("certValues", array2);
        }
    }
}

