/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServerOptionsConverter;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@DataObject(generateConverter=true, publicConverter=false)
public class NetServerOptions
extends TCPSSLOptions {
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_ACCEPT_BACKLOG = -1;
    public static final ClientAuth DEFAULT_CLIENT_AUTH = ClientAuth.NONE;
    public static final boolean DEFAULT_SNI = false;
    private int port;
    private String host;
    private int acceptBacklog;
    private ClientAuth clientAuth;
    private boolean sni;

    public NetServerOptions() {
        this.init();
    }

    public NetServerOptions(NetServerOptions other) {
        super(other);
        this.port = other.getPort();
        this.host = other.getHost();
        this.acceptBacklog = other.getAcceptBacklog();
        this.clientAuth = other.getClientAuth();
        this.sni = other.isSni();
    }

    public NetServerOptions(JsonObject json) {
        super(json);
        this.init();
        NetServerOptionsConverter.fromJson(json, this);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        NetServerOptionsConverter.toJson(this, json);
        return json;
    }

    @Override
    public NetServerOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public NetServerOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public NetServerOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public NetServerOptions setReusePort(boolean reusePort) {
        super.setReusePort(reusePort);
        return this;
    }

    @Override
    public NetServerOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetServerOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetServerOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public NetServerOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public NetServerOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    @Override
    public NetServerOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public NetServerOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        super.setIdleTimeoutUnit(idleTimeoutUnit);
        return this;
    }

    @Override
    public NetServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public NetServerOptions setUseAlpn(boolean useAlpn) {
        super.setUseAlpn(useAlpn);
        return this;
    }

    @Override
    public NetServerOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    @Override
    public NetServerOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (NetServerOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public NetServerOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (NetServerOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public NetServerOptions setKeyCertOptions(KeyCertOptions options2) {
        super.setKeyCertOptions(options2);
        return this;
    }

    @Override
    public NetServerOptions setKeyStoreOptions(JksOptions options2) {
        super.setKeyStoreOptions(options2);
        return this;
    }

    @Override
    public NetServerOptions setPfxKeyCertOptions(PfxOptions options2) {
        return (NetServerOptions)super.setPfxKeyCertOptions(options2);
    }

    @Override
    public NetServerOptions setPemKeyCertOptions(PemKeyCertOptions options2) {
        return (NetServerOptions)super.setPemKeyCertOptions(options2);
    }

    @Override
    public NetServerOptions setTrustOptions(TrustOptions options2) {
        super.setTrustOptions(options2);
        return this;
    }

    @Override
    public NetServerOptions setTrustStoreOptions(JksOptions options2) {
        super.setTrustStoreOptions(options2);
        return this;
    }

    @Override
    public NetServerOptions setPfxTrustOptions(PfxOptions options2) {
        return (NetServerOptions)super.setPfxTrustOptions(options2);
    }

    @Override
    public NetServerOptions setPemTrustOptions(PemTrustOptions options2) {
        return (NetServerOptions)super.setPemTrustOptions(options2);
    }

    @Override
    public NetServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public NetServerOptions addEnabledSecureTransportProtocol(String protocol2) {
        super.addEnabledSecureTransportProtocol(protocol2);
        return this;
    }

    @Override
    public NetServerOptions removeEnabledSecureTransportProtocol(String protocol2) {
        return (NetServerOptions)super.removeEnabledSecureTransportProtocol(protocol2);
    }

    @Override
    public NetServerOptions setTcpFastOpen(boolean tcpFastOpen) {
        return (NetServerOptions)super.setTcpFastOpen(tcpFastOpen);
    }

    @Override
    public NetServerOptions setTcpCork(boolean tcpCork) {
        return (NetServerOptions)super.setTcpCork(tcpCork);
    }

    @Override
    public NetServerOptions setTcpQuickAck(boolean tcpQuickAck) {
        return (NetServerOptions)super.setTcpQuickAck(tcpQuickAck);
    }

    @Override
    public NetServerOptions addCrlPath(String crlPath) throws NullPointerException {
        return (NetServerOptions)super.addCrlPath(crlPath);
    }

    @Override
    public NetServerOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (NetServerOptions)super.addCrlValue(crlValue);
    }

    @Override
    public NetServerOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        return (NetServerOptions)super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    @Override
    public NetServerOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        return (NetServerOptions)super.setSslHandshakeTimeout(sslHandshakeTimeout);
    }

    @Override
    public NetServerOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        return (NetServerOptions)super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
    }

    public int getAcceptBacklog() {
        return this.acceptBacklog;
    }

    public NetServerOptions setAcceptBacklog(int acceptBacklog) {
        this.acceptBacklog = acceptBacklog;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NetServerOptions setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port p must be in range 0 <= p <= 65535");
        }
        this.port = port;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public NetServerOptions setHost(String host) {
        this.host = host;
        return this;
    }

    @Deprecated
    public boolean isClientAuthRequired() {
        return this.clientAuth == ClientAuth.REQUIRED;
    }

    @Deprecated
    public NetServerOptions setClientAuthRequired(boolean clientAuthRequired) {
        this.clientAuth = clientAuthRequired ? ClientAuth.REQUIRED : ClientAuth.NONE;
        return this;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public NetServerOptions setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    @Override
    public NetServerOptions setLogActivity(boolean logEnabled) {
        return (NetServerOptions)super.setLogActivity(logEnabled);
    }

    public boolean isSni() {
        return this.sni;
    }

    public NetServerOptions setSni(boolean sni) {
        this.sni = sni;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetServerOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetServerOptions that = (NetServerOptions)o;
        if (this.acceptBacklog != that.acceptBacklog) {
            return false;
        }
        if (this.clientAuth != that.clientAuth) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return this.sni == that.sni;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.port;
        result2 = 31 * result2 + (this.host != null ? this.host.hashCode() : 0);
        result2 = 31 * result2 + this.acceptBacklog;
        result2 = 31 * result2 + this.clientAuth.hashCode();
        result2 = 31 * result2 + (this.sni ? 1 : 0);
        return result2;
    }

    private void init() {
        this.port = 0;
        this.host = DEFAULT_HOST;
        this.acceptBacklog = -1;
        this.clientAuth = DEFAULT_CLIENT_AUTH;
        this.sni = false;
    }
}

