/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBaseConverter;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@DataObject(generateConverter=true, publicConverter=false)
public abstract class ClientOptionsBase
extends TCPSSLOptions {
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final boolean DEFAULT_TRUST_ALL = false;
    public static final String DEFAULT_METRICS_NAME = "";
    private int connectTimeout;
    private boolean trustAll;
    private String metricsName;
    private ProxyOptions proxyOptions;
    private String localAddress;

    public ClientOptionsBase() {
        this.init();
    }

    public ClientOptionsBase(ClientOptionsBase other) {
        super(other);
        this.connectTimeout = other.getConnectTimeout();
        this.trustAll = other.isTrustAll();
        this.metricsName = other.metricsName;
        this.proxyOptions = other.proxyOptions != null ? new ProxyOptions(other.proxyOptions) : null;
        this.localAddress = other.localAddress;
    }

    public ClientOptionsBase(JsonObject json) {
        super(json);
        this.init();
        ClientOptionsBaseConverter.fromJson(json, this);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        ClientOptionsBaseConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.connectTimeout = 60000;
        this.trustAll = false;
        this.metricsName = DEFAULT_METRICS_NAME;
        this.proxyOptions = null;
        this.localAddress = null;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public ClientOptionsBase setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ClientOptionsBase setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public ClientOptionsBase setMetricsName(String metricsName) {
        this.metricsName = metricsName;
        return this;
    }

    public ClientOptionsBase setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public ClientOptionsBase setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    @Override
    public ClientOptionsBase setLogActivity(boolean logEnabled) {
        return (ClientOptionsBase)super.setLogActivity(logEnabled);
    }

    @Override
    public ClientOptionsBase setTcpNoDelay(boolean tcpNoDelay) {
        return (ClientOptionsBase)super.setTcpNoDelay(tcpNoDelay);
    }

    @Override
    public ClientOptionsBase setTcpKeepAlive(boolean tcpKeepAlive) {
        return (ClientOptionsBase)super.setTcpKeepAlive(tcpKeepAlive);
    }

    @Override
    public ClientOptionsBase setSoLinger(int soLinger) {
        return (ClientOptionsBase)super.setSoLinger(soLinger);
    }

    @Override
    public ClientOptionsBase setUsePooledBuffers(boolean usePooledBuffers) {
        return (ClientOptionsBase)super.setUsePooledBuffers(usePooledBuffers);
    }

    @Override
    public ClientOptionsBase setIdleTimeout(int idleTimeout) {
        return (ClientOptionsBase)super.setIdleTimeout(idleTimeout);
    }

    @Override
    public ClientOptionsBase setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        return (ClientOptionsBase)super.setIdleTimeoutUnit(idleTimeoutUnit);
    }

    @Override
    public ClientOptionsBase setSsl(boolean ssl) {
        return (ClientOptionsBase)super.setSsl(ssl);
    }

    @Override
    public ClientOptionsBase setKeyCertOptions(KeyCertOptions options2) {
        return (ClientOptionsBase)super.setKeyCertOptions(options2);
    }

    @Override
    public ClientOptionsBase setKeyStoreOptions(JksOptions options2) {
        return (ClientOptionsBase)super.setKeyStoreOptions(options2);
    }

    @Override
    public ClientOptionsBase setPfxKeyCertOptions(PfxOptions options2) {
        return (ClientOptionsBase)super.setPfxKeyCertOptions(options2);
    }

    @Override
    public ClientOptionsBase setPemKeyCertOptions(PemKeyCertOptions options2) {
        return (ClientOptionsBase)super.setPemKeyCertOptions(options2);
    }

    @Override
    public ClientOptionsBase setTrustOptions(TrustOptions options2) {
        return (ClientOptionsBase)super.setTrustOptions(options2);
    }

    @Override
    public ClientOptionsBase setTrustStoreOptions(JksOptions options2) {
        return (ClientOptionsBase)super.setTrustStoreOptions(options2);
    }

    @Override
    public ClientOptionsBase setPfxTrustOptions(PfxOptions options2) {
        return (ClientOptionsBase)super.setPfxTrustOptions(options2);
    }

    @Override
    public ClientOptionsBase setPemTrustOptions(PemTrustOptions options2) {
        return (ClientOptionsBase)super.setPemTrustOptions(options2);
    }

    @Override
    public ClientOptionsBase setUseAlpn(boolean useAlpn) {
        return (ClientOptionsBase)super.setUseAlpn(useAlpn);
    }

    @Override
    public ClientOptionsBase setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (ClientOptionsBase)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public ClientOptionsBase setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (ClientOptionsBase)super.setJdkSslEngineOptions(sslEngineOptions);
    }

    @Override
    public ClientOptionsBase setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (ClientOptionsBase)super.setOpenSslEngineOptions(sslEngineOptions);
    }

    @Override
    public ClientOptionsBase setSendBufferSize(int sendBufferSize) {
        return (ClientOptionsBase)super.setSendBufferSize(sendBufferSize);
    }

    @Override
    public ClientOptionsBase setReceiveBufferSize(int receiveBufferSize) {
        return (ClientOptionsBase)super.setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public ClientOptionsBase setReuseAddress(boolean reuseAddress) {
        return (ClientOptionsBase)super.setReuseAddress(reuseAddress);
    }

    @Override
    public ClientOptionsBase setReusePort(boolean reusePort) {
        return (ClientOptionsBase)super.setReusePort(reusePort);
    }

    @Override
    public ClientOptionsBase setTrafficClass(int trafficClass) {
        return (ClientOptionsBase)super.setTrafficClass(trafficClass);
    }

    @Override
    public ClientOptionsBase addEnabledCipherSuite(String suite) {
        return (ClientOptionsBase)super.addEnabledCipherSuite(suite);
    }

    @Override
    public ClientOptionsBase addCrlPath(String crlPath) throws NullPointerException {
        return (ClientOptionsBase)super.addCrlPath(crlPath);
    }

    @Override
    public ClientOptionsBase addCrlValue(Buffer crlValue) throws NullPointerException {
        return (ClientOptionsBase)super.addCrlValue(crlValue);
    }

    @Override
    public ClientOptionsBase addEnabledSecureTransportProtocol(String protocol2) {
        return (ClientOptionsBase)super.addEnabledSecureTransportProtocol(protocol2);
    }

    @Override
    public ClientOptionsBase removeEnabledSecureTransportProtocol(String protocol2) {
        return (ClientOptionsBase)super.removeEnabledSecureTransportProtocol(protocol2);
    }

    @Override
    public ClientOptionsBase setTcpFastOpen(boolean tcpFastOpen) {
        return (ClientOptionsBase)super.setTcpFastOpen(tcpFastOpen);
    }

    @Override
    public ClientOptionsBase setTcpCork(boolean tcpCork) {
        return (ClientOptionsBase)super.setTcpCork(tcpCork);
    }

    @Override
    public ClientOptionsBase setTcpQuickAck(boolean tcpQuickAck) {
        return (ClientOptionsBase)super.setTcpQuickAck(tcpQuickAck);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientOptionsBase)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientOptionsBase that = (ClientOptionsBase)o;
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        if (this.trustAll != that.trustAll) {
            return false;
        }
        if (!Objects.equals(this.metricsName, that.metricsName)) {
            return false;
        }
        if (!Objects.equals(this.proxyOptions, that.proxyOptions)) {
            return false;
        }
        return Objects.equals(this.localAddress, that.localAddress);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.connectTimeout;
        result2 = 31 * result2 + (this.trustAll ? 1 : 0);
        result2 = 31 * result2 + (this.metricsName != null ? this.metricsName.hashCode() : 0);
        result2 = 31 * result2 + (this.proxyOptions != null ? this.proxyOptions.hashCode() : 0);
        result2 = 31 * result2 + (this.localAddress != null ? this.localAddress.hashCode() : 0);
        return result2;
    }
}

