/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.logging.JULLogDelegateFactory;
import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import io.vertx.core.spi.logging.LogDelegateFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LoggerFactory {
    public static final String LOGGER_DELEGATE_FACTORY_CLASS_NAME = "vertx.logger-delegate-factory-class-name";
    private static volatile LogDelegateFactory delegateFactory;
    private static final ConcurrentMap<String, Logger> loggers;

    public static synchronized void initialise() {
        LogDelegateFactory delegateFactory;
        String className = JULLogDelegateFactory.class.getName();
        try {
            className = System.getProperty(LOGGER_DELEGATE_FACTORY_CLASS_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (className != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clz = loader.loadClass(className);
                delegateFactory = (LogDelegateFactory)clz.newInstance();
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Error instantiating transformer class \"" + className + "\"", e2);
            }
        } else {
            delegateFactory = new JULLogDelegateFactory();
        }
        LoggerFactory.delegateFactory = delegateFactory;
    }

    public static Logger getLogger(Class<?> clazz) {
        String name2 = clazz.isAnonymousClass() ? clazz.getEnclosingClass().getCanonicalName() : clazz.getCanonicalName();
        return LoggerFactory.getLogger(name2);
    }

    public static Logger getLogger(String name2) {
        LogDelegate delegate;
        Logger oldLogger;
        Logger logger2 = (Logger)loggers.get(name2);
        if (logger2 == null && (oldLogger = loggers.putIfAbsent(name2, logger2 = new Logger(delegate = delegateFactory.createDelegate(name2)))) != null) {
            logger2 = oldLogger;
        }
        return logger2;
    }

    public static void removeLogger(String name2) {
        loggers.remove(name2);
    }

    static {
        loggers = new ConcurrentHashMap<String, Logger>();
        LoggerFactory.initialise();
    }
}

