/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.pointer.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointerIterator;
import java.util.List;
import java.util.Map;

public class JsonPointerIteratorImpl
implements JsonPointerIterator {
    @Override
    public boolean isObject(Object value) {
        return value instanceof JsonObject;
    }

    @Override
    public boolean isArray(Object value) {
        return value instanceof JsonArray;
    }

    @Override
    public boolean isNull(Object value) {
        return value == null;
    }

    @Override
    public boolean objectContainsKey(Object value, String key2) {
        return this.isObject(value) && ((JsonObject)value).containsKey(key2);
    }

    @Override
    public Object getObjectParameter(Object value, String key2, boolean createOnMissing) {
        if (this.isObject(value)) {
            if (!this.objectContainsKey(value, key2)) {
                if (createOnMissing) {
                    this.writeObjectParameter(value, key2, new JsonObject());
                } else {
                    return null;
                }
            }
            return this.jsonifyValue(((JsonObject)value).getValue(key2));
        }
        return null;
    }

    @Override
    public Object getArrayElement(Object value, int i) {
        if (this.isArray(value)) {
            try {
                return this.jsonifyValue(((JsonArray)value).getValue(i));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean writeObjectParameter(Object value, String key2, Object el) {
        if (this.isObject(value)) {
            ((JsonObject)value).put(key2, el);
            return true;
        }
        return false;
    }

    @Override
    public boolean writeArrayElement(Object value, int i, Object el) {
        if (this.isArray(value)) {
            try {
                ((JsonArray)value).getList().add(i, el);
                return true;
            }
            catch (IndexOutOfBoundsException e2) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean appendArrayElement(Object value, Object el) {
        if (this.isArray(value)) {
            ((JsonArray)value).add(el);
            return true;
        }
        return false;
    }

    private Object jsonifyValue(Object v) {
        if (v instanceof Map) {
            return new JsonObject((Map)v);
        }
        if (v instanceof List) {
            return new JsonArray((List)v);
        }
        return v;
    }
}

