/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JacksonCodec
implements JsonCodec {
    @Override
    public <T> T fromValue(Object json, Class<T> clazz) {
        Object value = Json.mapper.convertValue(json, clazz);
        if (clazz == Object.class) {
            value = JacksonCodec.adapt(value);
        }
        return value;
    }

    public static <T> T fromValue(Object json, TypeReference<T> type2) {
        Object value = Json.mapper.convertValue(json, type2);
        if (type2.getType() == Object.class) {
            value = JacksonCodec.adapt(value);
        }
        return value;
    }

    @Override
    public <T> T fromString(String str2, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(str2), clazz);
    }

    public static <T> T fromString(String str2, TypeReference<T> type2) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(str2), type2);
    }

    @Override
    public <T> T fromBuffer(Buffer buf, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(buf), clazz);
    }

    public static <T> T fromBuffer(Buffer buf, TypeReference<T> type2) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(buf), type2);
    }

    private static JsonParser createParser(Buffer buf) {
        try {
            return Json.mapper.getFactory().createParser(new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
    }

    private static JsonParser createParser(String str2) {
        try {
            return Json.mapper.getFactory().createParser(str2);
        }
        catch (IOException e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
    }

    private static <T> T fromParser(JsonParser parser, Class<T> type2) throws DecodeException {
        JsonToken remaining;
        Object value;
        try {
            value = Json.mapper.readValue(parser, type2);
            remaining = parser.nextToken();
        }
        catch (Exception e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
        finally {
            JacksonCodec.close(parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        if (type2 == Object.class) {
            value = JacksonCodec.adapt(value);
        }
        return value;
    }

    private static <T> T fromParser(JsonParser parser, TypeReference<T> type2) throws DecodeException {
        JsonToken remaining;
        Object value;
        try {
            value = Json.mapper.readValue(parser, type2);
            remaining = parser.nextToken();
        }
        catch (Exception e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
        finally {
            JacksonCodec.close(parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        if (type2.getType() == Object.class) {
            value = JacksonCodec.adapt(value);
        }
        return value;
    }

    private static void close(JsonParser parser) {
        try {
            parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Object adapt(Object o) {
        try {
            if (o instanceof List) {
                List list = (List)o;
                return new JsonArray(list);
            }
            if (o instanceof Map) {
                Map map2 = (Map)o;
                return new JsonObject(map2);
            }
            return o;
        }
        catch (Exception e2) {
            throw new DecodeException("Failed to decode: " + e2.getMessage());
        }
    }

    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper2 = pretty ? Json.prettyMapper : Json.mapper;
            return mapper2.writeValueAsString(object);
        }
        catch (Exception e2) {
            throw new EncodeException("Failed to encode as JSON: " + e2.getMessage());
        }
    }

    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper2 = pretty ? Json.prettyMapper : Json.mapper;
            return Buffer.buffer(mapper2.writeValueAsBytes(object));
        }
        catch (Exception e2) {
            throw new EncodeException("Failed to encode as JSON: " + e2.getMessage());
        }
    }

    public static <T> T decodeValue(String str2, TypeReference<T> type2) throws DecodeException {
        return JacksonCodec.fromString(str2, type2);
    }

    public static <T> T decodeValue(Buffer buf, TypeReference<T> type2) throws DecodeException {
        return JacksonCodec.fromBuffer(buf, type2);
    }
}

