/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.core.spi.json.JsonCodec;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JsonObject
implements Iterable<Map.Entry<String, Object>>,
ClusterSerializable,
Shareable {
    private Map<String, Object> map;

    public JsonObject(String json) {
        if (json == null) {
            throw new NullPointerException();
        }
        this.fromJson(json);
        if (this.map == null) {
            throw new DecodeException("Invalid JSON object: " + json);
        }
    }

    public JsonObject() {
        this.map = new LinkedHashMap<String, Object>();
    }

    public JsonObject(Map<String, Object> map2) {
        if (map2 == null) {
            throw new NullPointerException();
        }
        this.map = map2;
    }

    public JsonObject(Buffer buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        this.fromBuffer(buf);
        if (this.map == null) {
            throw new DecodeException("Invalid JSON object: " + buf);
        }
    }

    public static JsonObject mapFrom(Object obj2) {
        if (obj2 == null) {
            return null;
        }
        return new JsonObject(JsonCodec.INSTANCE.fromValue(obj2, Map.class));
    }

    public <T> T mapTo(Class<T> type2) {
        return JsonCodec.INSTANCE.fromValue(this.map, type2);
    }

    public String getString(String key2) {
        Objects.requireNonNull(key2);
        CharSequence cs = (CharSequence)this.map.get(key2);
        return cs == null ? null : cs.toString();
    }

    public Number getNumber(String key2) {
        Objects.requireNonNull(key2);
        return (Number)this.map.get(key2);
    }

    public Integer getInteger(String key2) {
        Objects.requireNonNull(key2);
        Number number2 = (Number)this.map.get(key2);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Integer) {
            return (Integer)number2;
        }
        return number2.intValue();
    }

    public Long getLong(String key2) {
        Objects.requireNonNull(key2);
        Number number2 = (Number)this.map.get(key2);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Long) {
            return (Long)number2;
        }
        return number2.longValue();
    }

    public Double getDouble(String key2) {
        Objects.requireNonNull(key2);
        Number number2 = (Number)this.map.get(key2);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Double) {
            return (Double)number2;
        }
        return number2.doubleValue();
    }

    public Float getFloat(String key2) {
        Objects.requireNonNull(key2);
        Number number2 = (Number)this.map.get(key2);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Float) {
            return (Float)number2;
        }
        return Float.valueOf(number2.floatValue());
    }

    public Boolean getBoolean(String key2) {
        Objects.requireNonNull(key2);
        return (Boolean)this.map.get(key2);
    }

    public JsonObject getJsonObject(String key2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        if (val2 instanceof Map) {
            val2 = new JsonObject((Map)val2);
        }
        return (JsonObject)val2;
    }

    public JsonArray getJsonArray(String key2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        if (val2 instanceof List) {
            val2 = new JsonArray((List)val2);
        }
        return (JsonArray)val2;
    }

    public byte[] getBinary(String key2) {
        Objects.requireNonNull(key2);
        String encoded = (String)this.map.get(key2);
        return encoded == null ? null : Base64.getDecoder().decode(encoded);
    }

    public Instant getInstant(String key2) {
        Objects.requireNonNull(key2);
        String encoded = (String)this.map.get(key2);
        return encoded == null ? null : Instant.from(DateTimeFormatter.ISO_INSTANT.parse(encoded));
    }

    public Object getValue(String key2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        if (val2 instanceof Map) {
            val2 = new JsonObject((Map)val2);
        } else if (val2 instanceof List) {
            val2 = new JsonArray((List)val2);
        }
        return val2;
    }

    public String getString(String key2, String def2) {
        Objects.requireNonNull(key2);
        CharSequence cs = (CharSequence)this.map.get(key2);
        return cs != null || this.map.containsKey(key2) ? (cs == null ? null : cs.toString()) : def2;
    }

    public Number getNumber(String key2, Number def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getNumber(key2);
        }
        return def2;
    }

    public Integer getInteger(String key2, Integer def2) {
        Objects.requireNonNull(key2);
        Number val2 = (Number)this.map.get(key2);
        if (val2 == null) {
            if (this.map.containsKey(key2)) {
                return null;
            }
            return def2;
        }
        if (val2 instanceof Integer) {
            return (Integer)val2;
        }
        return val2.intValue();
    }

    public Long getLong(String key2, Long def2) {
        Objects.requireNonNull(key2);
        Number val2 = (Number)this.map.get(key2);
        if (val2 == null) {
            if (this.map.containsKey(key2)) {
                return null;
            }
            return def2;
        }
        if (val2 instanceof Long) {
            return (Long)val2;
        }
        return val2.longValue();
    }

    public Double getDouble(String key2, Double def2) {
        Objects.requireNonNull(key2);
        Number val2 = (Number)this.map.get(key2);
        if (val2 == null) {
            if (this.map.containsKey(key2)) {
                return null;
            }
            return def2;
        }
        if (val2 instanceof Double) {
            return (Double)val2;
        }
        return val2.doubleValue();
    }

    public Float getFloat(String key2, Float def2) {
        Objects.requireNonNull(key2);
        Number val2 = (Number)this.map.get(key2);
        if (val2 == null) {
            if (this.map.containsKey(key2)) {
                return null;
            }
            return def2;
        }
        if (val2 instanceof Float) {
            return (Float)val2;
        }
        return Float.valueOf(val2.floatValue());
    }

    public Boolean getBoolean(String key2, Boolean def2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        return val2 != null || this.map.containsKey(key2) ? (Boolean)val2 : def2;
    }

    public JsonObject getJsonObject(String key2, JsonObject def2) {
        JsonObject val2 = this.getJsonObject(key2);
        return val2 != null || this.map.containsKey(key2) ? val2 : def2;
    }

    public JsonArray getJsonArray(String key2, JsonArray def2) {
        JsonArray val2 = this.getJsonArray(key2);
        return val2 != null || this.map.containsKey(key2) ? val2 : def2;
    }

    public byte[] getBinary(String key2, byte[] def2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        return val2 != null || this.map.containsKey(key2) ? (val2 == null ? null : Base64.getDecoder().decode((String)val2)) : def2;
    }

    public Instant getInstant(String key2, Instant def2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        return val2 != null || this.map.containsKey(key2) ? (val2 == null ? null : Instant.from(DateTimeFormatter.ISO_INSTANT.parse((String)val2))) : def2;
    }

    public Object getValue(String key2, Object def2) {
        Objects.requireNonNull(key2);
        Object val2 = this.getValue(key2);
        return val2 != null || this.map.containsKey(key2) ? val2 : def2;
    }

    public boolean containsKey(String key2) {
        Objects.requireNonNull(key2);
        return this.map.containsKey(key2);
    }

    public Set<String> fieldNames() {
        return this.map.keySet();
    }

    public JsonObject put(String key2, Enum value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value == null ? null : value.name());
        return this;
    }

    public JsonObject put(String key2, CharSequence value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value == null ? null : value.toString());
        return this;
    }

    public JsonObject put(String key2, String value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value);
        return this;
    }

    public JsonObject put(String key2, Integer value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value);
        return this;
    }

    public JsonObject put(String key2, Long value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value);
        return this;
    }

    public JsonObject put(String key2, Double value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value);
        return this;
    }

    public JsonObject put(String key2, Float value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value);
        return this;
    }

    public JsonObject put(String key2, Boolean value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value);
        return this;
    }

    public JsonObject putNull(String key2) {
        Objects.requireNonNull(key2);
        this.map.put(key2, null);
        return this;
    }

    public JsonObject put(String key2, JsonObject value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value);
        return this;
    }

    public JsonObject put(String key2, JsonArray value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value);
        return this;
    }

    public JsonObject put(String key2, byte[] value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value == null ? null : Base64.getEncoder().encodeToString(value));
        return this;
    }

    public JsonObject put(String key2, Instant value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value == null ? null : DateTimeFormatter.ISO_INSTANT.format(value));
        return this;
    }

    public JsonObject put(String key2, Object value) {
        Objects.requireNonNull(key2);
        value = JsonObject.checkAndCopy(value, false);
        this.map.put(key2, value);
        return this;
    }

    public Object remove(String key2) {
        return this.map.remove(key2);
    }

    public JsonObject mergeIn(JsonObject other) {
        return this.mergeIn(other, false);
    }

    public JsonObject mergeIn(JsonObject other, boolean deep) {
        return this.mergeIn(other, deep ? Integer.MAX_VALUE : 1);
    }

    public JsonObject mergeIn(JsonObject other, int depth) {
        if (depth < 1) {
            return this;
        }
        if (depth == 1) {
            this.map.putAll(other.map);
            return this;
        }
        for (Map.Entry<String, Object> e2 : other.map.entrySet()) {
            if (e2.getValue() == null) {
                this.map.put(e2.getKey(), null);
                continue;
            }
            this.map.merge(e2.getKey(), e2.getValue(), (oldVal, newVal) -> {
                if (oldVal instanceof Map) {
                    oldVal = new JsonObject((Map)oldVal);
                }
                if (newVal instanceof Map) {
                    newVal = new JsonObject((Map)newVal);
                }
                if (oldVal instanceof JsonObject && newVal instanceof JsonObject) {
                    return ((JsonObject)oldVal).mergeIn((JsonObject)newVal, depth - 1);
                }
                return newVal;
            });
        }
        return this;
    }

    public String encode() {
        return JsonCodec.INSTANCE.toString(this.map, false);
    }

    public String encodePrettily() {
        return JsonCodec.INSTANCE.toString(this.map, true);
    }

    public Buffer toBuffer() {
        return JsonCodec.INSTANCE.toBuffer(this.map, false);
    }

    @Override
    public JsonObject copy() {
        HashMap copiedMap = this.map instanceof LinkedHashMap ? new LinkedHashMap(this.map.size()) : new HashMap(this.map.size());
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object val2 = entry.getValue();
            val2 = JsonObject.checkAndCopy(val2, true);
            copiedMap.put((String)entry.getKey(), (Object)val2);
        }
        return new JsonObject(copiedMap);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public Stream<Map.Entry<String, Object>> stream() {
        return JsonObject.asStream(this.iterator());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new Iter(this.map.entrySet().iterator());
    }

    public int size() {
        return this.map.size();
    }

    @Fluent
    public JsonObject clear() {
        this.map.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return JsonObject.objectEquals(this.map, o);
    }

    private static boolean objectEquals(Map<?, ?> m1, Object o2) {
        Map m22;
        if (o2 instanceof JsonObject) {
            m22 = ((JsonObject)o2).map;
        } else if (o2 instanceof Map) {
            m22 = (Map)o2;
        } else {
            return false;
        }
        if (!m1.keySet().equals(m22.keySet())) {
            return false;
        }
        for (Map.Entry<?, ?> entry : m1.entrySet()) {
            Object val1 = entry.getValue();
            Object val2 = m22.get(entry.getKey());
            if (!(val1 == null ? val2 != null : !JsonObject.equals(val1, val2))) continue;
            return false;
        }
        return true;
    }

    static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof JsonObject) {
            return JsonObject.objectEquals(((JsonObject)o1).map, o2);
        }
        if (o1 instanceof Map) {
            return JsonObject.objectEquals((Map)o1, o2);
        }
        if (o1 instanceof JsonArray) {
            return JsonArray.arrayEquals(((JsonArray)o1).getList(), o2);
        }
        if (o1 instanceof List) {
            return JsonArray.arrayEquals((List)o1, o2);
        }
        if (o1 instanceof Number && o2 instanceof Number && o1.getClass() != o2.getClass()) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            if (o1 instanceof Float || o1 instanceof Double || o2 instanceof Float || o2 instanceof Double) {
                return n1.doubleValue() == n2.doubleValue();
            }
            return n1.longValue() == n2.longValue();
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        String encoded = this.encode();
        byte[] bytes2 = encoded.getBytes(StandardCharsets.UTF_8);
        buffer.appendInt(bytes2.length);
        buffer.appendBytes(bytes2);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        int start2 = pos + 4;
        String encoded = buffer.getString(start2, start2 + length);
        this.fromJson(encoded);
        return pos + length + 4;
    }

    private void fromJson(String json) {
        this.map = JsonCodec.INSTANCE.fromString(json, Map.class);
    }

    private void fromBuffer(Buffer buf) {
        this.map = JsonCodec.INSTANCE.fromBuffer(buf, Map.class);
    }

    static Object checkAndCopy(Object val2, boolean copy2) {
        if (!(val2 == null || val2 instanceof Number && !(val2 instanceof BigDecimal) || val2 instanceof Boolean || val2 instanceof String || val2 instanceof Character)) {
            if (val2 instanceof CharSequence) {
                val2 = val2.toString();
            } else if (val2 instanceof JsonObject) {
                if (copy2) {
                    val2 = ((JsonObject)val2).copy();
                }
            } else if (val2 instanceof JsonArray) {
                if (copy2) {
                    val2 = ((JsonArray)val2).copy();
                }
            } else if (val2 instanceof Map) {
                val2 = copy2 ? new JsonObject((Map)val2).copy() : new JsonObject((Map)val2);
            } else if (val2 instanceof List) {
                val2 = copy2 ? new JsonArray((List)val2).copy() : new JsonArray((List)val2);
            } else if (val2 instanceof byte[]) {
                val2 = Base64.getEncoder().encodeToString((byte[])val2);
            } else if (val2 instanceof Instant) {
                val2 = DateTimeFormatter.ISO_INSTANT.format((Instant)val2);
            } else {
                throw new IllegalStateException("Illegal type in JsonObject: " + val2.getClass());
            }
        }
        return val2;
    }

    static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static final class Entry
    implements Map.Entry<String, Object> {
        final String key;
        final Object value;

        public Entry(String key2, Object value) {
            this.key = key2;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private class Iter
    implements Iterator<Map.Entry<String, Object>> {
        final Iterator<Map.Entry<String, Object>> mapIter;

        Iter(Iterator<Map.Entry<String, Object>> mapIter) {
            this.mapIter = mapIter;
        }

        @Override
        public boolean hasNext() {
            return this.mapIter.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Map.Entry<String, Object> entry = this.mapIter.next();
            if (entry.getValue() instanceof Map) {
                return new Entry(entry.getKey(), new JsonObject((Map)entry.getValue()));
            }
            if (entry.getValue() instanceof List) {
                return new Entry(entry.getKey(), new JsonArray((List)entry.getValue()));
            }
            return entry;
        }

        @Override
        public void remove() {
            this.mapIter.remove();
        }
    }
}

