/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.core.spi.json.JsonCodec;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class JsonArray
implements Iterable<Object>,
ClusterSerializable,
Shareable {
    private List<Object> list;

    public JsonArray(String json) {
        if (json == null) {
            throw new NullPointerException();
        }
        this.fromJson(json);
        if (this.list == null) {
            throw new DecodeException("Invalid JSON array: " + json);
        }
    }

    public JsonArray() {
        this.list = new ArrayList<Object>();
    }

    public JsonArray(List list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list = list;
    }

    public JsonArray(Buffer buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        this.fromBuffer(buf);
        if (this.list == null) {
            throw new DecodeException("Invalid JSON array: " + buf);
        }
    }

    public String getString(int pos) {
        CharSequence cs = (CharSequence)this.list.get(pos);
        return cs == null ? null : cs.toString();
    }

    public Number getNumber(int pos) {
        return (Number)this.list.get(pos);
    }

    public Integer getInteger(int pos) {
        Number number2 = (Number)this.list.get(pos);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Integer) {
            return (Integer)number2;
        }
        return number2.intValue();
    }

    public Long getLong(int pos) {
        Number number2 = (Number)this.list.get(pos);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Long) {
            return (Long)number2;
        }
        return number2.longValue();
    }

    public Double getDouble(int pos) {
        Number number2 = (Number)this.list.get(pos);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Double) {
            return (Double)number2;
        }
        return number2.doubleValue();
    }

    public Float getFloat(int pos) {
        Number number2 = (Number)this.list.get(pos);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Float) {
            return (Float)number2;
        }
        return Float.valueOf(number2.floatValue());
    }

    public Boolean getBoolean(int pos) {
        return (Boolean)this.list.get(pos);
    }

    public JsonObject getJsonObject(int pos) {
        Object val2 = this.list.get(pos);
        if (val2 instanceof Map) {
            val2 = new JsonObject((Map)val2);
        }
        return (JsonObject)val2;
    }

    public JsonArray getJsonArray(int pos) {
        Object val2 = this.list.get(pos);
        if (val2 instanceof List) {
            val2 = new JsonArray((List)val2);
        }
        return (JsonArray)val2;
    }

    public byte[] getBinary(int pos) {
        String val2 = (String)this.list.get(pos);
        if (val2 == null) {
            return null;
        }
        return Base64.getDecoder().decode(val2);
    }

    public Instant getInstant(int pos) {
        String val2 = (String)this.list.get(pos);
        if (val2 == null) {
            return null;
        }
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(val2));
    }

    public Object getValue(int pos) {
        Object val2 = this.list.get(pos);
        if (val2 instanceof Map) {
            val2 = new JsonObject((Map)val2);
        } else if (val2 instanceof List) {
            val2 = new JsonArray((List)val2);
        }
        return val2;
    }

    public boolean hasNull(int pos) {
        return this.list.get(pos) == null;
    }

    public JsonArray add(Enum value) {
        this.list.add(value != null ? value.name() : null);
        return this;
    }

    public JsonArray add(CharSequence value) {
        this.list.add(value != null ? value.toString() : null);
        return this;
    }

    public JsonArray add(String value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Integer value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Long value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Double value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Float value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Boolean value) {
        this.list.add(value);
        return this;
    }

    public JsonArray addNull() {
        this.list.add(null);
        return this;
    }

    public JsonArray add(JsonObject value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(JsonArray value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(byte[] value) {
        this.list.add(value != null ? Base64.getEncoder().encodeToString(value) : null);
        return this;
    }

    public JsonArray add(Instant value) {
        this.list.add(value != null ? DateTimeFormatter.ISO_INSTANT.format(value) : null);
        return this;
    }

    public JsonArray add(Object value) {
        value = JsonObject.checkAndCopy(value, false);
        this.list.add(value);
        return this;
    }

    public JsonArray addAll(JsonArray array2) {
        this.list.addAll(array2.list);
        return this;
    }

    public JsonArray set(int pos, Enum value) {
        this.list.set(pos, value != null ? value.name() : null);
        return this;
    }

    public JsonArray set(int pos, CharSequence value) {
        this.list.set(pos, value != null ? value.toString() : null);
        return this;
    }

    public JsonArray set(int pos, String value) {
        this.list.set(pos, value);
        return this;
    }

    public JsonArray set(int pos, Integer value) {
        this.list.set(pos, value);
        return this;
    }

    public JsonArray set(int pos, Long value) {
        this.list.set(pos, value);
        return this;
    }

    public JsonArray set(int pos, Double value) {
        this.list.set(pos, value);
        return this;
    }

    public JsonArray set(int pos, Float value) {
        this.list.set(pos, value);
        return this;
    }

    public JsonArray set(int pos, Boolean value) {
        this.list.set(pos, value);
        return this;
    }

    public JsonArray setNull(int pos) {
        this.list.set(pos, null);
        return this;
    }

    public JsonArray set(int pos, JsonObject value) {
        this.list.set(pos, value);
        return this;
    }

    public JsonArray set(int pos, JsonArray value) {
        this.list.set(pos, value);
        return this;
    }

    public JsonArray set(int pos, byte[] value) {
        this.list.set(pos, value != null ? Base64.getEncoder().encodeToString(value) : null);
        return this;
    }

    public JsonArray set(int pos, Instant value) {
        this.list.set(pos, value != null ? DateTimeFormatter.ISO_INSTANT.format(value) : null);
        return this;
    }

    public JsonArray set(int pos, Object value) {
        value = JsonObject.checkAndCopy(value, false);
        this.list.set(pos, value);
        return this;
    }

    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    public boolean remove(Object value) {
        return this.list.remove(value);
    }

    public Object remove(int pos) {
        Object removed = this.list.remove(pos);
        if (removed instanceof Map) {
            return new JsonObject((Map)removed);
        }
        if (removed instanceof ArrayList) {
            return new JsonArray((List)removed);
        }
        return removed;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List getList() {
        return this.list;
    }

    public JsonArray clear() {
        this.list.clear();
        return this;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iter(this.list.iterator());
    }

    public String encode() {
        return JsonCodec.INSTANCE.toString(this.list, false);
    }

    public Buffer toBuffer() {
        return JsonCodec.INSTANCE.toBuffer(this.list, false);
    }

    public String encodePrettily() {
        return JsonCodec.INSTANCE.toString(this.list, true);
    }

    @Override
    public JsonArray copy() {
        ArrayList<Object> copiedList = new ArrayList<Object>(this.list.size());
        for (Object val2 : this.list) {
            val2 = JsonObject.checkAndCopy(val2, true);
            copiedList.add(val2);
        }
        return new JsonArray(copiedList);
    }

    public Stream<Object> stream() {
        return JsonObject.asStream(this.iterator());
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return JsonArray.arrayEquals(this.list, o);
    }

    static boolean arrayEquals(List<?> l1, Object o2) {
        List l2;
        if (o2 instanceof JsonArray) {
            l2 = ((JsonArray)o2).list;
        } else if (o2 instanceof List) {
            l2 = (List)o2;
        } else {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator iter = l2.iterator();
        for (Object entry : l1) {
            Object other = iter.next();
            if (!(entry == null ? other != null : !JsonObject.equals(entry, other))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        String encoded = this.encode();
        byte[] bytes2 = encoded.getBytes();
        buffer.appendInt(bytes2.length);
        buffer.appendBytes(bytes2);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        int start2 = pos + 4;
        String encoded = buffer.getString(start2, start2 + length);
        this.fromJson(encoded);
        return pos + length + 4;
    }

    private void fromJson(String json) {
        this.list = JsonCodec.INSTANCE.fromString(json, List.class);
    }

    private void fromBuffer(Buffer buf) {
        this.list = JsonCodec.INSTANCE.fromBuffer(buf, List.class);
    }

    private class Iter
    implements Iterator<Object> {
        final Iterator<Object> listIter;

        Iter(Iterator<Object> listIter) {
            this.listIter = listIter;
        }

        @Override
        public boolean hasNext() {
            return this.listIter.hasNext();
        }

        @Override
        public Object next() {
            Object val2 = this.listIter.next();
            if (val2 instanceof Map) {
                val2 = new JsonObject((Map)val2);
            } else if (val2 instanceof List) {
                val2 = new JsonArray((List)val2);
            }
            return val2;
        }

        @Override
        public void remove() {
            this.listIter.remove();
        }
    }
}

