/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.time.Instant;
import java.util.Base64;

class ByteArrayDeserializer
extends JsonDeserializer<byte[]> {
    ByteArrayDeserializer() {
    }

    @Override
    public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            return Base64.getDecoder().decode(text);
        }
        catch (IllegalArgumentException e2) {
            throw new InvalidFormatException(p, "Expected a base64 encoded byte array", (Object)text, Instant.class);
        }
    }
}

