/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.Handler;
import io.vertx.core.impl.launcher.commands.ExecUtils;
import io.vertx.core.impl.launcher.commands.FileSelector;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Watcher
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Watcher.class);
    private final long gracePeriod;
    private final Map<File, Map<File, FileInfo>> fileMap = new LinkedHashMap<File, Map<File, FileInfo>>();
    private final Set<File> filesToWatch = new HashSet<File>();
    private final long scanPeriod;
    private final List<File> roots;
    private final File cwd;
    private long lastChange = -1L;
    private final List<String> includes;
    private final Handler<Handler<Void>> deploy;
    private final Handler<Handler<Void>> undeploy;
    private final String cmd;
    private volatile boolean closed;

    public Watcher(File root2, List<String> includes, Handler<Handler<Void>> deploy, Handler<Handler<Void>> undeploy, String onRedeployCommand, long gracePeriod, long scanPeriod) {
        this.gracePeriod = gracePeriod;
        this.includes = this.sanitizeIncludePatterns(includes);
        this.roots = Watcher.extractRoots(root2, this.includes);
        this.cwd = root2;
        LOGGER.info("Watched paths: " + this.roots);
        this.deploy = deploy;
        this.undeploy = undeploy;
        this.cmd = onRedeployCommand;
        this.scanPeriod = scanPeriod;
        this.addFilesToWatchedList(this.roots);
    }

    static List<File> extractRoots(File root2, List<String> includes) {
        return includes.stream().map(s2 -> {
            File file2;
            if (s2.startsWith("*")) {
                return root2.getAbsolutePath();
            }
            if (s2.contains("*")) {
                s2 = s2.substring(0, s2.indexOf("*"));
            }
            if ((file2 = new File((String)s2)).isAbsolute()) {
                return file2.getAbsolutePath();
            }
            return new File(root2, (String)s2).getAbsolutePath();
        }).collect(Collectors.toSet()).stream().map(File::new).collect(Collectors.toList());
    }

    private List<String> sanitizeIncludePatterns(List<String> includes) {
        return includes.stream().map(p -> {
            if (ExecUtils.isWindows()) {
                return p.replace('/', File.separatorChar);
            }
            return p.replace('\\', File.separatorChar);
        }).collect(Collectors.toList());
    }

    private void addFilesToWatchedList(List<File> roots) {
        roots.forEach(this::addFileToWatchedList);
    }

    private void addFileToWatchedList(File file2) {
        this.filesToWatch.add(file2);
        HashMap<File, FileInfo> map2 = new HashMap<File, FileInfo>();
        if (file2.isDirectory()) {
            File[] children2 = file2.listFiles();
            if (children2 != null) {
                for (File child : children2) {
                    map2.put(child, new FileInfo(child.lastModified(), child.length()));
                    if (!child.isDirectory()) continue;
                    this.addFileToWatchedList(child);
                }
            }
        } else {
            map2.put(file2, new FileInfo(file2.lastModified(), file2.length()));
        }
        this.fileMap.put(file2, map2);
    }

    private boolean changesHaveOccurred() {
        boolean changed = false;
        for (File toWatch : new HashSet<File>(this.filesToWatch)) {
            LinkedHashMap<Object, Object> newFiles = new LinkedHashMap<Object, Object>();
            if (toWatch.isDirectory()) {
                File[] files;
                File[] fileArray = files = toWatch.exists() ? toWatch.listFiles() : new File[]{};
                if (files == null) {
                    throw new IllegalStateException("Cannot scan the file system to detect file changes");
                }
                for (File file2 : files) {
                    newFiles.put(file2, file2);
                }
            } else {
                newFiles.put(toWatch, toWatch);
            }
            Map<File, FileInfo> currentFileMap = this.fileMap.get(toWatch);
            for (Map.Entry entry : new HashMap<File, FileInfo>(currentFileMap).entrySet()) {
                File currFile = (File)entry.getKey();
                FileInfo currInfo = (FileInfo)entry.getValue();
                File newFile = (File)newFiles.get(currFile);
                if (newFile == null) {
                    currentFileMap.remove(currFile);
                    if (currentFileMap.isEmpty()) {
                        this.fileMap.remove(toWatch);
                        this.filesToWatch.remove(toWatch);
                    }
                    LOGGER.trace("File: " + currFile + " has been deleted");
                    if (!this.match(currFile)) continue;
                    changed = true;
                    continue;
                }
                if (newFile.lastModified() == currInfo.lastModified && newFile.length() == currInfo.length) continue;
                currentFileMap.put(newFile, new FileInfo(newFile.lastModified(), newFile.length()));
                LOGGER.trace("File: " + currFile + " has been modified");
                if (!this.match(currFile)) continue;
                changed = true;
            }
            for (File file2 : newFiles.keySet()) {
                if (currentFileMap.containsKey(file2)) continue;
                currentFileMap.put(file2, new FileInfo(file2.lastModified(), file2.length()));
                if (file2.isDirectory()) {
                    this.addFileToWatchedList(file2);
                }
                LOGGER.trace("File was added: " + file2);
                if (!this.match(file2)) continue;
                changed = true;
            }
        }
        long now2 = System.currentTimeMillis();
        if (changed) {
            this.lastChange = now2;
        }
        if (this.lastChange != -1L && now2 - this.lastChange >= this.gracePeriod) {
            this.lastChange = -1L;
            return true;
        }
        return false;
    }

    protected boolean match(File file2) {
        String rel = null;
        String relFromCwd = null;
        for (File root2 : this.roots) {
            if (!file2.getAbsolutePath().startsWith(root2.getAbsolutePath())) continue;
            if (file2.getAbsolutePath().equals(root2.getAbsolutePath())) {
                rel = file2.getAbsolutePath();
                continue;
            }
            rel = file2.getAbsolutePath().substring(root2.getAbsolutePath().length() + 1);
        }
        if (rel == null) {
            LOGGER.warn("A change in " + file2.getAbsolutePath() + " has been detected, but the file does not belong to a watched roots: " + this.roots);
            return false;
        }
        if (file2.getAbsolutePath().startsWith(this.cwd.getAbsolutePath())) {
            relFromCwd = file2.getAbsolutePath().substring(this.cwd.getAbsolutePath().length() + 1);
        }
        for (String include : this.includes) {
            if ((relFromCwd == null || !FileSelector.matchPath(include, relFromCwd, !ExecUtils.isWindows())) && !FileSelector.matchPath(include, file2.getAbsolutePath(), !ExecUtils.isWindows())) continue;
            return true;
        }
        return false;
    }

    public Watcher watch() {
        new Thread(this).start();
        LOGGER.info("Starting the vert.x application in redeploy mode");
        this.deploy.handle(null);
        return this;
    }

    public void close() {
        LOGGER.info("Stopping redeployment");
        this.closed = true;
        this.undeploy.handle(null);
    }

    @Override
    public void run() {
        try {
            while (!this.closed) {
                if (this.changesHaveOccurred()) {
                    this.trigger();
                }
                Thread.sleep(this.scanPeriod);
            }
        }
        catch (Throwable e2) {
            LOGGER.error((Object)"An error have been encountered while watching resources - leaving the redeploy mode", e2);
            this.close();
        }
    }

    private void trigger() {
        long begin = System.currentTimeMillis();
        LOGGER.info("Redeploying!");
        this.undeploy.handle(v1 -> this.executeUserCommand(v2 -> this.deploy.handle(v3 -> {
            long end2 = System.currentTimeMillis();
            LOGGER.info("Redeployment done in " + (end2 - begin) + " ms.");
        })));
    }

    private void executeUserCommand(Handler<Void> onCompletion) {
        if (this.cmd != null) {
            try {
                ArrayList<String> command2 = new ArrayList<String>();
                if (ExecUtils.isWindows()) {
                    ExecUtils.addArgument(command2, "cmd");
                    ExecUtils.addArgument(command2, "/c");
                } else {
                    ExecUtils.addArgument(command2, "sh");
                    ExecUtils.addArgument(command2, "-c");
                }
                command2.add(this.cmd);
                Process process = new ProcessBuilder(command2).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).start();
                int status = process.waitFor();
                LOGGER.info("User command terminated with status " + status);
            }
            catch (Throwable e2) {
                LOGGER.error((Object)("Error while executing the on-redeploy command : '" + this.cmd + "'"), e2);
            }
        }
        onCompletion.handle(null);
    }

    private static final class FileInfo {
        long lastModified;
        long length;

        private FileInfo(long lastModified, long length) {
            this.lastModified = lastModified;
            this.length = length;
        }
    }
}

