/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Hidden;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.ParsedAsList;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.launcher.VertxLifecycleHooks;
import io.vertx.core.impl.launcher.commands.BareCommand;
import io.vertx.core.impl.launcher.commands.ExecUtils;
import io.vertx.core.impl.launcher.commands.Watcher;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.launcher.ExecutionContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@Name(value="run")
@Summary(value="Runs a verticle called <main-verticle> in its own instance of vert.x.")
public class RunCommand
extends BareCommand {
    protected DeploymentOptions deploymentOptions;
    protected boolean cluster;
    protected boolean ha;
    protected int instances;
    protected String config;
    protected boolean worker;
    protected String mainVerticle;
    protected List<String> redeploy;
    protected String vertxApplicationBackgroundId;
    protected String onRedeployCommand;
    protected Watcher watcher;
    private long redeployScanPeriod;
    private long redeployGracePeriod;
    private long redeployTerminationPeriod;

    @io.vertx.core.cli.annotations.Option(longName="ha", acceptValue=false, flag=true)
    @Description(value="If specified the verticle will be deployed as a high availability (HA) deployment. This means it can fail over to any other nodes in the cluster started with the same HA group.")
    public void setHighAvailability(boolean ha) {
        this.ha = ha;
    }

    @io.vertx.core.cli.annotations.Option(longName="cluster", acceptValue=false, flag=true)
    @Description(value="If specified then the vert.x instance will form a cluster with any other vert.x instances on the network.")
    public void setCluster(boolean cluster) {
        this.cluster = cluster;
    }

    @io.vertx.core.cli.annotations.Option(longName="worker", acceptValue=false)
    @Description(value="If specified then the verticle is a worker verticle.")
    public void setWorker(boolean worker) {
        this.worker = worker;
    }

    @io.vertx.core.cli.annotations.Option(longName="instances", argName="instances")
    @DefaultValue(value="1")
    @Description(value="Specifies how many instances of the verticle will be deployed. Defaults to 1.")
    public void setInstances(int instances) {
        this.instances = instances;
    }

    @io.vertx.core.cli.annotations.Option(longName="conf", argName="config")
    @Description(value="Specifies configuration that should be provided to the verticle. <config> should reference either a text file containing a valid JSON object which represents the configuration OR be a JSON string.")
    public void setConfig(String configuration) {
        this.config = configuration != null ? configuration.trim().replaceAll("^\"|\"$", "").replaceAll("^'|'$", "") : null;
    }

    @Argument(index=0, argName="main-verticle", required=true)
    @Description(value="The main verticle to deploy, it can be a fully qualified class name or a file.")
    public void setMainVerticle(String verticle) {
        this.mainVerticle = verticle;
    }

    @io.vertx.core.cli.annotations.Option(longName="redeploy", argName="includes")
    @Description(value="Enable automatic redeployment of the application. This option takes a set on includes as parameter indicating which files need to be watched. Patterns are separated by a comma.")
    @ParsedAsList
    public void setRedeploy(List<String> redeploy) {
        this.redeploy = redeploy;
    }

    @io.vertx.core.cli.annotations.Option(longName="onRedeploy", argName="cmd")
    @Description(value="Optional shell command executed when a redeployment is triggered (deprecated - will be removed in 3.3, use 'on-redeploy' instead")
    @Hidden
    @Deprecated
    public void setOnRedeployCommandOld(String command2) {
        this.out.println("[WARNING] the 'onRedeploy' option is deprecated, and will be removed in vert.x 3.3. Use 'on-redeploy' instead.");
        this.setOnRedeployCommand(command2);
    }

    @io.vertx.core.cli.annotations.Option(longName="on-redeploy", argName="cmd")
    @Description(value="Optional shell command executed when a redeployment is triggered")
    public void setOnRedeployCommand(String command2) {
        this.onRedeployCommand = command2;
    }

    @io.vertx.core.cli.annotations.Option(longName="redeploy-scan-period", argName="period")
    @Description(value="When redeploy is enabled, this option configures the file system scanning period to detect file changes. The time is given in milliseconds. 250 ms by default.")
    @DefaultValue(value="250")
    public void setRedeployScanPeriod(long period2) {
        this.redeployScanPeriod = period2;
    }

    @io.vertx.core.cli.annotations.Option(longName="redeploy-grace-period", argName="period")
    @Description(value="When redeploy is enabled, this option configures the grace period between 2 redeployments. The time is given in milliseconds. 1000 ms by default.")
    @DefaultValue(value="1000")
    public void setRedeployGracePeriod(long period2) {
        this.redeployGracePeriod = period2;
    }

    @io.vertx.core.cli.annotations.Option(longName="redeploy-termination-period", argName="period")
    @Description(value="When redeploy is enabled, this option configures the time waited to be sure that the previous version of the application has been stopped. It is useful on Windows, where the 'terminate' command may take time to be executed.The time is given in milliseconds. 0 ms by default.")
    @DefaultValue(value="0")
    public void setRedeployStopWaitingTime(long period2) {
        this.redeployTerminationPeriod = period2;
    }

    @Override
    public void setUp(ExecutionContext context) throws CLIException {
        super.setUp(context);
        CommandLine commandLine = this.executionContext.commandLine();
        if (!this.isClustered() && (commandLine.isOptionAssigned(this.executionContext.cli().getOption("cluster-host")) || commandLine.isOptionAssigned(this.executionContext.cli().getOption("cluster-port")) || commandLine.isOptionAssigned(this.executionContext.cli().getOption("cluster-public-host")) || commandLine.isOptionAssigned(this.executionContext.cli().getOption("cluster-public-port")))) {
            throw new CLIException("The -cluster-xxx options require -cluster to be enabled");
        }
        Option haGroupOption = this.executionContext.cli().getOption("hagroup");
        Option quorumOption = this.executionContext.cli().getOption("quorum");
        if (!this.ha && (commandLine.isOptionAssigned(haGroupOption) || commandLine.isOptionAssigned(quorumOption))) {
            throw new CLIException("The option -hagroup and -quorum requires -ha to be enabled");
        }
    }

    @Override
    public boolean isClustered() {
        return this.cluster || this.ha || this.options != null && this.options.getEventBusOptions().isClustered();
    }

    @Override
    public boolean getHA() {
        return this.ha;
    }

    @Override
    public void run() {
        if (this.redeploy == null || this.redeploy.isEmpty()) {
            JsonObject conf = this.getConfiguration();
            if (conf == null) {
                conf = new JsonObject();
            }
            this.afterConfigParsed(conf);
            super.run(this::afterStoppingVertx);
            if (this.vertx == null) {
                ExecUtils.exitBecauseOfVertxInitializationIssue();
            }
            if (this.vertx instanceof VertxInternal) {
                ((VertxInternal)this.vertx).addCloseHook(completionHandler -> {
                    try {
                        this.beforeStoppingVertx(this.vertx);
                        completionHandler.handle(Future.succeededFuture());
                    }
                    catch (Exception e2) {
                        completionHandler.handle(Future.failedFuture(e2));
                    }
                });
            }
            this.deploymentOptions = new DeploymentOptions();
            this.configureFromSystemProperties(this.deploymentOptions, "vertx.deployment.options.");
            this.deploymentOptions.setConfig(conf).setWorker(this.worker).setHa(this.ha).setInstances(this.instances);
            this.beforeDeployingVerticle(this.deploymentOptions);
            this.deploy();
        } else {
            this.initializeRedeployment();
        }
    }

    protected synchronized void initializeRedeployment() {
        if (this.watcher != null) {
            throw new IllegalStateException("Redeployment already started ? The watcher already exists");
        }
        this.vertxApplicationBackgroundId = UUID.randomUUID().toString() + "-redeploy";
        this.watcher = new Watcher(this.getCwd(), this.redeploy, this::startAsBackgroundApplication, this::stopBackgroundApplication, this.onRedeployCommand, this.redeployGracePeriod, this.redeployScanPeriod);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RunCommand.this.shutdownRedeployment();
            }
        });
        this.watcher.watch();
    }

    protected synchronized void shutdownRedeployment() {
        if (this.watcher != null) {
            this.watcher.close();
            this.watcher = null;
        }
    }

    protected synchronized void stopBackgroundApplication(Handler<Void> onCompletion) {
        this.executionContext.execute("stop", this.vertxApplicationBackgroundId, "--redeploy");
        if (this.redeployTerminationPeriod > 0L) {
            try {
                Thread.sleep(this.redeployTerminationPeriod);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
        if (onCompletion != null) {
            onCompletion.handle(null);
        }
    }

    protected void startAsBackgroundApplication(Handler<Void> onCompletion) {
        ArrayList<String> args2 = new ArrayList<String>();
        args2.add("run");
        args2.add("--vertx-id=" + this.vertxApplicationBackgroundId);
        args2.addAll(this.executionContext.commandLine().allArguments());
        if (this.cluster) {
            args2.add("--cluster");
        }
        if (this.clusterHost != null) {
            args2.add("--cluster-host=" + this.clusterHost);
        }
        if (this.clusterPort != 0) {
            args2.add("--cluster-port=" + this.clusterPort);
        }
        if (this.clusterPublicHost != null) {
            args2.add("--cluster-public-host=" + this.clusterPublicHost);
        }
        if (this.clusterPublicPort != -1) {
            args2.add("--cluster-public-port=" + this.clusterPublicPort);
        }
        if (this.ha) {
            args2.add("--ha");
        }
        if (this.haGroup != null && !this.haGroup.equals("__DEFAULT__")) {
            args2.add("--hagroup=" + this.haGroup);
        }
        if (this.quorum != -1) {
            args2.add("--quorum=" + this.quorum);
        }
        if (this.classpath != null && !this.classpath.isEmpty()) {
            args2.add("--classpath=" + this.classpath.stream().collect(Collectors.joining(File.pathSeparator)));
        }
        if (this.vertxOptions != null) {
            args2.add("--options");
            args2.add(this.vertxOptions);
        }
        if (this.config != null) {
            args2.add("--conf");
            args2.add(this.config);
        }
        if (this.instances != 1) {
            args2.add("--instances=" + this.instances);
        }
        if (this.worker) {
            args2.add("--worker");
        }
        if (this.systemProperties != null) {
            args2.addAll(this.systemProperties.stream().map(s2 -> "-D" + s2).collect(Collectors.toList()));
        }
        args2.add("--redirect-output");
        this.executionContext.execute("start", args2.toArray(new String[args2.size()]));
        if (onCompletion != null) {
            onCompletion.handle(null);
        }
    }

    protected void deploy() {
        this.deploy(this.mainVerticle, this.vertx, this.deploymentOptions, res -> {
            if (res.failed()) {
                res.cause().printStackTrace();
                this.handleDeployFailed(res.cause());
            }
        });
    }

    private void handleDeployFailed(Throwable cause) {
        if (this.executionContext.main() instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)this.executionContext.main()).handleDeployFailed(this.vertx, this.mainVerticle, this.deploymentOptions, cause);
        } else {
            ExecUtils.exitBecauseOfVertxDeploymentIssue();
        }
    }

    protected JsonObject getConfiguration() {
        return this.getJsonFromFileOrString(this.config, "conf");
    }

    protected void beforeDeployingVerticle(DeploymentOptions deploymentOptions) {
        Object main2 = this.executionContext.main();
        if (main2 instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main2).beforeDeployingVerticle(deploymentOptions);
        }
    }

    protected void afterConfigParsed(JsonObject config) {
        Object main2 = this.executionContext.main();
        if (main2 instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main2).afterConfigParsed(config);
        }
    }

    protected void beforeStoppingVertx(Vertx vertx) {
        Object main2 = this.executionContext.main();
        if (main2 instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main2).beforeStoppingVertx(vertx);
        }
    }

    protected void afterStoppingVertx() {
        Object main2 = this.executionContext.main();
        if (main2 instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main2).afterStoppingVertx();
        }
    }
}

