/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.launcher.DefaultCommand;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class ClasspathHandler
extends DefaultCommand {
    protected static final String PATH_SEP = System.getProperty("path.separator");
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected List<String> classpath;
    protected Object manager;
    private ClassLoader classloader;

    @Option(shortName="cp", longName="classpath", argName="classpath")
    @Description(value="Provides an extra classpath to be used for the verticle deployment.")
    public void setClasspath(String classpath) {
        if (classpath == null || classpath.isEmpty()) {
            this.classloader = ClasspathHandler.class.getClassLoader();
            this.classpath = Collections.emptyList();
        } else {
            this.classpath = Arrays.asList(classpath.split(PATH_SEP));
            this.classloader = this.createClassloader();
        }
    }

    protected synchronized ClassLoader createClassloader() {
        URL[] urls = (URL[])this.classpath.stream().map(path2 -> {
            File file2 = new File((String)path2);
            try {
                return file2.toURI().toURL();
            }
            catch (MalformedURLException e2) {
                throw new IllegalStateException(e2);
            }
        }).toArray(URL[]::new);
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    protected synchronized Object newInstance() {
        try {
            this.classloader = this.classpath == null || this.classpath.isEmpty() ? ClasspathHandler.class.getClassLoader() : this.createClassloader();
            Class<?> clazz = this.classloader.loadClass("io.vertx.core.impl.launcher.commands.VertxIsolatedDeployer");
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            this.log.error((Object)"Failed to load or instantiate the isolated deployer", e2);
            throw new IllegalStateException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Vertx create(VertxOptions options2) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader != null ? this.classloader : this.getClass().getClassLoader());
            Vertx vertx = Vertx.vertx(options2);
            return vertx;
        }
        catch (Exception e2) {
            this.log.error((Object)"Failed to create the vert.x instance", e2);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void create(VertxOptions options2, Handler<AsyncResult<Vertx>> resultHandler) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader != null ? this.classloader : this.getClass().getClassLoader());
            Vertx.clusteredVertx(options2, resultHandler);
        }
        catch (Exception e2) {
            this.log.error((Object)"Failed to create the vert.x instance", e2);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deploy(String verticle, Vertx vertx, DeploymentOptions options2, Handler<AsyncResult<String>> completionHandler) {
        if (this.manager == null) {
            this.manager = this.newInstance();
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            Method method = this.manager.getClass().getMethod("deploy", String.class, Vertx.class, DeploymentOptions.class, Handler.class);
            if (this.executionContext.get("Default-Verticle-Factory") != null && verticle.indexOf(58) == -1) {
                verticle = this.executionContext.get("Default-Verticle-Factory") + ":" + verticle;
            }
            method.invoke(this.manager, verticle, vertx, options2, completionHandler);
        }
        catch (InvocationTargetException e2) {
            this.log.error((Object)("Failed to deploy verticle " + verticle), e2.getCause());
        }
        catch (Exception e3) {
            this.log.error((Object)("Failed to deploy verticle " + verticle), e3);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

