/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxThread;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class VertxThreadFactory
implements ThreadFactory {
    private static final Object FOO = new Object();
    private static Map<VertxThread, Object> weakMap = new WeakHashMap<VertxThread, Object>();
    private final String prefix;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final BlockedThreadChecker checker;
    private final boolean worker;
    private final long maxExecTime;
    private final TimeUnit maxExecTimeUnit;

    private static synchronized void addToMap(VertxThread thread2) {
        weakMap.put(thread2, FOO);
    }

    protected VertxThreadFactory(String prefix, BlockedThreadChecker checker2, boolean worker, long maxExecTime, TimeUnit maxExecTimeUnit) {
        this.prefix = prefix;
        this.checker = checker2;
        this.worker = worker;
        this.maxExecTime = maxExecTime;
        this.maxExecTimeUnit = maxExecTimeUnit;
    }

    public static synchronized void unsetContext(ContextImpl ctx) {
        for (VertxThread thread2 : weakMap.keySet()) {
            if (thread2.getContext() != ctx) continue;
            thread2.setContext(null);
        }
    }

    protected VertxThread createVertxThread(Runnable target, String name2, boolean worker, long maxExecTime, TimeUnit maxExecTimeUnit) {
        return new VertxThread(target, name2, worker, maxExecTime, maxExecTimeUnit);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        VertxThread t3 = this.createVertxThread(runnable, this.prefix + this.threadCount.getAndIncrement(), this.worker, this.maxExecTime, this.maxExecTimeUnit);
        if (this.checker != null) {
            this.checker.registerThread(t3, t3);
        }
        VertxThreadFactory.addToMap(t3);
        t3.setDaemon(false);
        return t3;
    }
}

