/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.spi.VertxFactory;

public class VertxFactoryImpl
implements VertxFactory {
    @Override
    public Vertx vertx() {
        return this.vertx(new VertxOptions());
    }

    @Override
    public Vertx vertx(VertxOptions options2) {
        return this.vertx(options2, Transport.transport(options2.getPreferNativeTransport()));
    }

    @Override
    public Vertx vertx(VertxOptions options2, Transport transport) {
        if (options2.getEventBusOptions().isClustered()) {
            throw new IllegalArgumentException("Please use Vertx.clusteredVertx() to create a clustered Vert.x instance");
        }
        return VertxImpl.vertx(options2, transport);
    }

    @Override
    public void clusteredVertx(VertxOptions options2, Handler<AsyncResult<Vertx>> resultHandler) {
        this.clusteredVertx(options2, Transport.transport(options2.getPreferNativeTransport()), resultHandler);
    }

    @Override
    public void clusteredVertx(VertxOptions options2, Transport transport, Handler<AsyncResult<Vertx>> resultHandler) {
        options2.getEventBusOptions().setClustered(true);
        VertxImpl.clusteredVertx(options2, transport, resultHandler);
    }

    @Override
    public Context context() {
        return ContextImpl.context();
    }
}

