/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConversionHelper {
    public static Object toObject(Object obj2) {
        if (obj2 instanceof Map) {
            return ConversionHelper.toJsonObject((Map)obj2);
        }
        if (obj2 instanceof List) {
            return ConversionHelper.toJsonArray((List)obj2);
        }
        if (obj2 instanceof CharSequence) {
            return obj2.toString();
        }
        return obj2;
    }

    private static Object toJsonElement(Object obj2) {
        if (obj2 instanceof Map) {
            return ConversionHelper.toJsonObject((Map)obj2);
        }
        if (obj2 instanceof List) {
            return ConversionHelper.toJsonArray((List)obj2);
        }
        if (obj2 instanceof CharSequence) {
            return obj2.toString();
        }
        if (obj2 instanceof Buffer) {
            return Base64.getEncoder().encodeToString(((Buffer)obj2).getBytes());
        }
        return obj2;
    }

    public static JsonObject toJsonObject(Map<String, Object> map2) {
        if (map2 == null) {
            return null;
        }
        map2 = new LinkedHashMap<String, Object>(map2);
        map2.entrySet().forEach(e2 -> e2.setValue(ConversionHelper.toJsonElement(e2.getValue())));
        return new JsonObject(map2);
    }

    public static JsonArray toJsonArray(List<Object> list) {
        if (list == null) {
            return null;
        }
        list = new ArrayList<Object>(list);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ConversionHelper.toJsonElement(list.get(i)));
        }
        return new JsonArray(list);
    }

    public static <T> T fromObject(Object obj2) {
        if (obj2 instanceof JsonObject) {
            return (T)ConversionHelper.fromJsonObject((JsonObject)obj2);
        }
        if (obj2 instanceof JsonArray) {
            return (T)ConversionHelper.fromJsonArray((JsonArray)obj2);
        }
        return (T)obj2;
    }

    public static Map<String, Object> fromJsonObject(JsonObject json) {
        if (json == null) {
            return null;
        }
        LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>(json.getMap());
        map2.entrySet().forEach(entry -> entry.setValue(ConversionHelper.fromObject(entry.getValue())));
        return map2;
    }

    public static List<Object> fromJsonArray(JsonArray json) {
        if (json == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(json.getList());
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ConversionHelper.fromObject(list.get(i)));
        }
        return list;
    }
}

