/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Starter;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.CloseHooks;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.VertxThreadFactory;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

abstract class ContextImpl
implements ContextInternal {
    private static FastThreadLocal<Holder> holderLocal = new FastThreadLocal<Holder>(){

        @Override
        protected Holder initialValue() {
            return new Holder();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    private static final String THREAD_CHECKS_PROP_NAME = "vertx.threadChecks";
    private static final String DISABLE_TIMINGS_PROP_NAME = "vertx.disableContextTimings";
    private static final String DISABLE_TCCL_PROP_NAME = "vertx.disableTCCL";
    private static final boolean THREAD_CHECKS = Boolean.getBoolean("vertx.threadChecks");
    private static final boolean DISABLE_TIMINGS = Boolean.getBoolean("vertx.disableContextTimings");
    private static final boolean DISABLE_TCCL = Boolean.getBoolean("vertx.disableTCCL");
    protected final VertxInternal owner;
    protected final String deploymentID;
    protected final JsonObject config;
    private Deployment deployment;
    private CloseHooks closeHooks;
    private final ClassLoader tccl;
    private final EventLoop eventLoop;
    private ConcurrentMap<Object, Object> contextData;
    private volatile Handler<Throwable> exceptionHandler;
    protected final WorkerPool workerPool;
    protected final WorkerPool internalBlockingPool;
    final TaskQueue orderedTasks;
    protected final TaskQueue internalOrderedTasks;

    public static Context context() {
        Thread current = Thread.currentThread();
        if (current instanceof VertxThread) {
            return ((VertxThread)current).getContext();
        }
        if (current instanceof FastThreadLocalThread) {
            return ContextImpl.holderLocal.get().ctx;
        }
        return null;
    }

    private static EventLoop getEventLoop(VertxInternal vertx) {
        EventLoopGroup group = vertx.getEventLoopGroup();
        if (group != null) {
            return group.next();
        }
        return null;
    }

    protected ContextImpl(VertxInternal vertx, WorkerPool internalBlockingPool, WorkerPool workerPool, String deploymentID, JsonObject config, ClassLoader tccl) {
        this(vertx, ContextImpl.getEventLoop(vertx), internalBlockingPool, workerPool, deploymentID, config, tccl);
    }

    protected ContextImpl(VertxInternal vertx, EventLoop eventLoop, WorkerPool internalBlockingPool, WorkerPool workerPool, String deploymentID, JsonObject config, ClassLoader tccl) {
        if (DISABLE_TCCL && tccl != ClassLoader.getSystemClassLoader()) {
            log.warn("You have disabled TCCL checks but you have a custom TCCL to set.");
        }
        this.deploymentID = deploymentID;
        this.config = config;
        this.eventLoop = eventLoop;
        this.tccl = tccl;
        this.owner = vertx;
        this.workerPool = workerPool;
        this.internalBlockingPool = internalBlockingPool;
        this.orderedTasks = new TaskQueue();
        this.internalOrderedTasks = new TaskQueue();
        this.closeHooks = new CloseHooks(log);
    }

    static void setContext(ContextImpl context) {
        Thread current = Thread.currentThread();
        if (!(current instanceof VertxThread)) {
            throw new IllegalStateException("Attempt to setContext on non Vert.x thread " + Thread.currentThread());
        }
        ContextImpl.setContext((VertxThread)current, context);
    }

    private static void setContext(FastThreadLocalThread thread2, ContextImpl context) {
        if (thread2 instanceof VertxThread) {
            ((VertxThread)thread2).setContext(context);
        } else {
            Holder holder = holderLocal.get();
            holder.ctx = context;
        }
        if (!DISABLE_TCCL) {
            if (context != null) {
                context.setTCCL();
            } else {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    @Override
    public Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public void addCloseHook(Closeable hook) {
        this.closeHooks.add(hook);
    }

    @Override
    public boolean removeCloseHook(Closeable hook) {
        return this.closeHooks.remove(hook);
    }

    public void runCloseHooks(Handler<AsyncResult<Void>> completionHandler) {
        this.closeHooks.run(completionHandler);
        VertxThreadFactory.unsetContext(this);
    }

    abstract void executeAsync(Handler<Void> var1);

    abstract <T> void execute(T var1, Handler<T> var2);

    @Override
    public abstract boolean isEventLoopContext();

    @Override
    public abstract boolean isMultiThreadedWorkerContext();

    @Override
    public <T> T get(String key2) {
        return (T)this.contextData().get(key2);
    }

    @Override
    public void put(String key2, Object value) {
        this.contextData().put(key2, value);
    }

    @Override
    public boolean remove(String key2) {
        return this.contextData().remove(key2) != null;
    }

    @Override
    public boolean isWorkerContext() {
        return !this.isEventLoopContext();
    }

    static boolean isOnVertxThread(boolean worker) {
        Thread t3 = Thread.currentThread();
        if (t3 instanceof VertxThread) {
            VertxThread vt = (VertxThread)t3;
            return vt.isWorker() == worker;
        }
        return false;
    }

    @Override
    public final void executeFromIO(Handler<Void> task) {
        this.executeFromIO(null, task);
    }

    @Override
    public final <T> void executeFromIO(T value, Handler<T> task) {
        if (THREAD_CHECKS) {
            this.checkEventLoopThread();
        }
        this.execute(value, task);
    }

    private void checkEventLoopThread() {
        Thread current = Thread.currentThread();
        if (!(current instanceof FastThreadLocalThread)) {
            throw new IllegalStateException("Expected to be on Vert.x thread, but actually on: " + current);
        }
        if (current instanceof VertxThread && ((VertxThread)current).isWorker()) {
            throw new IllegalStateException("Event delivered on unexpected worker thread " + current);
        }
    }

    @Override
    public void runOnContext(Handler<Void> task) {
        try {
            this.executeAsync(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public String deploymentID() {
        return this.deploymentID;
    }

    @Override
    public JsonObject config() {
        return this.config;
    }

    @Override
    public List<String> processArgs() {
        List<String> processArgument = VertxCommandLauncher.getProcessArguments();
        return processArgument != null ? processArgument : Starter.PROCESS_ARGS;
    }

    @Override
    public EventLoop nettyEventLoop() {
        return this.eventLoop;
    }

    @Override
    public VertxInternal owner() {
        return this.owner;
    }

    @Override
    public <T> void executeBlockingInternal(Handler<Promise<T>> action, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(action, resultHandler, this.internalBlockingPool.executor(), this.internalOrderedTasks, this.internalBlockingPool.metrics());
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, resultHandler, this.workerPool.executor(), ordered ? this.orderedTasks : null, this.workerPool.metrics());
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue2, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, resultHandler, this.workerPool.executor(), queue2, this.workerPool.metrics());
    }

    <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler, Executor exec, TaskQueue queue2, PoolMetrics metrics) {
        Object queueMetric = metrics != null ? (Object)metrics.submitted() : null;
        try {
            Runnable command2 = () -> {
                VertxThread current = (VertxThread)Thread.currentThread();
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                if (!DISABLE_TIMINGS) {
                    current.executeStart();
                }
                Promise promise2 = Promise.promise();
                try {
                    ContextImpl.setContext(this);
                    blockingCodeHandler.handle(promise2);
                }
                catch (Throwable e2) {
                    promise2.tryFail(e2);
                }
                finally {
                    if (!DISABLE_TIMINGS) {
                        current.executeEnd();
                    }
                }
                Future res = promise2.future();
                if (metrics != null) {
                    metrics.end(execMetric, res.succeeded());
                }
                res.onComplete(ar -> {
                    if (resultHandler != null) {
                        this.runOnContext(v -> resultHandler.handle((AsyncResult)ar));
                    } else if (ar.failed()) {
                        this.reportException(ar.cause());
                    }
                });
            };
            if (queue2 != null) {
                queue2.execute(command2, exec);
            } else {
                exec.execute(command2);
            }
        }
        catch (RejectedExecutionException e2) {
            if (metrics != null) {
                metrics.rejected(queueMetric);
            }
            throw e2;
        }
    }

    @Override
    public synchronized ConcurrentMap<Object, Object> contextData() {
        if (this.contextData == null) {
            this.contextData = new ConcurrentHashMap<Object, Object>();
        }
        return this.contextData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> boolean executeTask(T arg, Handler<T> hTask) {
        Thread th = Thread.currentThread();
        if (!(th instanceof FastThreadLocalThread)) {
            throw new IllegalStateException("Uh oh! context executing with wrong thread! " + th);
        }
        FastThreadLocalThread current = (FastThreadLocalThread)th;
        if (!DISABLE_TIMINGS) {
            this.executeStart(current);
        }
        try {
            ContextImpl.setContext(current, this);
            hTask.handle(arg);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t3) {
            this.reportException(t3);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!DISABLE_TIMINGS) {
                this.executeEnd(current);
            }
        }
    }

    private void executeStart(FastThreadLocalThread thread2) {
        if (thread2 instanceof VertxThread) {
            ((VertxThread)thread2).executeStart();
        } else {
            Holder holder = holderLocal.get();
            if (holder.checker == null) {
                BlockedThreadChecker checker2;
                holder.checker = checker2 = this.owner().blockedThreadChecker();
                holder.maxExecTime = this.owner.maxEventLoopExecTime();
                holder.maxExecTimeUnit = this.owner.maxEventLoopExecTimeUnit();
                checker2.registerThread(thread2, holder);
            }
            holder.startTime = System.nanoTime();
        }
    }

    private void executeEnd(FastThreadLocalThread thread2) {
        if (thread2 instanceof VertxThread) {
            ((VertxThread)thread2).executeEnd();
        } else {
            Holder holder = holderLocal.get();
            holder.startTime = 0L;
        }
    }

    @Override
    public void reportException(Throwable t3) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler == null) {
            handler = this.owner.exceptionHandler();
        }
        if (handler != null) {
            handler.handle(t3);
        } else {
            log.error((Object)"Unhandled exception", t3);
        }
    }

    private void setTCCL() {
        Thread.currentThread().setContextClassLoader(this.tccl);
    }

    @Override
    public Context exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public int getInstanceCount() {
        if (this.deployment == null) {
            return 0;
        }
        if (this.deployment.deploymentOptions() == null) {
            return 1;
        }
        return this.deployment.deploymentOptions().getInstances();
    }

    static class Holder
    implements BlockedThreadChecker.Task {
        BlockedThreadChecker checker;
        ContextInternal ctx;
        long startTime = 0L;
        long maxExecTime = VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME;
        TimeUnit maxExecTimeUnit = VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME_UNIT;

        Holder() {
        }

        @Override
        public long startTime() {
            return this.startTime;
        }

        @Override
        public long maxExecTime() {
            return this.maxExecTime;
        }

        @Override
        public TimeUnit maxExecTimeUnit() {
            return this.maxExecTimeUnit;
        }
    }
}

